/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.beans.DataWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import com.klg.jclass.table.data.JCBeanFileDataSource;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DataEditor
extends TablePropertyEditor
implements ActionListener,
ItemListener,
FocusListener,
JCTableDataListener {
    private JRadioButton chbxTable;
    private JRadioButton chbxFile;
    private JTextField textFName;
    private JButton buttonColumns;
    private JButton buttonClear;
    private JButton buttonRows;
    private JButton buttonBrowse;
    private Point textDialogLocation = null;
    private JCEditableVectorDataSource tableSource = (JCEditableVectorDataSource)this.tableView.getDataSource();

    public DataEditor() {
        super(0);
        this.updatePixelWidth();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.textChanged(actionEvent);
        this.buttonPressed(actionEvent);
    }

    private void browseFile() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Load Data Source");
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.textFName.setText(file.getAbsolutePath());
            this.showSource();
        }
    }

    private void buttonPressed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonBrowse)) {
            this.browseFile();
        } else if (object.equals(this.buttonClear)) {
            this.clearData();
        } else if (object.equals(this.buttonColumns) || object.equals(this.buttonRows)) {
            this.editLabels(object.equals(this.buttonRows));
        }
    }

    private void clearData() {
        this.tableView.setRepaintEnabled(false);
        this.tableSource.removeTableDataListener(this);
        int n = 0;
        while (n < this.tableSource.getNumRows()) {
            int n2 = 0;
            while (n2 < this.tableSource.getNumColumns()) {
                this.tableSource.setCell(n, n2, "");
                ++n2;
            }
            ++n;
        }
        this.tableSource.addTableDataListener(this);
        this.updatePixelWidth();
        this.tableView.setRepaintEnabled(true);
        this.updateData();
    }

    public void dataChanged(JCTableDataEvent jCTableDataEvent) {
        this.updatePixelWidth();
        this.updateData();
    }

    private void editLabels(boolean bl) {
        TextDialog textDialog = new TextDialog(new JFrame(), String.valueOf(bl ? "Row" : "Column") + " Labels");
        JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)this.tableView.getDataSource();
        String string = bl ? DataEditor.toString(jCEditableVectorDataSource.getRowLabels(), "\n") : DataEditor.toString(jCEditableVectorDataSource.getColumnLabels(), "\n");
        textDialog.setText(string);
        textDialog.pack();
        if (this.textDialogLocation == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.textDialogLocation = new Point(Math.max((dimension.width - this.getSize().width) / 2, 0), Math.max((dimension.height - this.getSize().height) / 2, 0));
        }
        ((Component)textDialog).setLocation(this.textDialogLocation);
        textDialog.show();
        this.textDialogLocation = textDialog.getLocation();
        if (textDialog.getResult()) {
            string = textDialog.getText();
            if (bl) {
                jCEditableVectorDataSource.setRowLabels(DataEditor.toVector(string, "\n"));
            } else {
                jCEditableVectorDataSource.setColumnLabels(DataEditor.toVector(string, "\n"));
            }
            this.updateData();
        }
        this.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.textChanged(focusEvent);
    }

    public String getAsText() {
        return this.tableView.getData().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getData().getJavaInitializationString();
    }

    public Object getValue() {
        this.tableView.commitEdit(true);
        return this.tableView.getData();
    }

    protected void init() {
        super.init(true);
        this.tableView.setSelectionPolicy(0);
        this.tableView.setAllowCellResize(4);
    }

    private boolean isEmpty(Object object) {
        return object == null || !(object instanceof String) || ((String)object).trim().length() == 0;
    }

    private void itemChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.chbxTable) || object.equals(this.chbxFile)) {
            this.tableView.commitEdit(true);
            if (this.chbxTable.isSelected()) {
                if (this.tableSource == null) {
                    this.tableSource = new JCEditableVectorDataSource();
                }
                this.setDataSource(this.tableSource);
                this.setStateFile(false);
                this.updateSizePanel();
                this.updateData();
            } else {
                this.showSource();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        this.itemChanged(itemEvent);
    }

    protected JComponent makePropertyPanel() {
        this.chbxTable = new JRadioButton("table", true);
        this.chbxFile = new JRadioButton("file", false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chbxTable);
        buttonGroup.add(this.chbxFile);
        this.textFName = new JTextField();
        this.buttonClear = new JButton("Clear Cells");
        this.buttonColumns = new JButton("Column Labels...");
        this.buttonRows = new JButton("Row Labels...");
        this.buttonBrowse = new JButton("Browse...");
        DataEditor dataEditor = this;
        dataEditor.getClass();
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel(dataEditor, "Data source");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        groupPanel.add((Component)this.chbxTable, gridBagConstraints);
        groupPanel.add((Component)this.buttonClear, gridBagConstraints);
        groupPanel.add((Component)this.buttonColumns, gridBagConstraints);
        groupPanel.add((Component)this.buttonRows, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)this.chbxFile, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        groupPanel.add((Component)this.textFName, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        groupPanel.add((Component)this.buttonBrowse, gridBagConstraints);
        this.chbxTable.addItemListener(this);
        this.chbxFile.addItemListener(this);
        this.buttonClear.addActionListener(this);
        this.buttonColumns.addActionListener(this);
        this.buttonRows.addActionListener(this);
        this.buttonBrowse.addActionListener(this);
        this.textFName.addActionListener(this);
        this.textFName.addFocusListener(this);
        return groupPanel;
    }

    protected void setDataSource(TableDataModel tableDataModel) {
        if (this.tableView.getDataSource() != null) {
            this.tableView.getDataSource().removeTableDataListener(this);
        }
        this.tableView.setDataSource(tableDataModel);
        this.tableSource.addTableDataListener(this);
    }

    private void setSelected(boolean bl) {
        this.buttonColumns.setEnabled(bl);
        this.buttonClear.setEnabled(bl);
        this.buttonRows.setEnabled(bl);
    }

    private void setStateFile(boolean bl) {
        if (bl) {
            TablePropertyEditor.setSelected(this.chbxFile, true);
            this.tableView.setPixelWidth(-998, 33001);
        } else {
            TablePropertyEditor.setSelected(this.chbxTable, true);
            this.tableSource = (JCEditableVectorDataSource)this.tableView.getDataSource();
            this.updatePixelWidth();
        }
        this.setSelected(bl ^ true);
    }

    public void setValue(Object object) {
        boolean bl;
        if (object == null) {
            return;
        }
        if (this.tableView.getDataSource() != null) {
            this.tableView.getDataSource().removeTableDataListener(this);
        }
        this.tableView.setData((DataWrapper)object);
        TableDataModel tableDataModel = this.tableView.getDataSource();
        if (tableDataModel != null) {
            tableDataModel.addTableDataListener(this);
        }
        if (bl = tableDataModel instanceof JCBeanFileDataSource) {
            this.textFName.setText(((JCBeanFileDataSource)tableDataModel).getName());
        }
        this.setStateFile(bl);
        super.setValue(object);
    }

    protected void showSource() {
        TableDataModel tableDataModel = this.tableView.getDataSource();
        String string = this.textFName.getText().trim();
        if (tableDataModel instanceof JCBeanFileDataSource && ((JCBeanFileDataSource)tableDataModel).getName().equalsIgnoreCase(string)) {
            return;
        }
        this.tableView.commitEdit(true);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            JCBeanFileDataSource jCBeanFileDataSource = new JCBeanFileDataSource(string, fileInputStream);
            this.setDataSource(jCBeanFileDataSource);
            this.setStateFile(true);
            this.updateSizePanel();
            this.updateData();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (string.length() == 0) {
                this.errorMessageBox("Please enter data file name first.");
            } else if (this.chbxFile.isSelected()) {
                this.errorMessageBox("Specified data file is not found.");
            }
        }
        catch (IOException iOException) {
            this.errorMessageBox("Specified data file is not valid: " + iOException);
        }
        this.setStateFile(false);
    }

    private void textChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object.equals(this.textFName)) {
            this.showSource();
        }
    }

    public static String toString(Vector vector, String string) {
        if (vector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof String) {
                stringBuffer.append((String)e);
            }
            stringBuffer.append(string);
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static Vector toVector(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase(string2)) {
                string3 = "";
            } else if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            vector.addElement(string3);
        }
        return vector;
    }

    protected void updateData() {
        this.support.firePropertyChange("dataSource", null, this.getValue());
    }

    private void updatePixelWidth() {
        int n = 0;
        while (n < this.tableSource.getNumColumns()) {
            boolean bl = this.isEmpty(this.tableSource.getTableColumnLabel(n));
            if (bl) {
                int n2 = 0;
                while (n2 < this.tableSource.getNumRows()) {
                    Object object = this.tableSource.getTableDataItem(n2, n);
                    if (!this.isEmpty(object)) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (bl) {
                this.tableView.setPixelWidth(n, 70);
            } else {
                this.tableView.setPixelWidth(n, 33001);
            }
            ++n;
        }
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
    }

    class TextDialog
    extends JDialog
    implements ActionListener {
        private JTextArea text;
        private JButton buttonOK;
        private JButton buttonCancel;
        private boolean result = false;

        TextDialog(Frame frame, String string) {
            super(frame, string, true);
            this.getContentPane().setLayout(new BorderLayout(0, 10));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.text = new JTextArea("", 15, 50);
            jPanel.add("Center", this.text);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(2, 8, 8));
            this.buttonOK = new JButton("OK");
            jPanel2.add(this.buttonOK);
            this.buttonCancel = new JButton("Cancel");
            jPanel2.add(this.buttonCancel);
            this.getContentPane().add("Center", jPanel);
            this.getContentPane().add("South", jPanel2);
            this.buttonCancel.addActionListener(this);
            this.buttonOK.addActionListener(this);
            this.setLocation();
            this.pack();
            this.repaint();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                this.result = object.equals(this.buttonOK);
                ((Component)this).setVisible(false);
            }
        }

        public boolean getResult() {
            return this.result;
        }

        public String getText() {
            return this.text.getText();
        }

        private void setLocation() {
            Container container = this.getParent();
            Point point = container.getLocation();
            Dimension dimension = container.getSize();
            ((Component)this).setLocation(point.x + dimension.width / 2, point.y + dimension.height / 2);
        }

        public void setText(String string) {
            this.text.setText(string);
        }
    }
}

