/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.JCTable;
import java.awt.Rectangle;

public class PrintCellLayout
implements CellLayoutModel {
    protected JCTable table;
    protected int[] columnWidth;
    protected int[] columnPosition;
    protected int[] rowHeight;
    protected int[] rowPosition;
    protected int labelWidth = -999;
    protected int labelHeight = -999;
    protected int rows = 0;
    protected int columns = 0;

    public PrintCellLayout(int n, int n2) {
        this.rows = n = Math.max(1, n);
        this.columns = n2;
        this.rowHeight = new int[n];
        this.rowPosition = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.rowHeight[n3] = 21;
            ++n3;
        }
        this.calcPositions(this.rowPosition, this.labelHeight, this.rowHeight);
        this.columnWidth = new int[n2];
        this.columnPosition = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            this.columnWidth[n4] = -999;
            ++n4;
        }
        this.calcPositions(this.columnPosition, this.labelWidth, this.columnWidth);
    }

    public void addColumns(int n, int n2) {
    }

    public void addRows(int n, int n2) {
    }

    protected void calcPositions(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray2.length;
        if (n2 == 0) {
            return;
        }
        nArray[0] = n;
        int n3 = 1;
        while (n3 < n2) {
            nArray[n3] = nArray[n3 - 1] + nArray2[n3 - 1];
            ++n3;
        }
    }

    public void deleteColumns(int n, int n2) {
    }

    public void deleteRows(int n, int n2) {
    }

    public Rectangle getBounds(int n, int n2) {
        return this.getBounds(n, n2, new Rectangle());
    }

    public Rectangle getBounds(int n, int n2, int n3, int n4) {
        return this.getBounds(n, n2, n3, n4, new Rectangle());
    }

    public Rectangle getBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = this.getColumnPosition(n2);
        int n6 = this.getRowPosition(n);
        rectangle.setBounds(n5, n6, this.getColumnPosition(n4) + this.getWidth(n4) - n5, this.getRowPosition(n3) + this.getHeight(n3) - n6);
        return rectangle;
    }

    public Rectangle getBounds(int n, int n2, Rectangle rectangle) {
        rectangle.setBounds(this.getColumnPosition(n2), this.getRowPosition(n), this.getWidth(n2), this.getHeight(n));
        return rectangle;
    }

    public int getColumn(int n, int n2) {
        if (n < this.labelWidth) {
            return -1;
        }
        int n3 = this.columns - 1;
        while (n3 > 0) {
            if (n >= this.columnPosition[n3]) break;
            --n3;
        }
        return n3;
    }

    public int getColumnPosition(int n) {
        if (n == -1) {
            return 0;
        }
        return this.columnPosition[n];
    }

    public int getHeight(int n) {
        if (n == -1) {
            return this.labelHeight;
        }
        return this.rowHeight[n];
    }

    public int getRow(int n, int n2) {
        if (n2 < this.labelHeight) {
            return -1;
        }
        int n3 = this.rows - 1;
        while (n3 > 0) {
            if (n2 >= this.rowPosition[n3]) break;
            --n3;
        }
        return n3;
    }

    public int getRowPosition(int n) {
        if (n == -1) {
            return 0;
        }
        return this.rowPosition[n];
    }

    public JCTable getTable() {
        return this.table;
    }

    public int getWidth(int n) {
        if (n == -1) {
            return this.labelWidth;
        }
        return this.columnWidth[n];
    }

    public void moveColumns(int n, int n2, int n3) {
    }

    public void moveRows(int n, int n2, int n3) {
    }

    public void remapColumns(int[] nArray, int[] nArray2) {
    }

    public void remapRows(int[] nArray, int[] nArray2) {
    }

    public void resetColumns() {
    }

    public void resetRows() {
    }

    public void setHeight(int n, int n2) {
        if (n == -1) {
            this.labelHeight = Math.max(0, n2);
            this.calcPositions(this.rowPosition, this.labelHeight + (this.table != null ? this.table.getColumnLabelOffset() + 2 * this.table.getFrameBorderWidth() : 0), this.rowHeight);
        } else {
            int n3 = n2 - this.rowHeight[n];
            this.rowHeight[n] = Math.max(0, n2);
            int n4 = n + 1;
            while (n4 < this.rows) {
                int n5 = n4++;
                this.rowPosition[n5] = this.rowPosition[n5] + n3;
            }
        }
    }

    public void setHeight(int n, int n2, int n3) {
        int n4 = n;
        while (n4 <= n2) {
            this.setHeight(n4, n3);
            ++n4;
        }
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public void setWidth(int n, int n2) {
        if (n == -1) {
            this.labelWidth = Math.max(0, n2);
            this.calcPositions(this.columnPosition, this.labelWidth + (this.table != null ? this.table.getRowLabelOffset() + 2 * this.table.getFrameBorderWidth() : 0), this.columnWidth);
        } else {
            int n3 = n2 - this.columnWidth[n];
            this.columnWidth[n] = Math.max(0, n2);
            int n4 = n + 1;
            while (n4 < this.columns) {
                int n5 = n4++;
                this.columnPosition[n5] = this.columnPosition[n5] + n3;
            }
        }
    }

    public void setWidth(int n, int n2, int n3) {
        int n4 = n;
        while (n4 <= n2) {
            this.setWidth(n4, n3);
            ++n4;
        }
    }
}

