/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.StringCellRangeFlavor;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class InputHandler
implements Serializable {
    protected JCTable table;
    protected long when;
    protected int modifiers;
    protected int clickCount;
    protected boolean SELECTING = false;

    public InputHandler(JCTable jCTable) {
        this.table = jCTable;
    }

    public void getCellPosition(int n, int n2, JCCellPosition jCCellPosition) {
        CellAreaHandler cellAreaHandler = this.table.getCellAreaHandler();
        jCCellPosition.row = cellAreaHandler.getRow(n, n2);
        jCCellPosition.column = cellAreaHandler.getColumn(n, n2);
    }

    public boolean isAlt(int n) {
        return (n & 8) != 0;
    }

    public boolean isCell(int n, int n2) {
        return n > -1 && n2 > -1;
    }

    public boolean isControl(int n) {
        return (n & 2) != 0;
    }

    public boolean isCopyAction(AWTEvent aWTEvent, int n, int n2) {
        return this.table.getAction(aWTEvent, n, n2) == 6;
    }

    public boolean isLabel(int n, int n2) {
        return n == -1 || n2 == -1;
    }

    public boolean isMeta(int n) {
        return (n & 4) != 0;
    }

    public boolean isPasteAction(AWTEvent aWTEvent, int n, int n2) {
        return this.table.getAction(aWTEvent, n, n2) == 7;
    }

    public boolean isShift(int n) {
        return (n & 1) != 0;
    }

    protected void loadPasteData(Vector vector) {
        JCCellRange jCCellRange;
        if (this.table.getSelectedCells() != null && this.table.getSelectedCells().size() > 0) {
            JCCellRange jCCellRange2 = (JCCellRange)this.table.getSelectedCells().iterator().next();
            jCCellRange = new JCCellRange(Math.min(jCCellRange2.start_row, jCCellRange2.end_row), Math.min(jCCellRange2.start_column, jCCellRange2.end_column), Math.max(jCCellRange2.start_row, jCCellRange2.end_row), Math.max(jCCellRange2.start_column, jCCellRange2.end_column));
        } else {
            jCCellRange = new JCCellRange(this.table.current_row, this.table.current_column, this.table.getNumRows() - 1, this.table.getNumColumns() - 1);
        }
        if (jCCellRange.end_row == Integer.MAX_VALUE) {
            jCCellRange.end_row = this.table.getNumRows() - 1;
        }
        if (jCCellRange.end_column == Integer.MAX_VALUE) {
            jCCellRange.end_column = this.table.getNumColumns() - 1;
        }
        if (jCCellRange != null) {
            int n = vector.size();
            if (n == 0) {
                return;
            }
            int n2 = ((Vector)vector.elementAt(0)).size();
            int n3 = jCCellRange.start_row;
            int n4 = 0;
            while (n3 <= jCCellRange.end_row && n4 < n) {
                Vector vector2 = (Vector)vector.elementAt(n4);
                int n5 = jCCellRange.start_column;
                int n6 = 0;
                while (n5 <= jCCellRange.end_column && n6 < n2) {
                    if (n5 == -1 || n3 == -1) {
                        if (this.table.getDataView().getDataSource() instanceof JCVectorDataSource) {
                            JCVectorDataSource jCVectorDataSource = (JCVectorDataSource)this.table.getDataView().getDataSource();
                            if (n5 == -1) {
                                jCVectorDataSource.setRowLabel(n3, vector2.elementAt(n6));
                            } else if (n3 == -1) {
                                jCVectorDataSource.setColumnLabel(n5, vector2.elementAt(n6));
                            }
                        }
                    } else {
                        this.table.getDataView().setTableDataItem(vector2.elementAt(n6), n3, n5);
                    }
                    ++n5;
                    ++n6;
                }
                ++n3;
                ++n4;
            }
        }
    }

    public void performCopyAction() {
        JCCellRange jCCellRange;
        Object object;
        if (this.table.getSelectedCells() != null && this.table.getSelectedCells().size() > 0) {
            object = (JCCellRange)this.table.getSelectedCells().iterator().next();
            jCCellRange = new JCCellRange(Math.min(((JCCellRange)object).start_row, ((JCCellRange)object).end_row), Math.min(((JCCellRange)object).start_column, ((JCCellRange)object).end_column), Math.max(((JCCellRange)object).start_row, ((JCCellRange)object).end_row), Math.max(((JCCellRange)object).start_column, ((JCCellRange)object).end_column));
        } else {
            jCCellRange = new JCCellRange(this.table.current_row, this.table.current_column, this.table.current_row, this.table.current_column);
        }
        object = new StringCellRangeFlavor(this.table, jCCellRange);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, (ClipboardOwner)object);
    }

    public void performPasteAction() {
        block8: {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            if (transferable == null) break block8;
            try {
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                int n = 0;
                while (n < dataFlavorArray.length) {
                    if (dataFlavorArray[n].getHumanPresentableName().equals("CellRange")) {
                        Vector vector = (Vector)transferable.getTransferData(dataFlavorArray[n]);
                        this.loadPasteData(vector);
                        return;
                    }
                    if (dataFlavorArray[n].getHumanPresentableName().equals("Unicode String")) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)transferable.getTransferData(dataFlavorArray[n]), "\n", false);
                        Vector vector = new Vector();
                        while (stringTokenizer.hasMoreElements()) {
                            String string = (String)stringTokenizer.nextElement();
                            if (string == null) continue;
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\t", false);
                            Vector<String> vector2 = new Vector<String>();
                            while (stringTokenizer2.hasMoreElements()) {
                                vector2.addElement(stringTokenizer2.nextToken());
                            }
                            vector.addElement(vector2);
                        }
                        this.loadPasteData(vector);
                        return;
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                System.out.println("Error pasting data: " + iOException.getMessage());
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("Error pasting data: " + unsupportedFlavorException.getMessage());
            }
        }
    }
}

