/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.JCCellBorder;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableCellInfo;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;

public class CellAreaHandler
implements Serializable {
    protected JCTable table;
    protected CellArea cellArea;
    protected CellArea frozenRowArea;
    protected CellArea columnLabelArea;
    protected CellArea frozenColumnArea;
    protected CellArea frozenCellArea;
    protected CellArea frozenColumnLabelArea;
    protected CellArea rowLabelArea;
    protected CellArea frozenRowLabelArea;
    protected Vector areas = new Vector();
    protected CellAreaRenderer cellAreaRenderer;
    protected TableCellInfoModel cellInfo;
    protected Point cellOrigin = new Point(0, 0);
    protected boolean isStandardLayout = true;
    protected Rectangle rowLabelRect = null;
    protected Rectangle columnLabelRect = null;
    protected Rectangle cellRect = null;
    protected boolean DRAGGING = false;
    protected int drag_row = -999;
    protected int drag_column = -999;
    protected int drop_row = -999;
    protected int drop_column = -999;
    protected int[] drag_columns;
    protected int[] drag_rows;

    public CellAreaHandler(JCTable jCTable) {
        this.table = jCTable;
        this.cellAreaRenderer = new CellAreaRenderer(this);
        this.cellInfo = new JCTableCellInfo();
    }

    protected void cancelDrag() {
        this.DRAGGING = false;
        this.drag_row = -999;
        this.drag_column = -999;
        this.drop_row = -999;
        this.drop_column = -999;
    }

    protected CellArea contains(int n, int n2) {
        int n3 = 0;
        while (n3 < this.areas.size()) {
            CellArea cellArea = (CellArea)this.areas.elementAt(n3);
            if (cellArea.getBounds().contains(n, n2)) {
                return cellArea;
            }
            ++n3;
        }
        return null;
    }

    public CellArea createCellArea(int n) {
        switch (n) {
            case 0: {
                if (this.cellArea == null) {
                    this.cellArea = new CellArea(n);
                    this.areas.addElement(this.cellArea);
                    this.table.add(this.cellArea);
                }
                return this.cellArea;
            }
            case 2: {
                if (this.columnLabelArea == null) {
                    this.columnLabelArea = new CellArea(n);
                    this.areas.addElement(this.columnLabelArea);
                    this.table.add(this.columnLabelArea);
                }
                return this.columnLabelArea;
            }
            case 4: {
                if (this.frozenCellArea == null) {
                    this.frozenCellArea = new CellArea(n);
                    this.areas.addElement(this.frozenCellArea);
                    this.table.add(this.frozenCellArea);
                }
                return this.frozenCellArea;
            }
            case 3: {
                if (this.frozenColumnArea == null) {
                    this.frozenColumnArea = new CellArea(n);
                    this.areas.addElement(this.frozenColumnArea);
                    this.table.add(this.frozenColumnArea);
                }
                return this.frozenColumnArea;
            }
            case 5: {
                if (this.frozenColumnLabelArea == null) {
                    this.frozenColumnLabelArea = new CellArea(n);
                    this.areas.addElement(this.frozenColumnLabelArea);
                    this.table.add(this.frozenColumnLabelArea);
                }
                return this.frozenColumnLabelArea;
            }
            case 1: {
                if (this.frozenRowArea == null) {
                    this.frozenRowArea = new CellArea(n);
                    this.areas.addElement(this.frozenRowArea);
                    this.table.add(this.frozenRowArea);
                }
                return this.frozenRowArea;
            }
            case 7: {
                if (this.frozenRowLabelArea == null) {
                    this.frozenRowLabelArea = new CellArea(n);
                    this.areas.addElement(this.frozenRowLabelArea);
                    this.table.add(this.frozenRowLabelArea);
                }
                return this.frozenRowLabelArea;
            }
            case 6: {
                if (this.rowLabelArea == null) {
                    this.rowLabelArea = new CellArea(n);
                    this.areas.addElement(this.rowLabelArea);
                    this.table.add(this.rowLabelArea);
                }
                return this.rowLabelArea;
            }
        }
        return null;
    }

    public void createRequiredCellAreas() {
        int n = this.table.getDataView().getNumColumns();
        int n2 = this.table.getDataView().getNumRows();
        int n3 = this.table.getFrozenColumns();
        int n4 = this.table.getFrozenRows();
        CellArea cellArea = null;
        if (n > 0 && n2 > 0) {
            cellArea = this.createCellArea(0);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(0);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.cellArea = null;
            }
        }
        if (n4 > 0 && n3 > 0) {
            cellArea = this.createCellArea(4);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(4);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenCellArea = null;
            }
        }
        if (n4 > 0 && n2 > 0 && n > 0) {
            cellArea = this.createCellArea(1);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(1);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenRowArea = null;
            }
        }
        if (n3 > 0 && n2 > 0 && n > 0) {
            cellArea = this.createCellArea(3);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(3);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenColumnArea = null;
            }
        }
        if (n4 > 0 && n2 > 0 && this.table.isRowLabelDisplay()) {
            cellArea = this.createCellArea(7);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(7);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenRowLabelArea = null;
            }
        }
        if (n2 > 0 && this.table.isRowLabelDisplay()) {
            cellArea = this.createCellArea(6);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(6);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.rowLabelArea = null;
            }
        }
        if (n3 > 0 && n > 0 && this.table.isColumnLabelDisplay()) {
            cellArea = this.createCellArea(5);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(5);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.frozenColumnLabelArea = null;
            }
        }
        if (n > 0 && this.table.isColumnLabelDisplay()) {
            cellArea = this.createCellArea(2);
            this.setAreaCellRange(cellArea);
            cellArea.setVisible(true);
        } else {
            cellArea = this.findByType(2);
            if (cellArea != null) {
                this.areas.removeElement(cellArea);
                this.table.remove(cellArea);
                this.columnLabelArea = null;
            }
        }
    }

    protected int determineThinSides(int n, int n2) {
        CellArea cellArea = this.table.getCellAreaHandler().find(n, n2);
        if (cellArea == null) {
            return 0;
        }
        return this.determineThinSides(n, n2, cellArea.getEndRow(), cellArea.getEndColumn());
    }

    protected int determineThinSides(int n, int n2, int n3, int n4) {
        int n5 = 0;
        TableCellInfoModel tableCellInfoModel = this.getTableCellInfo();
        CellBorderModel cellBorderModel = tableCellInfoModel.getCellBorder();
        if (cellBorderModel != null && cellBorderModel instanceof JCCellBorder) {
            JCCellBorder jCCellBorder = (JCCellBorder)cellBorderModel;
            if (jCCellBorder.borderType == 8) {
                int n6 = this.table.getFrozenColumns();
                int n7 = this.table.getFrozenColumnPlacement();
                if ((n6 <= 0 || n2 >= n6 && n7 == 2 || n2 < n6 && n7 == 4) && n2 == n4) {
                    n5 |= 0x10;
                }
                int n8 = this.table.getFrozenRows();
                int n9 = this.table.getFrozenRowPlacement();
                if ((n8 <= 0 || n >= n8 && n9 == 1 || n < n8 && n9 == 3) && n == n3) {
                    n5 |= 0x20;
                }
            }
        }
        return n5;
    }

    protected void endDrag() {
        this.DRAGGING = false;
        this.drag_row = -999;
        this.drag_column = -999;
        this.drop_row = -999;
        this.drop_column = -999;
    }

    public CellArea find(int n, int n2) {
        int n3 = 0;
        while (n3 < this.areas.size()) {
            CellArea cellArea = (CellArea)this.areas.elementAt(n3);
            if (cellArea.containsCell(n, n2)) {
                return cellArea;
            }
            ++n3;
        }
        return null;
    }

    public CellArea findByType(int n) {
        switch (n) {
            case 0: {
                return this.cellArea;
            }
            case 2: {
                return this.columnLabelArea;
            }
            case 4: {
                return this.frozenCellArea;
            }
            case 3: {
                return this.frozenColumnArea;
            }
            case 5: {
                return this.frozenColumnLabelArea;
            }
            case 1: {
                return this.frozenRowArea;
            }
            case 7: {
                return this.frozenRowLabelArea;
            }
            case 6: {
                return this.rowLabelArea;
            }
        }
        return null;
    }

    public Rectangle getBounds(int n, int n2) {
        return this.getBounds(n, n2, new Rectangle());
    }

    public Rectangle getBounds(int n, int n2, int n3, int n4) {
        if (!this.DRAGGING) {
            Rectangle rectangle = new Rectangle();
            rectangle = this.table.getCellLayout().getBounds(n, n2, n3, n4, rectangle);
            CellArea cellArea = this.find(n, n2);
            if (cellArea == null) {
                return rectangle;
            }
            rectangle.x += cellArea.getX() - cellArea.getStandardOffsetX();
            rectangle.y += cellArea.getY() - cellArea.getStandardOffsetY();
            return rectangle;
        }
        Rectangle rectangle = new Rectangle();
        rectangle = this.getBounds(n, n2, rectangle);
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        rectangle = this.getBounds(n3, n4, rectangle);
        rectangle.width = rectangle.x + rectangle.width - n5;
        rectangle.height = rectangle.y + rectangle.height - n6;
        rectangle.x = n5;
        rectangle.y = n6;
        return rectangle;
    }

    public Rectangle getBounds(int n, int n2, Rectangle rectangle) {
        Serializable serializable;
        rectangle = !this.DRAGGING ? this.table.getCellLayout().getBounds(n, n2, rectangle) : this.getDragBounds(n, n2);
        if (this.table.spanHandler != null && (serializable = this.table.spanHandler.getSpannedRange(n, n2)) != null && this.table.spanHandler.isControllingCell((JCCellRange)serializable, n, n2)) {
            int n3 = Math.min(((JCCellRange)serializable).end_row, this.table.getNumRows() - 1);
            int n4 = n + 1;
            while (n4 <= n3) {
                rectangle.height += this.getBounds((int)n4, (int)n2).height;
                ++n4;
            }
            int n5 = Math.min(((JCCellRange)serializable).end_column, this.table.getNumColumns() - 1);
            int n6 = n2 + 1;
            while (n6 <= n5) {
                rectangle.width += this.getBounds((int)n, (int)n6).width;
                ++n6;
            }
        }
        if ((serializable = this.find(n, n2)) == null) {
            return rectangle;
        }
        rectangle.x += ((JComponent)serializable).getX() - ((CellArea)serializable).getStandardOffsetX();
        rectangle.y += ((JComponent)serializable).getY() - ((CellArea)serializable).getStandardOffsetY();
        return rectangle;
    }

    public CellArea getCellArea() {
        return this.cellArea;
    }

    public CellAreaRenderer getCellAreaRenderer() {
        return this.cellAreaRenderer;
    }

    public Vector getCellAreas() {
        return this.areas;
    }

    public Point getCellOrigin() {
        return this.cellOrigin;
    }

    public int getColumn(int n, int n2) {
        CellArea cellArea = this.contains(n, n2);
        if (cellArea == null) {
            return -999;
        }
        n += -cellArea.getX() + cellArea.getStandardOffsetX();
        n2 += -cellArea.getY() + cellArea.getStandardOffsetY();
        if (cellArea.isHorizontalScrollable()) {
            n -= this.cellOrigin.x;
        }
        if (cellArea.isVerticalScrollable()) {
            n2 -= this.cellOrigin.y;
        }
        return this.table.getCellLayout().getColumn(n, n2);
    }

    public Rectangle getDragBounds(int n, int n2) {
        if (this.drag_row == -1 && n2 != -1) {
            if (this.drag_columns != null) {
                if (n2 == this.drag_columns[n2]) {
                    return this.table.getCellLayout().getBounds(n, n2);
                }
                Rectangle rectangle = this.table.getCellLayout().getBounds(n, n2);
                rectangle.x = this.getTransposedX(n2, this.drag_column, this.drop_column);
                return rectangle;
            }
            return this.table.getCellLayout().getBounds(n, n2);
        }
        if (this.drag_column == -1 && n != -1) {
            if (this.drag_rows != null) {
                if (n == this.drag_rows[n]) {
                    return this.table.getCellLayout().getBounds(n, n2);
                }
                Rectangle rectangle = this.table.getCellLayout().getBounds(n, n2);
                rectangle.y = this.getTransposedY(n, this.drag_row, this.drop_row);
                return rectangle;
            }
            return this.table.getCellLayout().getBounds(n, n2);
        }
        return this.table.getCellLayout().getBounds(n, n2);
    }

    public int getRow(int n, int n2) {
        CellArea cellArea = this.contains(n, n2);
        if (cellArea == null) {
            return -999;
        }
        n += -cellArea.getX() + cellArea.getStandardOffsetX();
        n2 += -cellArea.getY() + cellArea.getStandardOffsetY();
        if (cellArea.isHorizontalScrollable()) {
            n -= this.cellOrigin.x;
        }
        if (cellArea.isVerticalScrollable()) {
            n2 -= this.cellOrigin.y;
        }
        return this.table.getCellLayout().getRow(n, n2);
    }

    public JCTable getTable() {
        return this.table;
    }

    public TableCellInfoModel getTableCellInfo() {
        return this.cellInfo;
    }

    protected int getTransposedX(int n, int n2, int n3) {
        CellLayoutModel cellLayoutModel = this.table.getCellLayout();
        if (n2 < n3) {
            if (n < n2) {
                return cellLayoutModel.getBounds((int)-1, (int)n).x;
            }
            if (n == n2) {
                if (n3 >= this.table.getNumColumns()) {
                    Rectangle rectangle = cellLayoutModel.getBounds(-1, this.table.getNumColumns() - 1);
                    return rectangle.x + rectangle.width - cellLayoutModel.getBounds((int)-1, (int)n).width;
                }
                return cellLayoutModel.getBounds((int)-1, (int)n3).x - cellLayoutModel.getBounds((int)-1, (int)n).width;
            }
            if (n < n3) {
                return cellLayoutModel.getBounds((int)-1, (int)n).x - cellLayoutModel.getBounds((int)-1, (int)n2).width;
            }
        } else if (n2 > n3) {
            if (n < n3) {
                return cellLayoutModel.getBounds((int)-1, (int)n).x;
            }
            if (n == n2) {
                return cellLayoutModel.getBounds((int)-1, (int)n3).x;
            }
            if (n >= n3) {
                return cellLayoutModel.getBounds((int)-1, (int)n).x + cellLayoutModel.getBounds((int)-1, (int)n2).width;
            }
        }
        return cellLayoutModel.getBounds((int)-1, (int)n).x;
    }

    protected int getTransposedY(int n, int n2, int n3) {
        CellLayoutModel cellLayoutModel = this.table.getCellLayout();
        if (n2 < n3) {
            if (n < n2) {
                return cellLayoutModel.getBounds((int)n, (int)-1).y;
            }
            if (n == n2) {
                if (n3 >= this.table.getNumRows()) {
                    Rectangle rectangle = cellLayoutModel.getBounds(this.table.getNumRows() - 1, -1);
                    return rectangle.y + rectangle.height - cellLayoutModel.getBounds((int)n, (int)-1).height;
                }
                return cellLayoutModel.getBounds((int)n3, (int)-1).y - cellLayoutModel.getBounds((int)n, (int)-1).height;
            }
            if (n < n3) {
                return cellLayoutModel.getBounds((int)n, (int)-1).y - cellLayoutModel.getBounds((int)n2, (int)-1).height;
            }
        } else if (n2 > n3) {
            if (n < n3) {
                return cellLayoutModel.getBounds((int)n, (int)-1).y;
            }
            if (n == n2) {
                return cellLayoutModel.getBounds((int)n3, (int)-1).y;
            }
            if (n >= n3) {
                return cellLayoutModel.getBounds((int)n, (int)-1).y + cellLayoutModel.getBounds((int)n2, (int)-1).height;
            }
        }
        return cellLayoutModel.getBounds((int)n, (int)-1).y;
    }

    private int getTransposition(int n, int n2, int n3) {
        if (n2 < n3) {
            if (n >= n2 && n < n3 - 1) {
                return n + 1;
            }
            if (n == n3 - 1) {
                return n2;
            }
        } else {
            if (n > n3 && n <= n2) {
                return n - 1;
            }
            if (n == n3) {
                return n2;
            }
        }
        return n;
    }

    public JCCellRange getVisibleCells() {
        CellArea cellArea = this.findByType(0);
        if (cellArea == null) {
            return new JCCellRange();
        }
        int n = cellArea.getX();
        int n2 = cellArea.getY();
        int n3 = cellArea.getWidth();
        int n4 = cellArea.getHeight();
        int n5 = this.getRow(n + 1, n2 + 1);
        int n6 = this.getColumn(n + 1, n2 + 1);
        int n7 = this.getRow(n + n3 - 1, n2 + n4 - 1);
        int n8 = this.getColumn(n + n3 - 1, n2 + n4 - 1);
        if (n7 == -999) {
            n7 = cellArea.getEndRow();
        }
        if (n8 == -999) {
            n8 = cellArea.getEndColumn();
        }
        return new JCCellRange(n5, n6, n7, n8);
    }

    public boolean isContentClipped(int n, int n2) {
        Serializable serializable;
        Object object = this.table.getDataView().getObject(n, n2);
        JCCellRenderer jCCellRenderer = this.table.getDataView().getCellRenderer(n, n2, object);
        this.cellInfo.initialize(this.table, object, n, n2);
        Dimension dimension = null;
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            serializable = (JCLightCellRenderer)jCCellRenderer;
            dimension = serializable.getPreferredSize(this.table.getGraphics(), this.cellInfo, object);
        } else {
            serializable = (JCComponentCellRenderer)jCCellRenderer;
            dimension = serializable.getRendererComponent(this.cellInfo, object, this.table.isSelected(n, n2)).getPreferredSize();
        }
        serializable = this.getBounds(n, n2);
        return dimension.width > ((Rectangle)serializable).width || dimension.height > ((Rectangle)serializable).height;
    }

    public boolean isStandardLayout() {
        return this.isStandardLayout;
    }

    protected void performDrag(int n, int n2, int n3, int n4) {
        this.DRAGGING = true;
        if (this.drag_row == n && this.drag_column == n2 && this.drop_row == n3 && this.drop_column == n4) {
            return;
        }
        if (n == -1) {
            int n5;
            int n6;
            if (n2 != n4) {
                n6 = this.table.getNumColumns();
                this.drag_columns = new int[n6];
                n5 = 0;
                while (n5 < n6) {
                    this.drag_columns[n5] = n5;
                    ++n5;
                }
                this.drag_columns = this.shiftArray(this.drag_columns, n2, n4);
            } else {
                this.drag_columns = null;
            }
            this.drag_rows = null;
            n6 = Math.min(Math.min(n2, this.drag_column), Math.min(n4, this.drop_column));
            n5 = Math.max(Math.max(n2, this.drag_column), Math.max(n4, this.drop_column));
            this.drag_row = n;
            this.drag_column = n2;
            this.drop_row = n3;
            this.drop_column = n4;
            this.table.repaint();
        } else if (n2 == -1) {
            int n7;
            int n8;
            if (n != n3) {
                n8 = this.table.getNumRows();
                this.drag_rows = new int[n8];
                n7 = 0;
                while (n7 < n8) {
                    this.drag_rows[n7] = n7;
                    ++n7;
                }
                this.drag_rows = this.shiftArray(this.drag_rows, n, n3);
            } else {
                this.drag_rows = null;
            }
            this.drag_columns = null;
            n8 = Math.min(Math.min(n, this.drag_row), Math.min(n3, this.drop_row));
            n7 = Math.max(Math.max(n, this.drag_row), Math.max(n3, this.drop_row));
            this.drag_row = n;
            this.drag_column = n2;
            this.drop_row = n3;
            this.drop_column = n4;
            this.table.repaint();
        } else {
            this.drag_row = n;
            this.drag_column = n2;
            this.drop_row = n3;
            this.drop_column = n4;
            this.table.repaint();
        }
    }

    public void setAreaCellRange(CellArea cellArea) {
        int n = cellArea.getType();
        int n2 = -999;
        int n3 = -999;
        int n4 = -999;
        int n5 = -999;
        int n6 = this.table.getDataView().getNumRows();
        int n7 = this.table.getDataView().getNumColumns();
        int n8 = this.table.getFrozenRows();
        int n9 = this.table.getFrozenColumns();
        switch (n) {
            case 0: {
                if (n6 > 0) {
                    n2 = n8;
                    n4 = n6 - 1;
                }
                if (n7 <= 0) break;
                n3 = n9;
                n5 = n7 - 1;
                break;
            }
            case 4: {
                if (n8 <= 0 || n9 <= 0) break;
                n2 = 0;
                n3 = 0;
                n4 = Math.min(n8, n6) - 1;
                n5 = Math.min(n9, n7) - 1;
                break;
            }
            case 3: {
                if (n6 <= 0 || n7 <= 0 || n9 <= 0) break;
                n2 = n8;
                n3 = 0;
                n4 = n6 - 1;
                n5 = Math.min(n9, n7) - 1;
                break;
            }
            case 1: {
                if (n6 <= 0 || n7 <= 0 || n8 <= 0) break;
                n2 = 0;
                n3 = n9;
                n4 = Math.min(n8, n6) - 1;
                n5 = n7 - 1;
                break;
            }
            case 7: {
                if (n8 <= 0) break;
                n2 = 0;
                n3 = -1;
                n4 = Math.min(n8, n6) - 1;
                n5 = -1;
                break;
            }
            case 6: {
                if (n6 <= 0) break;
                n2 = n8;
                n3 = -1;
                n4 = n6 - 1;
                n5 = -1;
                break;
            }
            case 5: {
                if (n9 <= 0) break;
                n2 = -1;
                n3 = 0;
                n4 = -1;
                n5 = Math.min(n9, n7) - 1;
                break;
            }
            case 2: {
                if (n7 <= 0) break;
                n2 = -1;
                n3 = Math.min(n9, n7 - 1);
                n4 = -1;
                n5 = n7 - 1;
                break;
            }
        }
        cellArea.setCellRange(n2, n3, n4, n5);
        Rectangle rectangle = this.getBounds(n2, n3, n4, n5);
        if (n == 0) {
            if (n6 > 0 && n8 >= n6 && n7 > 0 && n9 >= n7) {
                cellArea.setCellSize(0, 0);
            } else if (n6 > 0 && n8 >= n6) {
                cellArea.setCellSize(rectangle.width, 0);
            } else if (n7 > 0 && n9 >= n7) {
                cellArea.setCellSize(0, rectangle.height);
            } else {
                cellArea.setCellSize(rectangle.width, rectangle.height);
            }
        } else if (n == 2 && n7 > 0 && n9 >= n7) {
            cellArea.setCellSize(0, rectangle.height);
        } else if (n == 6 && n6 > 0 && n8 >= n6) {
            cellArea.setCellSize(rectangle.width, 0);
        } else {
            cellArea.setCellSize(rectangle.width, rectangle.height);
        }
    }

    public void setCellOrigin(int n, int n2) {
        this.cellOrigin.x = n;
        this.cellOrigin.y = n2;
        this.table.layoutAreas();
    }

    public void setCellOrigin(Point point) {
        this.setCellOrigin(point.x, point.y);
    }

    public void setCellOriginX(int n) {
        this.cellOrigin.x = n;
        this.table.layoutAreas();
    }

    public void setCellOriginY(int n) {
        this.cellOrigin.y = n;
        this.table.layoutAreas();
    }

    public void setStandardLayout(boolean bl) {
        this.isStandardLayout = bl;
    }

    public void setTableCellInfo(TableCellInfoModel tableCellInfoModel) {
        this.cellInfo = tableCellInfoModel;
    }

    protected int[] shiftArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        if (n2 == Integer.MAX_VALUE) {
            int n4 = 0;
            while (n4 < n) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
            int n5 = n + 1;
            while (n5 < n3) {
                nArray2[n5 - 1] = nArray[n5];
                ++n5;
            }
            nArray2[n3 - 1] = nArray[n];
        } else if (n < n2) {
            int n6 = 0;
            while (n6 < n3) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            int n7 = n + 1;
            while (n7 < n2) {
                nArray2[n7 - 1] = nArray[n7];
                ++n7;
            }
            nArray2[n2 - 1] = nArray[n];
        } else if (n > n2) {
            int n8 = 0;
            while (n8 < n3) {
                nArray2[n8] = nArray[n8];
                ++n8;
            }
            int n9 = n2;
            while (n9 < n) {
                nArray2[n9 + 1] = nArray[n9];
                ++n9;
            }
            nArray2[n2] = nArray[n];
        }
        return nArray2;
    }
}

