/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.swing;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.swing.AbstractEditorToComponent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;

public class JCCellEditorToJTree
extends AbstractEditorToComponent
implements TreeCellEditor {
    protected Vector cellListeners = new Vector();
    protected Vector jcCellListeners = new Vector();
    protected transient ChangeEvent changeEvent = null;
    protected transient EventObject lastEvent = null;

    public JCCellEditorToJTree() {
    }

    public JCCellEditorToJTree(JCCellEditor jCCellEditor) {
        super(jCCellEditor);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        JCCellEditorToCellEditorListener jCCellEditorToCellEditorListener = new JCCellEditorToCellEditorListener(cellEditorListener);
        this.cellListeners.add(cellEditorListener);
        this.jcCellListeners.add(jCCellEditorToCellEditorListener);
        this.editor.addCellEditorListener(jCCellEditorToCellEditorListener);
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
        Enumeration enumeration = this.cellListeners.elements();
        while (enumeration.hasMoreElements()) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
            cellEditorListener.editingStopped(this.changeEvent);
        }
    }

    public Insets getBorderInsets() {
        return ((JTree)this.component).getInsets();
    }

    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    public Insets getMarginInsets() {
        return ((JTree)this.component).getInsets();
    }

    public Color getSelectedBackground() {
        return ((JTree)this.component).getBackground();
    }

    public Color getSelectedForeground() {
        return ((JTree)this.component).getForeground();
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.setComponent(jTree);
        this.editor.initialize((AWTEvent)this.lastEvent, this, object);
        return this.editor.getComponent();
    }

    public boolean isCellEditable(EventObject eventObject) {
        this.lastEvent = eventObject;
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        int n = 0;
        while (n < this.cellListeners.size()) {
            if (cellEditorListener == this.cellListeners.elementAt(n)) {
                this.cellListeners.remove(n);
                JCCellEditorListener jCCellEditorListener = (JCCellEditorListener)this.jcCellListeners.remove(n);
                this.editor.removeCellEditorListener(jCCellEditorListener);
                --n;
            }
            ++n;
        }
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        this.lastEvent = eventObject;
        return true;
    }

    public boolean stopCellEditing() {
        if (this.editor.stopCellEditing()) {
            Enumeration enumeration = this.cellListeners.elements();
            while (enumeration.hasMoreElements()) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
                cellEditorListener.editingStopped(this.changeEvent);
            }
            return true;
        }
        return false;
    }

    public class JCCellEditorToCellEditorListener
    implements JCCellEditorListener {
        protected CellEditorListener cellListener;

        public JCCellEditorToCellEditorListener(CellEditorListener cellEditorListener) {
            this.cellListener = cellEditorListener;
        }

        public void editingCanceled(JCCellEditorEvent jCCellEditorEvent) {
            this.cellListener.editingCanceled(new ChangeEvent(jCCellEditorEvent.getSource()));
        }

        public void editingStopped(JCCellEditorEvent jCCellEditorEvent) {
            this.cellListener.editingStopped(new ChangeEvent(jCCellEditorEvent.getSource()));
        }
    }
}

