/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCKeyModifier;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.cell.validate.ValidateSupport;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JCMultilineCellEditor
extends JScrollPane
implements JCCellEditor,
KeyListener {
    protected Object data;
    protected AWTEvent initialEvent;
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected boolean selectAll = false;
    protected ValidateSupport validate_support = new ValidateSupport();
    private boolean suppressEnter = false;
    protected JTextArea text = null;
    protected JCKeyModifier[] keys = null;

    public JCMultilineCellEditor() {
        this.addKeyListener(this);
        this.text = new JTextArea();
        this.getViewport().add(this.text);
        this.setDoubleBuffered(true);
        this.text.setDoubleBuffered(true);
        this.text.addKeyListener(this);
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void addValidateListener(JCValidateListener jCValidateListener) {
        this.validate_support.addValidateListener(jCValidateListener);
    }

    public void cancelCellEditing() {
        this.initData();
        this.selectAllText();
    }

    protected boolean fireValidated(JCValidateEvent jCValidateEvent) {
        boolean bl = this.validate_support.fireValidateEvents(jCValidateEvent);
        if (bl) {
            this.setVisible(true);
        }
        return bl;
    }

    public Object getCellEditorValue() {
        return this.getText();
    }

    public Component getComponent() {
        this.validate();
        this.text.setVisible(true);
        this.text.requestFocus();
        return this;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        return this.getPreferredSize();
    }

    public JCKeyModifier[] getReservedKeys() {
        if (this.keys == null) {
            this.keys = new JCKeyModifier[9];
            this.keys[0] = new JCKeyModifier(10);
            this.keys[1] = new JCKeyModifier(40);
            this.keys[2] = new JCKeyModifier(38);
            this.keys[3] = new JCKeyModifier(37);
            this.keys[4] = new JCKeyModifier(39);
            this.keys[5] = new JCKeyModifier(33);
            this.keys[6] = new JCKeyModifier(34);
            this.keys[7] = new JCKeyModifier(36);
            this.keys[8] = new JCKeyModifier(35);
        }
        return this.keys;
    }

    public String getText() {
        return this.text.getText();
    }

    void initData() {
        this.setText(this.data == null ? "" : this.data.toString());
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        this.initialEvent = aWTEvent;
        this.data = object;
        this.selectAll = jCCellInfo.getSelectAll();
        this.text.setEditable(jCCellInfo.isEditable());
        if (!this.text.isEditable()) {
            this.selectAll = false;
        }
        this.initData();
        if (this.initialEvent != null && this.initialEvent instanceof KeyEvent) {
            this.suppressEnter = true;
        }
        this.setBackground(jCCellInfo.getBackground());
        this.setForeground(jCCellInfo.getForeground());
    }

    public boolean isModified() {
        Object object = this.getCellEditorValue();
        if (this.data == null || this.data.equals("")) {
            return object != null && !object.equals("");
        }
        return this.data.equals(object) ^ true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.support.fireCancelEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            default: {
                if (keyEvent.getComponent() != this.text) break;
                this.processKeyEvent(new KeyEvent(this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        FocusManager focusManager = FocusManager.getCurrentManager();
        FocusManager.disableSwingFocusManager();
        super.processKeyEvent(keyEvent);
        FocusManager.setCurrentManager(focusManager);
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    public void removeValidateListener(JCValidateListener jCValidateListener) {
        this.validate_support.removeValidateListener(jCValidateListener);
    }

    public void selectAllText() {
        if (!this.isDisplayable()) {
            return;
        }
        if (this.selectAll) {
            this.text.setCaretPosition(0);
            this.text.setCaretPosition(this.getText().length());
            this.text.selectAll();
        } else {
            this.text.setCaretPosition(this.getText().length());
        }
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.selectAllText();
        }
    }

    public boolean stopCellEditing() {
        String string = this.getText();
        JCValidateEvent jCValidateEvent = new JCValidateEvent(this, this.data, string, true);
        boolean bl = this.fireValidated(jCValidateEvent);
        if (bl) {
            this.selectAllText();
        }
        return bl;
    }
}

