/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.wizard;

import com.borland.primetime.actions.UpdateAction;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserPropertyGroup;
import com.borland.primetime.util.Strings;
import com.borland.primetime.wizard.Wizard;
import com.borland.primetime.wizard.WizardDialog;
import com.borland.primetime.wizard.a;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public abstract class WizardAction
extends UpdateAction {
    public static final String CATEGORY = "Category";
    public static final String GALLERY_WIZARD = "GalleryWizard";

    static {
        GALLERY_WIZARD = GALLERY_WIZARD;
        CATEGORY = CATEGORY;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        Browser browser = Browser.findBrowser(actionEvent.getSource());
        this.invokeWizard(browser);
    }

    public final void invokeWizard(Browser browser) {
        Wizard wizard = this.createWizard();
        if (wizard != null) {
            WizardDialog wizardDialog = new WizardDialog(browser, wizard);
            wizardDialog.show();
            if (browser != null) {
                browser.repaint();
            }
        } else if (browser != null) {
            browser.getStatusView().setText(Strings.format(a.a(10), this.getShortText()), BrowserPropertyGroup.getErrorTextForegroundColor());
        }
    }

    protected abstract Wizard createWizard();

    public String getCategory() {
        Object object = this.getValue(CATEGORY);
        return object != null ? object.toString() : null;
    }

    public void setCategory(String string) {
        this.putValue(CATEGORY, string);
    }

    public boolean isGalleryWizard() {
        Object object = this.getValue(GALLERY_WIZARD);
        return object instanceof Boolean && (Boolean)object != false;
    }

    public void setGalleryWizard(boolean bl) {
        this.putValue(GALLERY_WIZARD, new Boolean(bl));
    }

    public WizardAction(String string, char c2, String string2, Icon icon, Icon icon2, boolean bl, String string3) {
        super(string, c2, string2, icon);
        this.putValue("LargeIcon", icon2);
        this.putValue(GALLERY_WIZARD, new Boolean(bl));
        this.putValue(CATEGORY, string3);
    }

    public WizardAction(String string, char c2, String string2, Icon icon, Icon icon2, boolean bl) {
        super(string, c2, string2, icon);
        this.putValue("LargeIcon", icon2);
        this.putValue(GALLERY_WIZARD, new Boolean(bl));
    }

    public WizardAction(String string, char c2, String string2, Icon icon, Icon icon2) {
        super(string, c2, string2, icon);
        this.putValue("LargeIcon", icon2);
    }

    public WizardAction(String string, char c2, String string2, Icon icon) {
        super(string, c2, string2, icon);
    }

    public WizardAction(String string, char c2, String string2) {
        super(string, c2, string2);
    }

    public WizardAction(String string, char c2) {
        super(string, c2);
    }

    public WizardAction(String string) {
        super(string);
    }

    public WizardAction() {
    }
}

