/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.viewer;

import com.borland.primetime.node.TextStructure;
import com.borland.primetime.viewer.NodeViewList;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.Document;

public abstract class BufferNodeList {
    protected ArrayList nodeViewLists = null;

    public synchronized void updateViews(boolean bl, boolean bl2) {
        Document document = this.getDocument();
        if (this.nodeViewLists != null) {
            Iterator iterator = ((AbstractList)this.nodeViewLists).iterator();
            while (iterator.hasNext()) {
                NodeViewList nodeViewList = (NodeViewList)iterator.next();
                nodeViewList.updateViews(document, bl, bl2);
            }
        }
    }

    public void updateViews(NodeViewList nodeViewList) {
        nodeViewList.updateViews(this.getDocument(), this.isModified(), this.isReadOnly());
    }

    public void updateViews() {
        this.updateViews(this.isModified(), this.isReadOnly());
    }

    public synchronized void removeNodeViewList(NodeViewList nodeViewList) {
        if (this.nodeViewLists != null) {
            ((AbstractCollection)this.nodeViewLists).remove(nodeViewList);
            if (this.nodeViewLists.size() == 0) {
                this.nodeViewLists = null;
            }
        }
    }

    public synchronized void addNodeViewList(NodeViewList nodeViewList) {
        this.updateViews(nodeViewList);
        if (this.nodeViewLists == null) {
            this.nodeViewLists = new ArrayList();
        }
        this.nodeViewLists.add(nodeViewList);
    }

    public synchronized boolean hasViews() {
        return this.nodeViewLists != null;
    }

    public abstract Document getDocument();

    public abstract boolean isReadOnly();

    public abstract boolean isModified();

    public abstract TextStructure getTextStructure();
}

