/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.vfs;

import com.borland.primetime.util.RegularExpression;
import com.borland.primetime.vfs.Url;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface Filesystem {
    public static final int RELATIONSHIP_CHILD_OR_ABSOLUTE = 2;
    public static final int RELATIONSHIP_CHILD = 1;
    public static final int RELATIONSHIP_ANY = 0;
    public static final int TYPE_BOTH = 3;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_DIRECTORY = 1;

    static {
        TYPE_DIRECTORY = 1;
        TYPE_FILE = 2;
        TYPE_BOTH = 3;
        RELATIONSHIP_ANY = 0;
        RELATIONSHIP_CHILD = 1;
        RELATIONSHIP_CHILD_OR_ABSOLUTE = 2;
    }

    public boolean fileEquals(Url var1, Url var2);

    public int fileHashCode(Url var1);

    public boolean isValid(Url var1);

    public String getRelativePath(Url var1, Url var2, int var3);

    public Url getRelativeUrl(Url var1, String var2);

    public Url getCanonicalUrl(Url var1);

    public File getFileObject(Url var1);

    public Url getParent(Url var1);

    public Url getChild(Url var1, String var2);

    public Url[] getChildren(Url var1, RegularExpression[] var2, int var3);

    public String getFullName(Url var1);

    public String getName(Url var1);

    public boolean isDirectory(Url var1);

    public void delete(Url var1) throws IOException;

    public boolean exists(Url var1);

    public boolean setLastModified(Url var1, long var2);

    public long getLastModified(Url var1);

    public boolean isReadOnly(Url var1);

    public OutputStream getOutputStream(Url var1) throws IOException;

    public OutputStream getOutputStream(Url var1, boolean var2) throws IOException;

    public InputStream getInputStream(Url var1) throws IOException;

    public String getProtocol();
}

