/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.ui;

import com.borland.primetime.util.ClipPath;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ClipPathRenderer
extends JLabel
implements ListCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics;
        String string = this.getText();
        int n2 = this.getWidth();
        Container container = this.getParent();
        if (container != null && container instanceof CellRendererPane) {
            while (container != null) {
                if (container instanceof JViewport) {
                    n2 = container.getWidth();
                    break;
                }
                container = container.getParent();
            }
        }
        if (n2 > 0 && string.length() > 5 && (fontMetrics = graphics.getFontMetrics(this.getFont())) != null && SwingUtilities.computeStringWidth(fontMetrics, string) > n2) {
            string = ClipPath.clipCenter(this.getFont(), string, n2);
            this.setText(string);
        }
        super.paint(graphics);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        Font font = jList.getFont();
        this.setFont(font);
        String string = object == null ? "" : object.toString();
        this.setText(string);
        return this;
    }

    public ClipPathRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }
}

