/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.ui;

import com.borland.primetime.ui.CheckCellRenderer;
import com.borland.primetime.ui.CheckTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;

public class CheckTreeCellEditor
extends CheckCellRenderer
implements TreeCellEditor {
    private boolean a = true;
    protected JTree tree;
    protected CheckTreeNode currentNode;
    protected CellEditorListener listener;

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.hitTest(mouseEvent.getX(), mouseEvent.getY())) {
                if (mouseEvent.getID() == 500) {
                    this.setSelected(!this.isSelected());
                }
            } else if (!this.a && mouseEvent.getID() == 502) {
                this.setSelected(!this.isSelected());
            }
        }
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.tree != null && this.currentNode != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            this.currentNode.setChecked(bl);
            defaultTreeModel.nodeChanged(this.currentNode);
        }
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2) {
        this.tree = jTree;
        Color color = UIManager.getColor("Tree.selectionForeground");
        Color color2 = UIManager.getColor("Tree.selectionBackground");
        this.setForeground(color);
        this.setBackground(color2);
        if (object instanceof CheckTreeNode) {
            CheckTreeNode checkTreeNode = (CheckTreeNode)object;
            this.setEnabled(checkTreeNode.isEnabled());
            if (bl2) {
                this.setIcon(checkTreeNode.getExpandedIcon());
            } else {
                this.setIcon(checkTreeNode.getIcon());
            }
            this.setText(checkTreeNode.getText());
            if (checkTreeNode.isCheckable()) {
                this.setSelected(checkTreeNode.isChecked());
                this.setCheckVisible(true);
                this.currentNode = checkTreeNode;
            } else {
                this.setCheckVisible(false);
            }
        } else {
            this.setEnabled(true);
            this.setText(object.toString());
            this.setCheckVisible(false);
        }
        this.setPaintFocusRect(true);
        return this;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        if (this.listener == cellEditorListener) {
            this.listener = null;
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listener = cellEditorListener;
    }

    public void cancelCellEditing() {
        if (this.listener != null) {
            this.listener.editingCanceled(new ChangeEvent(this));
        }
    }

    public boolean stopCellEditing() {
        if (this.currentNode != null) {
            this.currentNode.setChecked(this.isSelected());
            this.currentNode = null;
        }
        if (this.listener != null) {
            this.listener.editingStopped(new ChangeEvent(this));
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        MouseEvent mouseEvent;
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton(mouseEvent = (MouseEvent)eventObject)) {
            Point point = this.getLocation();
            if (this.hitTest(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y)) {
                this.setSelected(!this.isSelected());
            }
        }
        return true;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    public boolean isOnlyBoxSelects() {
        return this.a;
    }

    public void setOnlyBoxSelects(boolean bl) {
        this.a = bl;
    }

    public CheckTreeCellEditor() {
        this.enableEvents(16L);
    }
}

