/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.node;

import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.PackageNode;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.FolderNode;
import com.borland.primetime.node.Project;
import com.borland.primetime.util.AssertionException;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class UnitTest {
    public static void packageTests() throws Exception {
        System.out.println("\n-- Package Tests --\n");
        Project project = Project.getProject(new Url(new File("c:/NonFileTests.jpr")));
        PackageNode packageNode = new PackageNode(project, project, "java.lang");
        packageNode.setParent(project);
        project.dumpNodes(true);
    }

    public static void nonFileTests() throws Exception {
        System.out.println("\n-- Non-File Node Tests --\n");
        Project project = Project.getProject(new Url(new File("c:/NonFileTests.jpr")));
        FolderNode folderNode = new FolderNode(project, project, "Images");
        PackageNode packageNode = new PackageNode(project, project, "java.lang");
        FileNode fileNode = project.getNode(new Url(new File("c:/baz.java")));
        fileNode.setParent(folderNode);
        project.dumpNodes();
    }

    public static void projectFileFormatTests() throws Exception {
        System.out.println("\n-- Project File Format Tests --\n");
        Url url = new Url(new File("c:/ProjectFileFormatTests.jpr"));
        if (VFS.exists(url)) {
            VFS.delete(url);
        }
        Project project = Project.getProject(url);
        FileNode fileNode = project.getNode(new Url(new File("c:/foo.java")));
        FileNode fileNode2 = project.getNode(new Url(new File("c:/bar.java")));
        FileNode fileNode3 = project.getNode(new Url(new File("c:/baz.java")));
        FileNode fileNode4 = project.getNode(new Url(new File("c:/qux.java")));
        fileNode.setParent(fileNode2);
        fileNode2.setParent(fileNode3);
        fileNode3.setParent(project);
        fileNode.setProperty("category", "propertyname", "value");
        fileNode.setProperty("category2", "propertyname2", "value2");
        project.dumpNodes();
        project.save();
        FileNode fileNode5 = project.createFileNode("java");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileNode5.getBuffer().getOutputStream());
        outputStreamWriter.write("Testing, testing.");
        ((Writer)outputStreamWriter).close();
        fileNode5.saveAs(new Url(new File("c:/test.java")));
        project.dumpNodes();
        project.save();
        Url url2 = new Url(new File("c:\\jbuilder2\\samples\\borland\\samples\\intl\\IntlDemo.jpr"));
        if (!VFS.exists(url2)) {
            url2 = new Url(new File("e:\\jbuilder2\\samples\\borland\\samples\\intl\\IntlDemo.jpr"));
        }
        Project project2 = Project.getProject(url2);
        project2.dumpNodes(true);
        FileNode fileNode6 = project2.createFileNode(".java");
        fileNode6.setParent(project2);
        fileNode6.saveAs(new Url(new File("c:\\foo.java")));
        project2.saveAs(new Url(new File("c:\\foo.jpr")));
    }

    public static void hierarchyTests() throws Exception {
        System.out.println("\n-- Hierarchy Tests --\n");
        Project project = Project.getProject(new Url(new File("c:/HierarchyTestsA.jpr")));
        Project project2 = Project.getProject(new Url(new File("c:/HierarchyTestsB.jpr")));
        FileNode fileNode = project.getNode(new Url(new File("c:/foo.java")));
        FileNode fileNode2 = project.getNode(new Url(new File("c:/bar.java")));
        FileNode fileNode3 = project.getNode(new Url(new File("c:/baz.java")));
        project.dumpNodes();
        fileNode.setParent(project);
        project.dumpNodes();
        fileNode2.setParent(project);
        fileNode3.setParent(project);
        project.dumpNodes();
        fileNode.dumpNodes();
        fileNode2.setParent(fileNode);
        fileNode3.setParent(null);
        project.dumpNodes();
        fileNode.dumpNodes();
        System.out.print("Move node between projects <false>? ");
        try {
            fileNode.setParent(project2);
            System.out.println(true);
        }
        catch (AssertionException assertionException) {
            System.out.println(false);
        }
    }

    public static void nodeTests() throws Exception {
        System.out.println("\n-- Node Tests --\n");
        Project project = Project.getProject(new Url(new File("c:/HierarchyTestsA.jpr")));
        FileNode fileNode = project.getNode(new Url(new File("c:/foo.java")));
        FileNode fileNode2 = project.getNode(new Url(new File("c:/foo.java")));
        System.out.println("foo == foo2 <true>? ".concat(String.valueOf(String.valueOf(fileNode == fileNode2))));
    }

    public static void newUrlTests() throws Exception {
        System.out.println("\n-- New Url Tests --\n");
        Project project = Project.createProject("jpr");
        System.out.println("New project Url: ".concat(String.valueOf(String.valueOf(project.getUrl()))));
        System.out.println("New java Url: ".concat(String.valueOf(String.valueOf(project.createFileNode("java").getUrl()))));
        System.out.println("New java Url: ".concat(String.valueOf(String.valueOf(project.createFileNode("java").getUrl()))));
        System.out.println("New html Url: ".concat(String.valueOf(String.valueOf(project.createFileNode("html").getUrl()))));
        Project project2 = Project.createProject("jpr");
        System.out.println("New project Url: ".concat(String.valueOf(String.valueOf(project2.getUrl()))));
        System.out.println("New java Url: ".concat(String.valueOf(String.valueOf(project2.createFileNode("java").getUrl()))));
        System.out.println("New html Url: ".concat(String.valueOf(String.valueOf(project2.createFileNode("html").getUrl()))));
        System.out.println("New java Url: ".concat(String.valueOf(String.valueOf(project2.createFileNode("java").getUrl()))));
    }

    public static void projectFileTests() throws Exception {
        System.out.println("\n-- Project File Tests --\n");
        Project project = Project.createProject("jpr");
        File file = new File("project.file.test1.jpr");
        project.saveAs(new Url(file));
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("New Url <").append(file.getName()).append(">? ").append(project.getUrl().getFileObject().getName()))));
        System.out.println("File actually exists <true>? ".concat(String.valueOf(String.valueOf(file.exists()))));
        File file2 = new File("project.file.test2.jpr");
        project.saveAs(new Url(file2));
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("New Url <").append(file2.getName()).append(">? ").append(project.getUrl().getFileObject().getName()))));
        System.out.println("File actually exists <true>? ".concat(String.valueOf(String.valueOf(file2.exists()))));
        System.out.println("Previous file still exists <true>? ".concat(String.valueOf(String.valueOf(file.exists()))));
        File file3 = new File("project.file.test3.jpr");
        project.rename(new Url(file3));
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("New Url <").append(file3.getName()).append(">? ").append(project.getUrl().getFileObject().getName()))));
        System.out.println("File actually exists <true>? ".concat(String.valueOf(String.valueOf(file3.exists()))));
        System.out.println("Previous file still exists <false>? ".concat(String.valueOf(String.valueOf(file2.exists()))));
        file.delete();
        file2.delete();
        file3.delete();
    }

    public static void projectTests() throws Exception {
        System.out.println("\n-- Basic Project Tests --\n");
        JBProject jBProject = (JBProject)Project.getProject(new Url(new File("ProjectTests1.jpr")));
        JBProject jBProject2 = (JBProject)Project.getProject(new Url(new File("ProjectTests1.jpr")));
        JBProject jBProject3 = (JBProject)Project.getProject(new Url(new File("ProjectTests2.jpr")));
        System.out.println("Project a = ".concat(String.valueOf(String.valueOf(jBProject))));
        System.out.println("Project b = ".concat(String.valueOf(String.valueOf(jBProject2))));
        System.out.println("Project c = ".concat(String.valueOf(String.valueOf(jBProject3))));
        System.out.println("a == b <true>? ".concat(String.valueOf(String.valueOf(jBProject == jBProject2))));
        System.out.println("a == c <false>? ".concat(String.valueOf(String.valueOf(jBProject == jBProject3))));
        System.out.println("a.equals(b) <true>? ".concat(String.valueOf(String.valueOf(jBProject.equals(jBProject2)))));
        System.out.println("a.equals(c) <false>? ".concat(String.valueOf(String.valueOf(jBProject.equals(jBProject3)))));
        System.out.println("a.getProject() == a <true>? ".concat(String.valueOf(String.valueOf(jBProject.getProject() == jBProject))));
        Url url = new Url(new File("1"));
        Url url2 = new Url(new File("2"));
        Url url3 = new Url(new File("3"));
        Url url4 = new Url(new File("4"));
        jBProject.getPaths().setOutPath(url);
        jBProject.getPaths().setSourcePath(new Url[]{url3, url4});
        jBProject.getPaths().setDocPath(new Url[]{url, url2, url3});
        System.out.println("OutputPath = one <true>? ".concat(String.valueOf(String.valueOf(jBProject.getPaths().getOutPath() == url))));
        System.out.println("SourcePath = {three,four} <true>? ".concat(String.valueOf(String.valueOf(jBProject.getPaths().getSourcePath().length == 2 && jBProject.getPaths().getSourcePath()[0] == url3 && jBProject.getPaths().getSourcePath()[1] == url4))));
        System.out.println("DocPath = {two} <true>? ".concat(String.valueOf(String.valueOf(jBProject.getPaths().getDocPath().length == 3 && jBProject.getPaths().getDocPath()[0] == url && jBProject.getPaths().getDocPath()[1] == url2 && jBProject.getPaths().getDocPath()[2] == url3))));
    }

    public static void main(String[] stringArray) {
        PrimeTime.initializeOpenTools("Core");
        long l2 = System.currentTimeMillis();
        try {
            for (int i2 = 0; i2 < 1; ++i2) {
                try {
                    UnitTest.projectTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.projectFileTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.newUrlTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.nodeTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.hierarchyTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.projectFileFormatTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.nonFileTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.packageTests();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
            Buffer.updateModifiedBuffers();
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            long l3 = System.currentTimeMillis();
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Finished in ").append(l3 - l2).append("ms"))));
            throw throwable;
        }
        long l4 = System.currentTimeMillis();
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Finished in ").append(l4 - l2).append("ms"))));
    }
}

