/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.node;

import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.node.DirectoryFilter;
import com.borland.primetime.node.DirectoryNode;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.FileType;
import com.borland.primetime.node.LightweightNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public abstract class AbstractDirectoryNode
extends LightweightNode {
    protected DirectoryFilter subdirFilter;
    protected Set fileTypes;
    protected Url dirUrl = this.a();

    public String getLongDisplayName() {
        return this.getDirectory().getFile();
    }

    public List getFiles() {
        LinkedList<FileNode> linkedList = new LinkedList<FileNode>();
        Url[] urlArray = VFS.getChildren(this.dirUrl, 2);
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            if (this.fileTypes != null && !this.fileTypes.contains(FileType.getFileType(urlArray[i2].getFileExtension()))) continue;
            linkedList.add(this.getProject().getNode(urlArray[i2]));
        }
        return linkedList;
    }

    public List getSubdirectories() {
        LinkedList<DirectoryNode> linkedList = new LinkedList<DirectoryNode>();
        Url[] urlArray = VFS.getChildren(this.dirUrl, 1);
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            if (this.subdirFilter != null && !this.subdirFilter.accept(urlArray[i2])) continue;
            DirectoryNode directoryNode = this.getProject().getDirectoryNode(urlArray[i2]);
            directoryNode.setFileTypes(this.fileTypes);
            directoryNode.setSubdirectoryFilter(this.subdirFilter);
            linkedList.add(directoryNode);
        }
        return linkedList;
    }

    public Node[] getDisplayChildren() {
        if (!VFS.isDirectory(this.dirUrl)) {
            return Node.EMPTY_ARRAY;
        }
        List list = this.getSubdirectories();
        List list2 = this.getFiles();
        Collections.sort(list);
        Collections.sort(list2);
        list.addAll(list2);
        Node[] nodeArray = new Node[list.size()];
        list.toArray(nodeArray);
        return nodeArray;
    }

    public boolean hasDisplayChildren() {
        int n2;
        if (!VFS.isDirectory(this.dirUrl)) {
            return false;
        }
        Url[] urlArray = VFS.getChildren(this.dirUrl, 2);
        if (this.fileTypes == null && urlArray.length > 0) {
            return true;
        }
        for (n2 = 0; n2 < urlArray.length; ++n2) {
            if (!this.fileTypes.contains(FileType.getFileType(urlArray[n2].getFileExtension()))) continue;
            return true;
        }
        urlArray = VFS.getChildren(this.dirUrl, 1);
        if (this.subdirFilter == null && urlArray.length > 0) {
            return true;
        }
        for (n2 = 0; n2 < urlArray.length; ++n2) {
            if (!this.subdirFilter.accept(urlArray[n2])) continue;
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        int n2 = this.getName().lastIndexOf(47);
        return this.getName().substring(++n2);
    }

    public Icon getDisplayIcon() {
        return BrowserIcons.ICON_DISKFOLDER;
    }

    public void setSubdirectoryFilter(DirectoryFilter directoryFilter) {
        this.subdirFilter = directoryFilter;
    }

    public DirectoryFilter getSubdirectoryFilter() {
        return this.subdirFilter;
    }

    public void setFileTypes(Set set) {
        this.fileTypes = set;
    }

    public Set getFileTypes() {
        return this.fileTypes;
    }

    public Url getDirectory() {
        return this.dirUrl;
    }

    Url a() {
        return this.getProject().getProjectPath().getRelativeUrl(this.getName());
    }

    public AbstractDirectoryNode(Project project, Node node, String string) {
        super(project, node, string);
    }
}

