/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.io;

import com.borland.primetime.io.BufferedInputFile;
import com.borland.primetime.io.FileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class LocalFileSystem
implements FileSystem {
    public String getClassesDirectory(Object object) {
        return this.getClassesFile(object).getParent();
    }

    public File getClassesFile(Object object) {
        String string = object.getClass().getName().replace('.', File.separatorChar);
        string = String.valueOf(String.valueOf(string)).concat(".class");
        return this.getClassesFile(string);
    }

    public File getClassesFile(String string) {
        String string2 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            File file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(File.separator).append(string))));
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public File newFile(String string) {
        return new File(string);
    }

    public int listContains(String[] stringArray, String string) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equalsIgnoreCase(string)) continue;
            return i2;
        }
        return -1;
    }

    public String addDir(String string, String string2) {
        File file = this.newFile(string);
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.getParent()))).append(File.separator).append(string2).append(File.separator).append(file.getName())));
    }

    public boolean makeDir(String string) {
        File file = this.newFile(string);
        file.mkdir();
        return file.isDirectory();
    }

    public boolean makeDirs(String string) {
        File file = this.newFile(string);
        file.mkdirs();
        return file.isDirectory();
    }

    public Properties loadProperties(String string) throws IOException {
        Properties properties = new Properties();
        BufferedInputFile bufferedInputFile = new BufferedInputFile(string);
        properties.load(bufferedInputFile);
        bufferedInputFile.close();
        return properties;
    }

    public boolean traverse(FileSystem.TraverseAction traverseAction, File file) throws Exception {
        if (!file.isAbsolute()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            File file2 = this.newFile(this.createFilePath(file.getAbsolutePath(), stringArray[i2]));
            if (!(file2.isFile() ? traverseAction.onFile(file2) == 3 : file2.isDirectory() && traverseAction.onDirEntry(file2) == 1 && (!this.traverse(traverseAction, this.newFile(file2.getAbsolutePath())) || traverseAction.onDirExit(file2, stringArray) != 2))) continue;
            return false;
        }
        return true;
    }

    public void deleteDirectoryTree(String string) throws Exception {
        throw new RuntimeException("deleteDirectoryTree doesn't work!");
    }

    public boolean compareFiles(String string, String string2) throws IOException {
        int n2;
        long l2 = this.newFile(string).length();
        if (l2 != this.newFile(string2).length()) {
            return false;
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        FileInputStream fileInputStream2 = new FileInputStream(string2);
        byte[] byArray = new byte[32768];
        byte[] byArray2 = new byte[32768];
        long l3 = 0L;
        while ((n2 = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
            if (fileInputStream2.read(byArray2, 0, byArray2.length) != n2) {
                return false;
            }
            if (!this.compareBytes(byArray, byArray2, n2)) {
                return false;
            }
            l3 += (long)n2;
        }
        fileInputStream.close();
        fileInputStream2.close();
        return l2 == l3;
    }

    public boolean compareBytes(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public void copyFile(String string, String string2, String string3) throws IOException {
        int n2;
        FileInputStream fileInputStream = new FileInputStream(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        if (string3 != null) {
            fileOutputStream.write(string3.getBytes());
        }
        byte[] byArray = new byte[32768];
        while ((n2 = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
            fileOutputStream.write(byArray, 0, n2);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public void copyFile(String string, String string2) throws IOException {
        this.copyFile(string, string2, null);
    }

    public String createFilePath(String string, String string2) {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append(string2)));
    }
}

