/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorActions;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.VisualStudioAction;
import com.borland.primetime.editor.VisualStudioActionNames;
import com.borland.primetime.editor.a;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class VisualStudioActions
extends EditorActions
implements VisualStudioActionNames {
    public static final Action[] customActions;
    public static EditorAction ACTION_VisualStudioSelectColumn;
    public static EditorAction ACTION_VisualStudioSelectChar;
    public static EditorAction ACTION_VisualStudioEscape;
    public static EditorAction ACTION_VisualStudioCutLine;
    public static EditorAction ACTION_VisualStudioDeleteLine;

    static {
        ACTION_VisualStudioDeleteLine = new VisualStudioDeleteLineAction("visualstudio-delete-line", false);
        ACTION_VisualStudioCutLine = new VisualStudioDeleteLineAction("visualstudio-cut-line", true);
        ACTION_VisualStudioEscape = new VisualStudioEscapeAction("visualstudio-escape");
        ACTION_VisualStudioSelectChar = new VisualStudioSelectCharAction("visualstudio-select-char");
        ACTION_VisualStudioSelectColumn = new VisualStudioSelectColumnAction("visualstudio-select-column");
        customActions = new Action[]{ACTION_VisualStudioDeleteLine, ACTION_VisualStudioCutLine, ACTION_VisualStudioEscape, ACTION_VisualStudioSelectChar, ACTION_VisualStudioSelectColumn};
    }

    public static Action[] getActions() {
        return TextAction.augmentList(EditorActions.getActions(), customActions);
    }

    public static class VisualStudioSelectColumnAction
    extends VisualStudioAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            int n2 = this.getStateInfo(editorPane).getMode();
            if (n2 == 1) {
                this.getStateInfo(editorPane).setMode(0);
            }
            if (n2 != 2) {
                EditorActions.ACTION_SelectionForward.actionPerformed(actionEvent);
                this.getStateInfo(editorPane).setMode(2);
            } else {
                this.getStateInfo(editorPane).setMode(0);
                editorPane.setCaretPosition(editorPane.getCaretPosition());
            }
        }

        public VisualStudioSelectColumnAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(323));
            this.putValue("ActionGroup", a.a(324));
        }
    }

    public static class VisualStudioSelectCharAction
    extends VisualStudioAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane == null) {
                return;
            }
            int n2 = this.getStateInfo(editorPane).getMode();
            if (n2 == 1) {
                this.getStateInfo(editorPane).setMode(0);
            }
            if (n2 != 4) {
                this.getStateInfo(editorPane).setMode(4);
            } else {
                this.getStateInfo(editorPane).setMode(0);
                editorPane.setCaretPosition(editorPane.getCaretPosition());
            }
        }

        public VisualStudioSelectCharAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(322));
            this.putValue("ActionGroup", a.a(324));
        }
    }

    public static class VisualStudioEscapeAction
    extends VisualStudioAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                this.getStateInfo(editorPane).setMode(0);
                int n2 = editorPane.getCaretPosition();
                if (n2 >= 0) {
                    editorPane.setCaretPosition(n2);
                }
            }
        }

        public VisualStudioEscapeAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(321));
            this.putValue("ActionGroup", a.a(324));
        }
    }

    public static class VisualStudioDeleteLineAction
    extends VisualStudioAction {
        boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = null;
            try {
                editorPane = this.getEditorTarget(actionEvent);
                if (editorPane != null) {
                    int n2;
                    int n3;
                    if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                        return;
                    }
                    editorPane.startUndoGroup();
                    Caret caret = editorPane.getCaret();
                    int n4 = caret.getDot();
                    int n5 = caret.getMark();
                    Document document = editorPane.getDocument();
                    if (n4 != n5) {
                        n3 = Math.min(n4, n5);
                        n2 = Math.max(n4, n5);
                        n3 = Utilities.getRowStart(editorPane, n3);
                        n2 = Utilities.getRowEnd(editorPane, n2);
                    } else {
                        n3 = editorPane.getCaretPosition();
                        n3 = Utilities.getRowStart(editorPane, n3);
                        n2 = Utilities.getRowEnd(editorPane, n3);
                    }
                    if (n2 < document.getLength()) {
                        ++n2;
                    }
                    if (this.a) {
                        editorPane.setCaretPosition(n3);
                        editorPane.moveCaretPosition(n2);
                        editorPane.cut();
                    } else {
                        document.remove(n3, n2 - n3);
                    }
                    editorPane.endUndoGroup();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public VisualStudioDeleteLineAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(319));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.a.a(320));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.a.a(324));
        }
    }
}

