/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.SearchManager;
import com.borland.primetime.editor.SearchOptions;
import com.borland.primetime.editor.TextUtilities;
import com.borland.primetime.editor.a;
import com.borland.primetime.editor.b;
import com.borland.primetime.editor.eb;
import com.borland.primetime.editor.fb;
import com.borland.primetime.editor.gb;
import com.borland.primetime.editor.hb;
import com.borland.primetime.editor.ib;
import com.borland.primetime.editor.jb;
import com.borland.primetime.help.PrimetimeHelp;
import com.borland.primetime.ui.DefaultDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.Document;

public class SearchDialog
extends DefaultDialog
implements ActionListener {
    protected EditorPane editor;
    protected ButtonGroup directionGroup;
    protected JRadioButton backwardRadio;
    protected JRadioButton forwardRadio;
    protected JCheckBox wholeWordsOnlyCheck;
    protected JCheckBox originCheck;
    protected JCheckBox selectedTextCheck;
    protected JCheckBox regExpCheck;
    protected JCheckBox caseSensitiveCheck;
    protected JComboBox replaceCombo;
    protected JLabel replaceLabel;
    protected JComboBox searchCombo;
    protected JLabel searchLabel;
    protected BorderLayout borderLayout1;
    protected JButton helpButton;
    protected JButton cancelButton;
    protected JButton searchAllButton;
    protected JButton replaceButton;
    protected JButton searchButton = new JButton(a.a(122));
    private boolean g;

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.searchButton) {
            if (this.validateOptions()) {
                ((Component)this).setVisible(false);
                this.findText();
                this.closeDialog();
            }
        } else if (object == this.replaceButton) {
            if (this.validateOptions()) {
                ((Component)this).setVisible(false);
                this.replaceAllText();
                this.closeDialog();
            }
        } else if (object == this.searchAllButton) {
            if (this.validateOptions()) {
                ((Component)this).setVisible(false);
                this.findAllText();
                this.closeDialog();
            }
        } else if (object == this.cancelButton) {
            this.closeDialog();
        } else if (object == this.helpButton) {
            this.showHelp();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 360) {
            dimension.width = 360;
        }
        return dimension;
    }

    protected void showHelp() {
        PrimetimeHelp.TOPIC_DReplaceText.show((JDialog)this);
    }

    protected void closeDialog() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    protected boolean replaceAllText() {
        String string = System.getProperty("java.vm.version");
        if (string.startsWith("1.3")) {
            this.editor.requestFocus();
        }
        SearchOptions searchOptions = this.setOptions(true);
        SearchManager.replaceAllText(this.editor, searchOptions);
        return true;
    }

    protected boolean replaceText() {
        SearchOptions searchOptions = this.setOptions(true);
        SearchManager.replaceText(this.editor, searchOptions);
        String string = System.getProperty("java.vm.version");
        if (string.startsWith("1.3")) {
            this.editor.requestFocus();
        }
        return true;
    }

    protected boolean findAllText() {
        Object object;
        SearchOptions searchOptions = this.setOptions(false);
        EditorDocument editorDocument = (EditorDocument)this.editor.getDocument();
        String string = searchOptions.getSearchText();
        try {
            object = new ByteArrayOutputStream();
            EditorManager.getEditorKit().write((OutputStream)object, (Document)editorDocument, 0, editorDocument.getLength());
            ((ByteArrayOutputStream)object).close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            SearchManager.findMatches(this.editor, byteArrayInputStream, searchOptions);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = System.getProperty("java.vm.version");
        if (((String)object).startsWith("1.3")) {
            this.editor.requestFocus();
        }
        return true;
    }

    protected boolean findText() {
        SearchOptions searchOptions = this.setOptions(false);
        SearchManager.findText(this.editor, searchOptions);
        String string = System.getProperty("java.vm.version");
        if (string.startsWith("1.3")) {
            this.editor.requestFocus();
        }
        return true;
    }

    protected boolean validateOptions() {
        String string = this.searchCombo.getEditor().getItem().toString();
        int n2 = string.indexOf(10);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this, a.a(26), a.a(234), 0);
            this.searchCombo.requestFocus();
            return false;
        }
        if (this.regExpCheck.isSelected()) {
            char[] cArray = string.toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (cArray[i2] == '*' || cArray[i2] == '?') continue;
                return true;
            }
            JOptionPane.showMessageDialog(this, a.a(328), a.a(234), 0);
            this.searchCombo.requestFocus();
            return false;
        }
        return true;
    }

    protected SearchOptions setOptions(boolean bl) {
        SearchOptions searchOptions = new SearchOptions();
        String string = this.searchCombo.getEditor().getItem().toString();
        int n2 = string.indexOf(10);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        searchOptions.setSearchText(string);
        SearchManager.addSearchText(string);
        if (bl) {
            String string2 = this.replaceCombo.getEditor().getItem().toString();
            int n3 = string2.indexOf(10);
            if (n3 != -1) {
                string2 = string2.substring(0, n3);
            }
            searchOptions.setReplaceText(string2);
            SearchManager.addReplaceText(string2);
        }
        searchOptions.setCaseSensitive(this.caseSensitiveCheck.isSelected());
        searchOptions.setRegExp(this.regExpCheck.isSelected());
        searchOptions.setGlobalSearch(!this.selectedTextCheck.isSelected());
        searchOptions.setFromCursor(!this.originCheck.isSelected());
        searchOptions.setForwardSearch(this.forwardRadio.isSelected());
        searchOptions.setWholeWordsOnly(this.wholeWordsOnlyCheck.isSelected());
        SearchManager.setSavedOptions(searchOptions);
        return searchOptions;
    }

    protected Component buildDirectionGroup() {
        this.directionGroup.add(this.forwardRadio);
        this.directionGroup.add(this.backwardRadio);
        SearchOptions searchOptions = SearchManager.getSavedOptions();
        if (searchOptions.isForwardSearch()) {
            this.forwardRadio.setSelected(true);
        } else {
            this.backwardRadio.setSelected(true);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(a.a(94)));
        jPanel.add((Component)this.forwardRadio, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 3, 0, 3), 0, 0));
        jPanel.add((Component)this.backwardRadio, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 2, new Insets(0, 3, 0, 3), 0, 0));
        return jPanel;
    }

    protected Component buildOptionsGroup() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(a.a(183)));
        jPanel.add((Component)this.caseSensitiveCheck, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 3, 0, 3), 0, 0));
        jPanel.add((Component)this.regExpCheck, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 3, 0, 3), 0, 0));
        jPanel.add((Component)this.selectedTextCheck, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 3, 0, 3), 0, 0));
        jPanel.add((Component)this.originCheck, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 3, 0, 3), 0, 0));
        jPanel.add((Component)this.wholeWordsOnlyCheck, new GridBagConstraints(0, 4, 1, 1, 0.1, 1.0, 18, 2, new Insets(0, 3, 0, 3), 0, 0));
        SearchOptions searchOptions = SearchManager.getSavedOptions();
        this.caseSensitiveCheck.setSelected(searchOptions.isCaseSensitive());
        this.regExpCheck.setSelected(searchOptions.isRegExp());
        this.selectedTextCheck.setSelected(!searchOptions.isGlobalSearch());
        this.originCheck.setSelected(!searchOptions.isFromCursor());
        this.wholeWordsOnlyCheck.setSelected(searchOptions.isWholeWordsOnly());
        return jPanel;
    }

    protected void jbInit() throws Exception {
        int n2;
        int n3;
        int n4;
        int n5;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.searchLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.searchCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.replaceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.replaceCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.searchButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.replaceButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.searchAllButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 12, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 1.0, 14, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.helpButton, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 14, 2, new Insets(3, 3, 4, 3), 0, 0));
        jPanel.add(this.buildOptionsGroup(), new GridBagConstraints(0, 2, 2, 3, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add(this.buildDirectionGroup(), new GridBagConstraints(0, 5, 2, 2, 1.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.searchCombo.setModel(SearchManager.getSearchHistory());
        this.searchCombo.setEditable(true);
        this.searchCombo.getEditor().getEditorComponent().addKeyListener(new hb(this));
        this.searchCombo.getEditor().getEditorComponent().addFocusListener(new gb(this));
        String string = this.editor.getSelectedText();
        if ((string == null || string.length() == 0) && EditorManager.isSearchWordAtCursor() && (n5 = (string = this.editor.getText(n4 = TextUtilities.getWordStart(this.editor, (n3 = this.editor.getCaretPosition()) + 1), (n2 = TextUtilities.getWordEnd(this.editor, n4)) - n4)).indexOf(10)) != -1) {
            string = null;
        }
        if (string != null && string.length() > 0) {
            if (string.indexOf(10) != -1) {
                this.selectedTextCheck.setSelected(true);
                if (this.searchCombo.getItemCount() > 0) {
                    this.searchCombo.setSelectedIndex(0);
                }
            } else {
                this.searchCombo.setSelectedIndex(-1);
                this.searchCombo.getEditor().setItem(string);
                this.selectedTextCheck.setSelected(false);
            }
        } else {
            this.selectedTextCheck.setSelected(false);
            if (this.searchCombo.getItemCount() > 0) {
                this.searchCombo.setSelectedIndex(0);
            }
        }
        this.replaceCombo.setModel(SearchManager.getReplaceHistory());
        this.replaceCombo.setEditable(true);
        this.replaceCombo.getEditor().getEditorComponent().addKeyListener(new fb(this));
        this.replaceCombo.getEditor().getEditorComponent().addFocusListener(new eb(this));
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)jPanel, "Center");
        this.searchButton.addActionListener(this);
        this.replaceButton.addActionListener(this);
        this.searchAllButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.setDefaultButton(this.g ? this.replaceButton : this.searchButton);
        this.setCancelButton(this.cancelButton);
        this.setHelpButton(this.helpButton);
        this.searchCombo.setNextFocusableComponent(this.replaceCombo);
        this.replaceCombo.setNextFocusableComponent(this.caseSensitiveCheck);
        this.caseSensitiveCheck.setNextFocusableComponent(this.regExpCheck);
        this.regExpCheck.setNextFocusableComponent(this.selectedTextCheck);
        this.selectedTextCheck.setNextFocusableComponent(this.originCheck);
        this.originCheck.setNextFocusableComponent(this.wholeWordsOnlyCheck);
        this.wholeWordsOnlyCheck.setNextFocusableComponent(this.forwardRadio);
        this.forwardRadio.setNextFocusableComponent(this.backwardRadio);
        this.backwardRadio.setNextFocusableComponent(this.searchButton);
        this.searchButton.setNextFocusableComponent(this.replaceButton);
        this.replaceButton.setNextFocusableComponent(this.searchAllButton);
        this.searchAllButton.setNextFocusableComponent(this.cancelButton);
        this.cancelButton.setNextFocusableComponent(this.helpButton);
        this.helpButton.setNextFocusableComponent(this.searchCombo);
        this.searchButton.setMnemonic(a.a(123).charAt(0));
        this.replaceButton.setMnemonic(a.a(208).charAt(0));
        this.searchAllButton.setMnemonic(a.a(121).charAt(0));
        this.caseSensitiveCheck.setMnemonic(a.a(59).charAt(0));
        this.regExpCheck.setMnemonic(a.a(203).charAt(0));
        this.selectedTextCheck.setMnemonic(a.a(242).charAt(0));
        this.originCheck.setMnemonic(a.a(240).charAt(0));
        this.wholeWordsOnlyCheck.setMnemonic(a.a(327).charAt(0));
        this.forwardRadio.setMnemonic(a.a(136).charAt(0));
        this.backwardRadio.setMnemonic(a.a(21).charAt(0));
        this.searchLabel.setDisplayedMnemonic(a.a(297).charAt(0));
        this.replaceLabel.setDisplayedMnemonic(a.a(213).charAt(0));
        this.searchLabel.setLabelFor(this.searchCombo.getEditor().getEditorComponent());
        this.replaceLabel.setLabelFor(this.replaceCombo.getEditor().getEditorComponent());
        if (!this.editor.isEditable() || !this.editor.isEnabled()) {
            this.replaceButton.setEnabled(false);
        }
        if (EditorPane.b && EditorPane.a) {
            b b2 = new b();
            this.searchCombo.addFocusListener(b2);
            this.replaceCombo.addFocusListener(b2);
        }
    }

    public void addNotify() {
        super.addNotify();
        ((JComponent)this.searchCombo.getEditor().getEditorComponent()).requestFocus();
    }

    public SearchDialog(EditorPane editorPane, boolean bl) {
        this((Component)editorPane, bl ? a.a(211) : a.a(124), editorPane, bl);
    }

    public SearchDialog(Component component, String string, EditorPane editorPane, boolean bl) {
        super(component, string, true);
        this.replaceButton = new JButton(a.a(210));
        this.searchAllButton = new JButton(a.a(120));
        this.cancelButton = new JButton(a.a(53));
        this.helpButton = new JButton(a.a(143));
        this.borderLayout1 = new BorderLayout();
        this.searchLabel = new JLabel(a.a(296));
        this.searchCombo = new jb(this);
        this.replaceLabel = new JLabel(a.a(212));
        this.replaceCombo = new ib(this);
        this.caseSensitiveCheck = new JCheckBox(a.a(58));
        this.regExpCheck = new JCheckBox(a.a(202));
        this.selectedTextCheck = new JCheckBox(a.a(241));
        this.originCheck = new JCheckBox(a.a(239));
        this.wholeWordsOnlyCheck = new JCheckBox(a.a(125));
        this.forwardRadio = new JRadioButton(a.a(135));
        this.backwardRadio = new JRadioButton(a.a(20));
        this.directionGroup = new ButtonGroup();
        this.editor = editorPane;
        this.g = bl;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

