/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.BasicStyleMap;
import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.LineMark;
import com.borland.primetime.editor.TextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.ViewFactory;

public class EditorView
extends PlainView {
    protected int sel1;
    protected int sel0;

    static Segment a(EditorView editorView) {
        return editorView.a();
    }

    protected int getTabSize() {
        return EditorManager.getTabSize();
    }

    protected Rectangle lineToRect(Shape shape, int n2) {
        Rectangle rectangle = null;
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n2 * this.metrics.getHeight(), rectangle2.width, this.metrics.getHeight());
        }
        return rectangle;
    }

    protected void damageLineRange(int n2, int n3, Shape shape, Component component) {
        if (shape != null) {
            Rectangle rectangle = this.lineToRect(shape, n2);
            Rectangle rectangle2 = this.lineToRect(shape, n3);
            if (rectangle != null && rectangle2 != null) {
                Rectangle rectangle3 = rectangle.union(rectangle2);
                component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            } else {
                component.repaint();
            }
        }
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container = this.getContainer();
        if (container.isShowing()) {
            Element[] elementArray;
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
            Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
            if (elementArray != null && elementArray.length > 0) {
                ((Component)container).invalidate();
                container.repaint();
            } else if (elementArray2 != null && elementArray2.length > 0) {
                Element element2 = this.getElement();
                int n2 = element2.getElementIndex(documentEvent.getOffset());
                int n3 = element2.getElementCount() - 1;
                ((Component)container).invalidate();
                this.damageLineRange(n2, n3, shape, container);
            } else {
                Element element3 = this.getElement();
                int n4 = element3.getElementIndex(documentEvent.getOffset());
                int n5 = element3.getElementIndex(documentEvent.getOffset() + documentEvent.getLength() - 1);
                this.damageLineRange(n4, n5, shape, container);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    protected int drawUnselectedText(Graphics graphics, EditorDocument.StyledLeafElement styledLeafElement, int n2, int n3, int n4, int n5) throws BadLocationException {
        EditorPane editorPane = (EditorPane)this.getContainer();
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        BasicStyleMap basicStyleMap = editorDocument.getStyleMap();
        DrawTextSegment drawTextSegment = new DrawTextSegment(this, graphics, n2, n3, editorPane, editorDocument, basicStyleMap, this);
        int n6 = n4;
        while (n6 < n5) {
            Color color;
            int n7 = styledLeafElement.getEndOfRun(n6);
            n7 = n7 <= n5 && n7 != -1 ? n7 : n5;
            Style style = styledLeafElement.getStyle(n6);
            Color color2 = (Color)style.getAttribute(StyleConstants.Foreground);
            if (color2 == null) {
                color2 = Color.black;
            }
            if ((color = (Color)style.getAttribute(StyleConstants.Background)) == null) {
                color = Color.white;
            }
            drawTextSegment.addSegment(color2, color, basicStyleMap.getFont(style), n6, n7, styledLeafElement.isWhitespace(n6));
            n6 = n7;
        }
        return drawTextSegment.flush();
    }

    protected int drawSelectedText(Graphics graphics, EditorDocument.StyledLeafElement styledLeafElement, Color color, Color color2, int n2, int n3, int n4, int n5) throws BadLocationException {
        EditorPane editorPane = (EditorPane)this.getContainer();
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        BasicStyleMap basicStyleMap = editorDocument.getStyleMap();
        DrawTextSegment drawTextSegment = new DrawTextSegment(this, graphics, n2, n3, editorPane, editorDocument, basicStyleMap, this);
        if (color == null) {
            color = editorPane.getSelectedTextColor();
        }
        if (color2 == null) {
            color2 = editorPane.getSelectionColor();
        }
        int n6 = n4;
        while (n6 < n5) {
            int n7 = styledLeafElement.getEndOfRun(n6);
            n7 = n7 <= n5 && n7 != -1 ? n7 : n5;
            Style style = styledLeafElement.getStyle(n6);
            drawTextSegment.addSegment(color, color2, basicStyleMap.getFont(style), n6, n7, styledLeafElement.isWhitespace(n6));
            n6 = n7;
        }
        return drawTextSegment.flush();
    }

    private final Segment a() {
        return super.getLineBuffer();
    }

    protected int drawSelectedText(Graphics graphics, EditorDocument.StyledLeafElement styledLeafElement, int n2, int n3, int n4, int n5) throws BadLocationException {
        return this.drawSelectedText(graphics, styledLeafElement, null, null, n2, n3, n4, n5);
    }

    protected int drawElement(Element element, int n2, Graphics graphics, int n3, int n4) throws BadLocationException {
        try {
            Object object;
            Object object2;
            EditorDocument.StyledLeafElement styledLeafElement = (EditorDocument.StyledLeafElement)element;
            int n5 = styledLeafElement.getStartOffset();
            int n6 = styledLeafElement.getEndOffset();
            n6 = Math.min(this.getDocument().getLength(), n6);
            EditorPane editorPane = (EditorPane)this.getContainer();
            EditorDocument editorDocument = (EditorDocument)this.getDocument();
            Color color = null;
            Color color2 = null;
            FontMetrics fontMetrics = editorPane.getFontMetrics();
            boolean bl = false;
            int n7 = -1;
            LineMark[] lineMarkArray = editorDocument.getLineMarks(n2);
            for (int i2 = 0; i2 < lineMarkArray.length; ++i2) {
                object2 = lineMarkArray[i2];
                if (((LineMark)object2).getDisplayPriority() <= n7 || (object = ((LineMark)object2).getStyle()) == null || !((LineMark)object2).displayInEditor(editorPane)) continue;
                n7 = ((LineMark)object2).getDisplayPriority();
                color2 = StyleConstants.getForeground((AttributeSet)object);
                color = StyleConstants.getBackground((AttributeSet)object);
                bl = true;
            }
            AttributeSet attributeSet = element.getAttributes();
            if (EditorView.a(attributeSet)) {
                object2 = EditorManager.getStyleContext().getStyle("input_method");
                if (object2 != null) {
                    object = (Color)object2.getAttribute(StyleConstants.Foreground);
                    graphics.setColor((Color)(object != null ? object : editorPane.getForeground()));
                } else {
                    graphics.setColor(editorPane.getForeground());
                }
                n3 = this.a(attributeSet, graphics, n3, n4, n5 - element.getStartOffset(), n6 - element.getStartOffset());
            } else if (!bl) {
                if (this.sel0 == this.sel1) {
                    n3 = this.drawUnselectedText(graphics, styledLeafElement, n3, n4, n5, n6);
                } else if (n5 >= this.sel0 && n5 <= this.sel1 && n6 >= this.sel0 && n6 <= this.sel1) {
                    n3 = this.drawSelectedText(graphics, styledLeafElement, n3, n4, n5, n6);
                    graphics.setColor(editorPane.getSelectionColor());
                    graphics.fillRect(n3, n4 - fontMetrics.getAscent(), editorPane.getWidth() - n3, fontMetrics.getHeight());
                } else if (this.sel0 >= n5 && this.sel0 < n6) {
                    if (this.sel1 >= n5 && this.sel1 < n6) {
                        n3 = this.drawUnselectedText(graphics, styledLeafElement, n3, n4, n5, this.sel0);
                        n3 = this.drawSelectedText(graphics, styledLeafElement, n3, n4, this.sel0, this.sel1);
                        n3 = this.drawUnselectedText(graphics, styledLeafElement, n3, n4, this.sel1, n6);
                    } else {
                        n3 = this.drawUnselectedText(graphics, styledLeafElement, n3, n4, n5, this.sel0);
                        n3 = this.drawSelectedText(graphics, styledLeafElement, n3, n4, this.sel0, n6);
                        graphics.setColor(editorPane.getSelectionColor());
                        graphics.fillRect(n3, n4 - fontMetrics.getAscent(), editorPane.getWidth() - n3, fontMetrics.getHeight());
                    }
                } else if (this.sel1 >= n5 && this.sel1 <= n6) {
                    n3 = this.drawSelectedText(graphics, styledLeafElement, n3, n4, n5, this.sel1);
                    n3 = this.drawUnselectedText(graphics, styledLeafElement, n3, n4, this.sel1, n6);
                } else {
                    n3 = this.drawUnselectedText(graphics, styledLeafElement, n3, n4, n5, n6);
                }
            } else if (this.sel0 == this.sel1) {
                n3 = this.drawSelectedText(graphics, styledLeafElement, color2, color, n3, n4, n5, n6);
                graphics.setColor(color);
                graphics.fillRect(n3, n4 - fontMetrics.getAscent(), editorPane.getWidth() - n3, fontMetrics.getHeight());
            } else if (n5 >= this.sel0 && n5 <= this.sel1 && n6 >= this.sel0 && n6 <= this.sel1) {
                n3 = this.drawSelectedText(graphics, styledLeafElement, color, color2, n3, n4, n5, n6);
                graphics.setColor(color2);
                graphics.fillRect(n3, n4 - fontMetrics.getAscent(), editorPane.getWidth() - n3, fontMetrics.getHeight());
            } else if (this.sel0 >= n5 && this.sel0 < n6) {
                if (this.sel1 >= n5 && this.sel1 < n6) {
                    n3 = this.drawSelectedText(graphics, styledLeafElement, color2, color, n3, n4, n5, this.sel0);
                    n3 = this.drawSelectedText(graphics, styledLeafElement, color, color2, n3, n4, this.sel0, this.sel1);
                    n3 = this.drawSelectedText(graphics, styledLeafElement, color2, color, n3, n4, this.sel1, n6);
                    graphics.setColor(color);
                    graphics.fillRect(n3, n4 - fontMetrics.getAscent(), editorPane.getWidth() - n3, fontMetrics.getHeight());
                } else {
                    n3 = this.drawSelectedText(graphics, styledLeafElement, color2, color, n3, n4, n5, this.sel0);
                    n3 = this.drawSelectedText(graphics, styledLeafElement, color, color2, n3, n4, this.sel0, n6);
                    graphics.setColor(color2);
                    graphics.fillRect(n3, n4 - fontMetrics.getAscent(), editorPane.getWidth() - n3, fontMetrics.getHeight());
                }
            } else if (this.sel1 >= n5 && this.sel1 <= n6) {
                n3 = this.drawSelectedText(graphics, styledLeafElement, color, color2, n3, n4, n5, this.sel1);
                n3 = this.drawSelectedText(graphics, styledLeafElement, color2, color, n3, n4, this.sel1, n6);
                graphics.setColor(color);
                graphics.fillRect(n3, n4 - fontMetrics.getAscent(), editorPane.getWidth() - n3, fontMetrics.getHeight());
            } else {
                n3 = this.drawSelectedText(graphics, styledLeafElement, color2, color, n3, n4, n5, n6);
                graphics.setColor(color);
                graphics.fillRect(n3, n4 - fontMetrics.getAscent(), editorPane.getWidth() - n3, fontMetrics.getHeight());
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return n3;
    }

    int a(AttributeSet attributeSet, Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
        attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
        if (n4 >= n5) {
            return n2;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n4, n5);
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, n2, n3);
        return n2 + (int)textLayout.getAdvance();
    }

    static boolean a(AttributeSet attributeSet) {
        return attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute);
    }

    protected void drawLine(int n2, Graphics graphics, int n3, int n4) {
        Element element = this.getElement().getElement(n2);
        try {
            if (element.isLeaf()) {
                this.drawElement(element, n2, graphics, n3, n4);
            } else {
                int n5 = element.getElementCount();
                for (int i2 = 0; i2 < n5; ++i2) {
                    Element element2 = element.getElement(i2);
                    n3 = this.drawElement(element2, n2, graphics, n3, n4);
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        EditorPane editorPane = (EditorPane)this.getContainer();
        this.sel0 = editorPane.getSelectionStart();
        this.sel1 = editorPane.getSelectionEnd();
        super.paint(graphics, shape);
        if (EditorManager.isVisibleMargin()) {
            graphics.setColor(Color.lightGray);
            int n2 = editorPane.fontWidth * EditorManager.getRightMargin() + 2;
            graphics.drawLine(n2, 0, n2, editorPane.getHeight());
        }
    }

    public EditorView(Element element) {
        super(element);
    }

    protected class DrawTextSegment {
        public boolean whiteSpace = true;
        public int p1;
        public int p0 = -1;
        public Font font;
        public Color bgColor;
        public Color textColor;
        public EditorView view;
        public BasicStyleMap styleMap;
        public EditorDocument doc;
        public EditorPane host;
        public int y;
        public int x;
        public Graphics g;

        protected int flush() throws BadLocationException {
            if (this.textColor == null) {
                return this.x;
            }
            Segment segment = EditorView.a(this.view);
            this.doc.getText(this.p0, this.p1 - this.p0, segment);
            this.g.setFont(this.font);
            if (!this.host.getBackground().equals(this.bgColor)) {
                FontMetrics fontMetrics = this.host.getFontMetrics();
                this.g.setColor(this.bgColor);
                this.g.fillRect(this.x, this.y - fontMetrics.getAscent(), TextUtilities.getTabbedTextWidth(segment, fontMetrics, this.x, this.view, this.p0), fontMetrics.getHeight());
            }
            this.g.setColor(this.textColor);
            this.x = TextUtilities.drawTabbedText(segment, this.x, this.y, this.g, this.view, this.p0);
            this.p0 = -1;
            this.textColor = null;
            this.bgColor = null;
            this.font = null;
            this.whiteSpace = true;
            return this.x;
        }

        public void addSegment(Color color, Color color2, Font font, int n2, int n3, boolean bl) throws BadLocationException {
            if (color != this.textColor && !bl && !this.whiteSpace || color2 != this.bgColor || font != this.font && !font.equals(this.font) && !bl && !this.whiteSpace || n2 != this.p1) {
                this.x = this.flush();
            }
            this.bgColor = color2;
            if (this.p0 < 0) {
                this.p0 = n2;
            }
            this.p1 = n3;
            boolean bl2 = this.whiteSpace = this.whiteSpace && bl;
            if (!bl || this.font == null) {
                this.font = font;
            }
            if (!bl || this.textColor == null) {
                this.textColor = color;
            }
        }

        public DrawTextSegment(EditorView editorView, Graphics graphics, int n2, int n3, EditorPane editorPane, EditorDocument editorDocument, BasicStyleMap basicStyleMap, EditorView editorView2) {
            this.g = graphics;
            this.x = n2;
            this.y = n3;
            this.host = editorPane;
            this.doc = editorDocument;
            this.styleMap = basicStyleMap;
            this.view = editorView2;
        }
    }
}

