/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.JBUndoManager;
import com.borland.primetime.editor.LineMark;
import com.borland.primetime.editor.MasterStyleContext;
import com.borland.primetime.editor.ModalKeymap;
import com.borland.primetime.editor.ToolTipProvider;
import com.borland.primetime.editor.a;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.im.InputContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.Keymap;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class EditorPane
extends JEditorPane
implements PropertyChangeListener,
FocusListener {
    public static int LINE_PADDING;
    public static final int NOT_OUT_OF_BOUNDS = 11;
    public static final int TWOTHIRD_IF_OFFSCREEN = 10;
    public static final int TWOTHIRD_IF_NEAR_EDGE = 9;
    public static final int TWOTHIRD_ALWAYS = 8;
    public static final int ONETHIRD_IF_OFFSCREEN = 7;
    public static final int ONETHIRD_IF_NEAR_EDGE = 6;
    public static final int ONETHIRD_ALWAYS = 5;
    public static final int ONSCREEN = 4;
    public static final int CENTER_NEVER = 4;
    public static final int CENTER_IF_OFFSCREEN = 3;
    public static final int CENTER_IF_NEAR_EDGE = 2;
    public static final int CENTER_ALWAYS = 1;
    static final boolean a;
    static final boolean b;
    protected WeakReference editorRef;
    protected Action lastAction;
    public ModalKeymap.ModeStateInfo keymapStateInfo;
    protected int fontHeight;
    protected int fontWidth;
    protected FontMetrics fontMetrics;
    protected boolean popupEnabled = true;
    public boolean processedKeyPressed = false;
    protected LineMark temporaryMark;
    protected HighlightMark highlightMark = new HighlightMark();
    protected static ToolTipProvider toolTipProvider;

    static {
        b = System.getProperty("user.language").equals("ja");
        a = !System.getProperty("os.name").toLowerCase().startsWith("win");
        CENTER_ALWAYS = 1;
        CENTER_IF_NEAR_EDGE = 2;
        CENTER_IF_OFFSCREEN = 3;
        CENTER_NEVER = 4;
        ONSCREEN = 4;
        ONETHIRD_ALWAYS = 5;
        ONETHIRD_IF_NEAR_EDGE = 6;
        ONETHIRD_IF_OFFSCREEN = 7;
        TWOTHIRD_ALWAYS = 8;
        TWOTHIRD_IF_NEAR_EDGE = 9;
        TWOTHIRD_IF_OFFSCREEN = 10;
        NOT_OUT_OF_BOUNDS = 11;
        LINE_PADDING = 2;
    }

    public WeakReference getReference() {
        return this.editorRef;
    }

    public static void registerToolTipProvider(ToolTipProvider toolTipProvider) {
        EditorPane.toolTipProvider = toolTipProvider;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (toolTipProvider != null) {
            return toolTipProvider.getToolTipText(mouseEvent);
        }
        return super.getToolTipText(mouseEvent);
    }

    public void setTopLine(int n2) {
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementCount();
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        int n4 = rectangle.height / this.fontHeight;
        n2 = Math.min(n2, n3 - n4);
        if (n2 < 1) {
            n2 = 1;
        }
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            jViewport.setViewPosition(new Point(0, (n2 - 1) * this.fontHeight));
            return;
        }
    }

    public int getTopLine() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Point point = jViewport.getViewPosition();
            if (point.y > 0) {
                return point.y / this.fontHeight + 1;
            }
        }
        return 0;
    }

    public void selectCharacters(int n2) {
        int n3 = this.getCaretPosition();
        this.moveCaretPosition(n3 + n2);
    }

    public int calcCaretPosition(int n2, int n3) {
        int n4;
        Element element;
        int n5;
        Element element2 = this.getDocument().getDefaultRootElement();
        int n6 = element2.getElementCount();
        if (n2 >= n6) {
            n2 = n6;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if ((n5 = (element = element2.getElement(n2 - 1)).getStartOffset()) + n3 - 1 >= (n4 = element.getEndOffset())) {
            if (n4 != 0) {
                --n4;
            }
            return n4;
        }
        return n5 + n3 - 1;
    }

    public void setCaretPosition(int n2, int n3) {
        int n4 = this.calcCaretPosition(n2, n3);
        this.gotoLine(n2, false, 6);
        this.setCaretPosition(n4);
    }

    public void insertAt(int n2, int n3, String string) {
        this.setCaretPosition(this.calcCaretPosition(n2, n3));
        this.replaceSelection(string);
    }

    public void insertAt(int n2, String string) {
        this.setCaretPosition(n2);
        this.replaceSelection(string);
    }

    public String getTextLine(int n2) {
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementCount();
        if (n2 < 1 || n2 > n3) {
            return null;
        }
        Element element2 = element.getElement(n2 - 1);
        int n4 = element2.getStartOffset();
        int n5 = element2.getEndOffset();
        try {
            String string = this.getText(n4, n5 - n4);
            return string;
        }
        catch (BadLocationException badLocationException) {
            String string = null;
            return string;
        }
    }

    public int getColumnNumber(int n2) {
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementIndex(n2);
        Element element2 = element.getElement(n3);
        int n4 = element2.getStartOffset();
        return n2 - n4 + 1;
    }

    public int getLineNumber(int n2) {
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementIndex(n2);
        return n3 + 1;
    }

    public void gotoPosition(int n2, int n3) {
        this.gotoPosition(n2, n3, false, 5);
    }

    public void gotoPosition(int n2, int n3, boolean bl) {
        int n4 = this.calcCaretPosition(n2, n3);
        this.gotoOffset(n4, bl, 5, 0, 0);
    }

    public void gotoPosition(int n2, int n3, boolean bl, int n4) {
        int n5 = this.calcCaretPosition(n2, n3);
        this.gotoOffset(n5, bl, n4, 0, 0);
    }

    public void gotoLine(int n2) {
        this.gotoLine(n2, true, 5);
    }

    public void gotoLine(int n2, boolean bl) {
        this.gotoLine(n2, bl, 5);
    }

    public void gotoLine(int n2, boolean bl, int n3) {
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n2 - 1);
        int n4 = element2.getStartOffset();
        this.gotoOffset(n4, bl, n3, 0, 0);
    }

    public void gotoOffset(int n2) {
        this.gotoOffset(n2, false, 5, 0, 0);
    }

    public void gotoOffset(int n2, boolean bl) {
        this.gotoOffset(n2, bl, 5, 0, 0);
    }

    public void gotoOffset(int n2, boolean bl, int n3, int n4, int n5) {
        block18: {
            Element element = this.getDocument().getDefaultRootElement();
            int n6 = element.getElementIndex(n2) + 1;
            Element element2 = element.getElement(n6 - 1);
            int n7 = element.getElementCount();
            if (n6 < 1 || n6 > n7) {
                return;
            }
            Rectangle rectangle = new Rectangle();
            this.computeVisibleRect(rectangle);
            int n8 = rectangle.y / this.fontHeight;
            int n9 = rectangle.height / this.fontHeight;
            double d2 = 0.0;
            int n10 = 0;
            int n11 = -1;
            boolean bl2 = false;
            switch (n3) {
                case 5: {
                    d2 = 3.0;
                    bl2 = true;
                    break;
                }
                case 8: {
                    d2 = 1.5;
                    bl2 = true;
                    break;
                }
                case 1: {
                    d2 = 2.0;
                    bl2 = true;
                    break;
                }
                case 6: {
                    d2 = 3.0;
                    n10 = LINE_PADDING;
                    break;
                }
                case 9: {
                    d2 = 1.5;
                    n10 = LINE_PADDING;
                    break;
                }
                case 2: {
                    d2 = 2.0;
                    n10 = LINE_PADDING;
                    break;
                }
                case 7: {
                    d2 = 3.0;
                    break;
                }
                case 10: {
                    d2 = 1.5;
                    break;
                }
                case 3: {
                    d2 = 2.0;
                    break;
                }
                default: {
                    int n12 = Math.max(1, n6 - LINE_PADDING);
                    int n13 = Math.min(n7, n6 + LINE_PADDING);
                    if (n12 < n8) {
                        n11 = n12;
                        break;
                    }
                    if (n13 > n8 + n9) {
                        n11 = n13 - n9;
                        break;
                    }
                    n11 = -2;
                    break;
                }
                case 11: {
                    if (n4 <= 0 || n5 <= 0 || n6 > n8 && n6 < n8 + n9 && (n6 < n8 + n4 || n6 > n8 + n5)) break;
                    if (n4 >= n9 - n5) {
                        n11 = Math.max(1, n6 - LINE_PADDING);
                        break;
                    }
                    n11 = Math.max(1, n6 - n5 - LINE_PADDING);
                    break;
                }
            }
            if (n11 == -1 && (bl2 || n6 < n8 + n10 || n6 > n8 + n9 - n10)) {
                n11 = Math.max(1, n6 - (int)((double)n9 / d2));
            }
            if (n11 > 0) {
                this.setTopLine(n11);
            }
            this.setCaretPosition(n2);
            if (!bl) break block18;
            this.setHighlight(n6);
        }
    }

    public void gotoOffset(int n2, boolean bl, int n3) {
        this.gotoOffset(n2, bl, n3, 0, 0);
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    public void repaintLine(int n2) {
        if (n2 < 1 || n2 > this.getLineCount()) {
            return;
        }
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.fireRowsChanged(n2 - 1, n2 - 1);
    }

    public void clearTemporaryMark() {
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        this.temporaryMark.removeEditor();
        int n2 = editorDocument.removeLineMark(this.temporaryMark);
        if (n2 != -1) {
            this.repaintLine(n2 + 1);
        }
    }

    public void clearHighlight() {
        this.clearTemporaryMark();
    }

    public void setHighlight(int n2) {
        this.setTemporaryMark(n2, this.highlightMark);
    }

    public void setTemporaryMark(int n2, LineMark lineMark) {
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        this.temporaryMark.removeEditor();
        int n3 = editorDocument.removeLineMark(this.temporaryMark);
        this.temporaryMark = lineMark;
        this.temporaryMark.addEditor(this);
        int n4 = editorDocument.setLineMark(n2 - 1, this.temporaryMark);
        if (n3 != -1) {
            this.repaintLine(n3 + 1);
        }
        this.repaintLine(n4 + 1);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("font")) {
            Font font = (Font)propertyChangeEvent.getNewValue();
            this.setFont(font);
        } else if (string.equals("tabSize")) {
            ((EditorDocument)this.getDocument()).changeTabSize(propertyChangeEvent.getNewValue());
            this.updateUI();
        } else if (string.equals("rightMargin")) {
            this.repaint();
        } else if (string.equals("visibleMargin")) {
            this.repaint();
        } else if (string.equals("keymap")) {
            Keymap keymap = EditorManager.getKeymap();
            if (keymap instanceof ModalKeymap) {
                ModalKeymap modalKeymap = (ModalKeymap)keymap;
                this.keymapStateInfo = modalKeymap.createStateInfo(this);
            } else {
                this.keymapStateInfo = null;
            }
            this.setKeymap(keymap);
        } else if (string.equals("styleContext")) {
            this.updateColors();
            this.repaint();
        } else if (string.equals("blinkCaret")) {
            if (EditorManager.isBooleanOptionValue("blinkCaret")) {
                this.getCaret().setBlinkRate(500);
            } else {
                this.getCaret().setBlinkRate(0);
            }
        } else if (string.equals("caret")) {
            this.setCaret(EditorManager.getCaret());
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!b) {
            return;
        }
        if (!a) {
            return;
        }
        InputContext inputContext = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            inputContext = ((Window)container).getInputContext();
            break;
        }
        if (inputContext != null) {
            inputContext.endComposition();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        EditorAction.setFocusedEditor(this);
        this.clearTemporaryMark();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        switch (n2) {
            case 1: {
                return rectangle.height - rectangle.height % this.fontHeight;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException(String.valueOf(String.valueOf(com.borland.primetime.editor.a.a(154))).concat(String.valueOf(String.valueOf(n2))));
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        switch (n2) {
            case 1: {
                return this.fontHeight;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException(String.valueOf(String.valueOf(com.borland.primetime.editor.a.a(154))).concat(String.valueOf(String.valueOf(n2))));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = this.fontWidth * 1028;
        return dimension;
    }

    public void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n2 = 0;
                int n3 = 0;
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    int n4 = cArray[i2];
                    if (n4 == 10 && n2 == 13) {
                        n2 = n4;
                        continue;
                    }
                    n2 = n4;
                    if (n4 == 13) {
                        n4 = 10;
                    }
                    if (n4 == 12) {
                        n4 = 10;
                    }
                    cArray2[n3++] = n4;
                }
                this.replaceSelection(new String(cArray2, 0, n3));
            }
            catch (Exception exception) {
                this.getToolkit().beep();
            }
        }
    }

    public void replaceSelection(String string) {
        Caret caret;
        if (!this.isEditable() || !this.isEnabled()) {
            this.getToolkit().beep();
            return;
        }
        if (string == null && (caret = this.getCaret()).getDot() == caret.getMark()) {
            return;
        }
        this.startUndoGroup();
        super.replaceSelection(string);
        this.endUndoGroup();
    }

    public void overwriteChar(String string) throws BadLocationException {
        if (!this.isEditable() || !this.isEnabled()) {
            this.getToolkit().beep();
            return;
        }
        Caret caret = this.getCaret();
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.getUndoManager().startUndoSegment(caret.getDot(), caret.getMark(), 1);
        editorDocument.remove(caret.getDot(), 1);
        ((AbstractDocument)editorDocument).insertString(caret.getDot(), string, null);
        editorDocument.getUndoManager().endUndoSegment(caret.getDot(), caret.getMark());
    }

    public void deletePrevChar() throws BadLocationException {
        if (!this.isEditable() || !this.isEnabled()) {
            this.getToolkit().beep();
            return;
        }
        Caret caret = this.getCaret();
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.getUndoManager().startUndoSegment(caret.getDot(), caret.getMark(), 2);
        editorDocument.remove(caret.getDot() - 1, 1);
        editorDocument.getUndoManager().endUndoSegment(caret.getDot(), caret.getMark());
    }

    public void deleteNextChar() throws BadLocationException {
        if (!this.isEditable() || !this.isEnabled()) {
            this.getToolkit().beep();
            return;
        }
        Caret caret = this.getCaret();
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.getUndoManager().startUndoSegment(caret.getDot(), caret.getMark(), 2);
        editorDocument.remove(caret.getDot(), 1);
        editorDocument.getUndoManager().endUndoSegment(caret.getDot(), caret.getMark());
    }

    public void insertChar(String string) throws BadLocationException {
        if (!this.isEditable() || !this.isEnabled()) {
            this.getToolkit().beep();
            return;
        }
        Caret caret = this.getCaret();
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.getUndoManager().startUndoSegment(caret.getDot(), caret.getMark(), 1);
        ((AbstractDocument)editorDocument).insertString(caret.getDot(), string, null);
        editorDocument.getUndoManager().endUndoSegment(caret.getDot(), caret.getMark());
    }

    protected void positionCaret(int n2, int n3) {
        if (n2 != -1) {
            if (n3 != -1) {
                this.gotoOffset(n3, false, 6);
                this.moveCaretPosition(n2);
            } else {
                this.gotoOffset(n2, false, 6);
            }
        }
    }

    public void redo(boolean bl) {
        if (!this.isEditable() || !this.isEnabled()) {
            this.getToolkit().beep();
            return;
        }
        Caret caret = this.getCaret();
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        try {
            JBUndoManager jBUndoManager = editorDocument.getUndoManager();
            int n2 = jBUndoManager.getRedoStartPoint();
            int n3 = jBUndoManager.getRedoStartMark();
            if (!(bl && (n2 != -1 && n2 != caret.getDot() || n3 != -1 && n3 != caret.getMark()))) {
                int n4 = jBUndoManager.getRedoEndPoint();
                int n5 = jBUndoManager.getRedoEndMark();
                jBUndoManager.redo();
                this.positionCaret(n4, n5);
            } else {
                this.positionCaret(n2, n3);
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void redo() {
        this.redo(true);
    }

    public void undo(boolean bl) {
        if (!this.isEditable() || !this.isEnabled()) {
            this.getToolkit().beep();
            return;
        }
        Caret caret = this.getCaret();
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        try {
            JBUndoManager jBUndoManager = editorDocument.getUndoManager();
            int n2 = jBUndoManager.getUndoEndPoint();
            int n3 = jBUndoManager.getUndoEndMark();
            if (!(bl && (n2 != -1 && n2 != caret.getDot() || n3 != -1 && n3 != caret.getMark()))) {
                int n4 = jBUndoManager.getUndoStartPoint();
                int n5 = jBUndoManager.getUndoStartMark();
                jBUndoManager.undo();
                editorDocument.fireRowsChanged(0, 0);
                this.positionCaret(n4, n5);
            } else {
                this.positionCaret(n2, n3);
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void undo() {
        this.undo(true);
    }

    public boolean canRedo() {
        if (!this.isEditable() || !this.isEnabled()) {
            return false;
        }
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        return editorDocument.getUndoManager().canRedo();
    }

    public boolean canUndo() {
        if (!this.isEditable() || !this.isEnabled()) {
            return false;
        }
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        return editorDocument.getUndoManager().canUndo();
    }

    public void endUndoSegment() {
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.getUndoManager().endUndoSegment(this.getCaret().getDot(), this.getCaret().getMark());
    }

    public void startUndoSegment(int n2) {
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.getUndoManager().startUndoSegment(this.getCaret().getDot(), this.getCaret().getMark(), n2);
    }

    public void endUndoGroup() {
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.getUndoManager().endUndoGroup(this.getCaret().getDot(), this.getCaret().getMark());
    }

    public void startUndoGroup() {
        EditorDocument editorDocument = (EditorDocument)this.getDocument();
        editorDocument.getUndoManager().startUndoGroup(this.getCaret().getDot(), this.getCaret().getMark());
    }

    public void setPopupEnabled(boolean bl) {
        this.popupEnabled = bl;
    }

    public boolean isPopupEnabled() {
        return this.popupEnabled;
    }

    public ModalKeymap.ModeStateInfo getKeymapStateInfo() {
        return this.keymapStateInfo;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public int getFontWidth() {
        return this.fontWidth;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (font != null) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
            this.fontWidth = fontMetrics.charWidth(' ');
            this.fontHeight = fontMetrics.getHeight();
            this.fontMetrics = fontMetrics;
        }
    }

    public void setCaret(Caret caret) {
        Caret caret2 = this.getCaret();
        if (caret2 != null) {
            int n2 = caret2.getDot();
            int n3 = caret2.getMark();
            super.setCaret(caret);
            if (caret != null) {
                caret.setDot(n3);
                caret.moveDot(n2);
            }
        } else {
            super.setCaret(caret);
        }
    }

    public void updateColors(StyleContext styleContext) {
        Style style = styleContext.getStyle("whitespace");
        if (style != null) {
            this.setForeground(StyleConstants.getForeground(style));
            this.setBackground(StyleConstants.getBackground(style));
        } else {
            this.setForeground(UIManager.getColor("EditorPane.foreground"));
            this.setBackground(UIManager.getColor("EditorPane.background"));
        }
        style = styleContext.getStyle("selection");
        if (style != null) {
            this.setSelectedTextColor(StyleConstants.getForeground(style));
            this.setSelectionColor(StyleConstants.getBackground(style));
        } else {
            this.setSelectedTextColor(UIManager.getColor("TextArea.selectionForeground"));
            this.setSelectionColor(UIManager.getColor("TextArea.selectionBackground"));
        }
        style = styleContext.getStyle("caret");
        if (style != null) {
            this.setCaretColor(StyleConstants.getForeground(style));
        } else {
            this.setCaretColor(UIManager.getColor("TextPane.caretForeground"));
        }
    }

    public void updateColors() {
        MasterStyleContext masterStyleContext = EditorManager.getStyleContext();
        this.updateColors(masterStyleContext);
    }

    public void updateUI() {
        super.updateUI();
        this.setMargin(new Insets(0, 3, 0, 0));
        this.updateColors();
        this.setKeymap(EditorManager.getKeymap());
    }

    public void release() {
        this.keymapStateInfo = null;
    }

    public EditorPane() {
        this.temporaryMark = this.highlightMark;
        this.addFocusListener(this);
        this.setCursor(Cursor.getPredefinedCursor(2));
        Keymap keymap = EditorManager.getKeymap();
        if (keymap instanceof ModalKeymap) {
            ModalKeymap modalKeymap = (ModalKeymap)keymap;
            this.keymapStateInfo = modalKeymap.createStateInfo(this);
        } else {
            this.keymapStateInfo = null;
        }
        this.editorRef = new WeakReference<EditorPane>(this);
    }

    public Action getLastAction() {
        return this.lastAction;
    }

    public void setLastAction(Action action) {
        this.lastAction = action;
    }

    public static class HighlightMark
    extends LineMark {
        static Style a;

        static {
            MasterStyleContext masterStyleContext = EditorManager.getStyleContext();
            a = ((StyleContext)masterStyleContext).addStyle("line_highlight", null);
            a.addAttribute("DisplayName", com.borland.primetime.editor.a.a(164));
            StyleConstants.setBackground(a, Color.yellow);
            StyleConstants.setForeground(a, Color.black);
        }

        public HighlightMark() {
            super(a);
            this.setDisplayPriority(950);
        }
    }
}

