/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.BasicStyleMap;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.JBUndoManager;
import com.borland.primetime.editor.LineMark;
import com.borland.primetime.editor.NullScanner;
import com.borland.primetime.editor.Scanner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.Style;

public class EditorDocument
extends PlainDocument {
    protected MarkList markList;
    public static final String NOMARK = "NoMark";
    public static final LineMark[] EMPTY_MARKLIST;
    protected JBUndoManager undoManager;
    protected Scanner scanner = DEFAULT_SCANNER;
    protected BasicStyleMap styleMap;
    public static final String I18NProperty = "i18n";
    protected WeakReference docRef;
    public static final Scanner DEFAULT_SCANNER;

    static {
        DEFAULT_SCANNER = new NullScanner();
        I18NProperty = I18NProperty;
        EMPTY_MARKLIST = new LineMark[0];
        NOMARK = NOMARK;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n2, int n3) {
        return new StyledLeafElement(element, attributeSet, n2, n3);
    }

    public int getMarkIndex(LineMark lineMark) {
        return this.markList.indexOf(lineMark);
    }

    public LineMark[] getLineMarks(int n2, EditorPane editorPane) {
        LineMark[] lineMarkArray = this.markList.getMarks(n2);
        ArrayList<LineMark> arrayList = new ArrayList<LineMark>();
        for (int i2 = 0; i2 < lineMarkArray.length; ++i2) {
            if (!lineMarkArray[i2].displayInEditor(editorPane)) continue;
            arrayList.add(lineMarkArray[i2]);
        }
        return arrayList.toArray(new LineMark[arrayList.size()]);
    }

    public LineMark[] getLineMarks(int n2) {
        return this.markList.getMarks(n2);
    }

    public int removeLineMark(LineMark lineMark) {
        lineMark.setDocument(null);
        int n2 = this.markList.removeMark(lineMark);
        if (n2 != -1) {
            this.fireRowsChanged(n2, n2);
        }
        return n2;
    }

    public int setLineMark(int n2, LineMark lineMark, EditorPane editorPane) {
        if (editorPane != null) {
            lineMark.addEditor(editorPane);
        }
        lineMark.setDocument(this);
        int n3 = this.markList.addMark(n2, lineMark);
        if (n3 != -1) {
            this.fireRowsChanged(n3, n3);
        }
        return n3;
    }

    public int setLineMark(int n2, LineMark lineMark) {
        return this.setLineMark(n2, lineMark, null);
    }

    public void removeLightweightLineMarks(LineMark lineMark) {
        lineMark.removeEditor(this);
        this.markList.removeLightweightMark(lineMark);
        Element element = this.getDefaultRootElement();
        this.fireRowsChanged(0, element.getElementCount() - 1);
    }

    public void setLightweightLineMarks(int[] nArray, LineMark lineMark, EditorPane editorPane) {
        if (nArray.length == 0) {
            return;
        }
        if (editorPane != null) {
            lineMark.addEditor(editorPane);
        }
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementCount() - 1;
        int n3 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n4 = this.markList.addMark(nArray[i2], lineMark);
            if (n4 < n2) {
                n2 = n4;
            }
            if (n4 <= n3) continue;
            n3 = n4;
        }
        this.fireRowsChanged(n2, n3);
    }

    public void setLightweightLineMarks(int[] nArray, LineMark lineMark) {
        this.setLightweightLineMarks(nArray, lineMark, null);
    }

    public void changeTabSize(Object object) {
        this.putProperty("tabSize", object);
        int n2 = this.getLength();
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, 0, n2, DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(defaultDocumentEvent);
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        this.reparse(documentEvent);
        super.fireChangedUpdate(documentEvent);
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        Element element = this.getDefaultRootElement();
        int n2 = this.markList.size() - element.getElementCount();
        if (n2 > 0) {
            int n3 = element.getElementIndex(documentEvent.getOffset() + 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.markList.removeLine(n3);
            }
        }
        this.reparse(documentEvent);
        super.fireRemoveUpdate(documentEvent);
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementCount() - this.markList.size();
        if (n2 > 0) {
            int n3 = element.getElementIndex(documentEvent.getOffset());
            Element element2 = element.getElement(n3);
            if (documentEvent.getOffset() > element2.getStartOffset()) {
                ++n3;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                this.markList.insertLine(n3);
            }
        }
        this.reparse(documentEvent);
        super.fireInsertUpdate(documentEvent);
    }

    public void reparse(DocumentEvent documentEvent) {
        try {
            this.scanner.parse(documentEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BasicStyleMap getStyleMap() {
        return this.styleMap;
    }

    public void setStyleMap(BasicStyleMap basicStyleMap) {
        this.styleMap = basicStyleMap;
    }

    public JBUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setScanner(Scanner scanner) {
        this.scanner = scanner;
        try {
            scanner.parse(new AbstractDocument.DefaultDocumentEvent(this, 0, this.getLength(), DocumentEvent.EventType.CHANGE));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public WeakReference getReference() {
        return this.docRef;
    }

    public void fireRowsChanged(int n2, int n3) {
        Element element = this.getDefaultRootElement();
        Element element2 = element.getElement(n2);
        Element element3 = element.getElement(n3);
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, element2.getStartOffset(), element3.getEndOffset() - element2.getStartOffset(), DocumentEvent.EventType.CHANGE);
        super.fireChangedUpdate(defaultDocumentEvent);
    }

    public EditorDocument() {
        super(new GapContent());
        this.undoManager = new JBUndoManager();
        this.markList = new MarkList();
        this.addUndoableEditListener(this.undoManager);
        this.putProperty(I18NProperty, Boolean.FALSE);
        this.putProperty("tabSize", new Integer(2));
        this.docRef = new WeakReference<EditorDocument>(this);
        this.markList.insertLine(0);
    }

    public static class RunInfo {
        public short[] styleData;
        public short[] lengthData;
        int b = 0;
        int d = 0;
        int e = 1024;

        void a(boolean bl) {
            System.err.println("");
            System.err.println("numElements: ".concat(String.valueOf(String.valueOf(this.b))));
            System.err.println("blockLength: ".concat(String.valueOf(String.valueOf(this.d))));
            System.err.println("");
        }

        int b(int n2) {
            try {
                int n3 = 1;
                int n4 = this.lengthData[0];
                while (n4 <= n2) {
                    n4 += this.lengthData[n3];
                    ++n3;
                }
                short s2 = this.styleData[n3 - 1];
                return s2;
            }
            catch (Exception exception) {
                int n5 = 0;
                return n5;
            }
        }

        int a(int n2) {
            try {
                int n3 = this.lengthData[0];
                int n4 = 1;
                while (n3 <= n2) {
                    n3 += this.lengthData[n4];
                    ++n4;
                }
                n4 = n3;
                return n4;
            }
            catch (Exception exception) {
                int n5 = -1;
                return n5;
            }
        }

        void a(int n2, int n3) {
            this.lengthData[this.b] = (short)n2;
            this.styleData[this.b] = (short)n3;
            ++this.b;
            this.d += n2;
        }

        public boolean equals(RunInfo runInfo) {
            if (this.d != runInfo.d || this.b != runInfo.b) {
                return false;
            }
            for (int i2 = 0; i2 < this.b; ++i2) {
                if (this.lengthData[i2] == runInfo.lengthData[i2] && this.styleData[i2] == runInfo.styleData[i2]) continue;
                return false;
            }
            return true;
        }

        RunInfo(RunInfo runInfo) {
            this.d = runInfo.d;
            this.b = runInfo.b;
            this.lengthData = new short[this.b];
            this.styleData = new short[this.b];
            System.arraycopy(runInfo.lengthData, 0, this.lengthData, 0, this.b);
            System.arraycopy(runInfo.styleData, 0, this.styleData, 0, this.b);
        }

        RunInfo() {
            this.lengthData = new short[this.e];
            this.styleData = new short[this.e];
        }
    }

    public class StyledLeafElement
    extends AbstractDocument.LeafElement {
        RunInfo c;
        int b = 0;

        public String toString() {
            return String.valueOf(String.valueOf(new StringBuffer("StyledLeafElement(").append(this.getName()).append(") ").append(this.getStartOffset()).append(",").append(this.getEndOffset()).append("\n")));
        }

        public boolean isWhitespace(int n2) {
            int n3 = this.c == null ? 3 : this.c.b(n2 - this.getStartOffset());
            return n3 == 4;
        }

        public Style getStyle(int n2) {
            int n3 = this.c == null ? 3 : this.c.b(n2 - this.getStartOffset());
            return EditorDocument.this.styleMap.getStyle(n3);
        }

        public int getEndOfRun(int n2) {
            int n3 = this.c == null ? -1 : this.c.a(n2 - this.getStartOffset());
            return n3 != -1 ? this.getStartOffset() + n3 : -1;
        }

        public boolean setRunInfo(RunInfo runInfo) {
            if (this.c != null && runInfo.equals(this.c)) {
                return false;
            }
            this.c = new RunInfo(runInfo);
            return true;
        }

        public boolean isFlagSet(int n2) {
            return (this.b & n2) != 0;
        }

        public void setStateFlags(int n2) {
            this.b = n2;
        }

        public int getStateFlags() {
            return this.b;
        }

        public void getText(Segment segment) {
            try {
                this.getDocument().getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), segment);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }

        public String getText() {
            try {
                String string = this.getDocument().getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
                return string;
            }
            catch (BadLocationException badLocationException) {
                String string = null;
                return string;
            }
        }

        public StyledLeafElement(Element element, AttributeSet attributeSet, int n2, int n3) {
            super(EditorDocument.this, element, attributeSet, n2, n3);
        }
    }

    protected class MarkChain {
        private LineMark[] a;

        public boolean contains(LineMark lineMark) {
            return this.indexOf(lineMark) != -1;
        }

        public int indexOf(LineMark lineMark) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                if (!this.a[i2].equals(lineMark)) continue;
                return i2;
            }
            return -1;
        }

        public void removeMark(LineMark lineMark) {
            int n2 = this.indexOf(lineMark);
            if (n2 != -1) {
                LineMark[] lineMarkArray = new LineMark[this.a.length - 1];
                if (n2 > 0) {
                    System.arraycopy(this.a, 0, lineMarkArray, 0, n2);
                }
                if (n2 < this.a.length - 1) {
                    System.arraycopy(this.a, n2 + 1, lineMarkArray, n2, this.a.length - n2 - 1);
                }
                this.a = lineMarkArray;
            }
        }

        public void addMark(LineMark lineMark) {
            LineMark[] lineMarkArray = new LineMark[this.a.length + 1];
            System.arraycopy(this.a, 0, lineMarkArray, 0, this.a.length);
            lineMarkArray[this.a.length] = lineMark;
            this.a = lineMarkArray;
        }

        public LineMark[] getMarks() {
            return this.a;
        }

        public int size() {
            return this.a.length;
        }

        public MarkChain(EditorDocument editorDocument, LineMark lineMark, LineMark lineMark2) {
            this.a = new LineMark[]{lineMark, lineMark2};
        }
    }

    protected class MarkList {
        ArrayList b = new ArrayList();

        public boolean contains(LineMark lineMark) {
            return this.indexOf(lineMark) != -1;
        }

        public int indexOf(LineMark lineMark) {
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                MarkChain markChain;
                Object e2 = this.b.get(i2);
                if (e2.equals(lineMark)) {
                    return i2;
                }
                if (!(e2 instanceof MarkChain) || !(markChain = (MarkChain)e2).contains(lineMark)) continue;
                return i2;
            }
            return -1;
        }

        public void removeLightweightMark(LineMark lineMark) {
            block0: for (int i2 = 0; i2 < this.b.size(); ++i2) {
                Object e2 = this.b.get(i2);
                if (e2.equals(lineMark)) {
                    this.b.set(i2, EditorDocument.NOMARK);
                    continue;
                }
                if (!(e2 instanceof MarkChain)) continue;
                MarkChain markChain = (MarkChain)e2;
                while (markChain.contains(lineMark)) {
                    if (markChain.size() > 1) {
                        markChain.removeMark(lineMark);
                        continue;
                    }
                    this.b.set(i2, EditorDocument.NOMARK);
                    continue block0;
                }
            }
        }

        public int removeMark(LineMark lineMark) {
            int n2 = this.indexOf(lineMark);
            if (n2 != -1) {
                Object e2 = this.b.get(n2);
                if (e2.equals(lineMark)) {
                    this.b.set(n2, EditorDocument.NOMARK);
                } else if (e2 instanceof MarkChain) {
                    MarkChain markChain = (MarkChain)e2;
                    if (markChain.size() > 1) {
                        markChain.removeMark(lineMark);
                    } else {
                        this.b.set(n2, EditorDocument.NOMARK);
                    }
                }
            }
            return n2;
        }

        public int addMark(int n2, LineMark lineMark) {
            Object e2 = this.b.get(n2);
            if (e2.equals(EditorDocument.NOMARK)) {
                this.b.set(n2, lineMark);
            } else if (e2 instanceof MarkChain) {
                MarkChain markChain = (MarkChain)e2;
                markChain.addMark(lineMark);
            } else {
                MarkChain markChain = new MarkChain(EditorDocument.this, (LineMark)e2, lineMark);
                this.b.set(n2, markChain);
            }
            return n2;
        }

        public void insertLine(int n2) {
            this.b.add(n2, EditorDocument.NOMARK);
        }

        public void removeLine(int n2) {
            this.b.remove(n2);
        }

        public LineMark[] getMarks(int n2) {
            if (n2 >= this.b.size()) {
                return EMPTY_MARKLIST;
            }
            Object e2 = this.b.get(n2);
            if (e2.equals(EditorDocument.NOMARK)) {
                return EMPTY_MARKLIST;
            }
            if (e2 instanceof MarkChain) {
                MarkChain markChain = (MarkChain)e2;
                return markChain.getMarks();
            }
            return new LineMark[]{(LineMark)e2};
        }

        public int size() {
            return this.b.size();
        }

        protected MarkList() {
        }
    }
}

