/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.Scanner;
import java.util.HashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public abstract class AbstractScanner
implements Scanner {
    protected int endIndex;
    protected int startIndex;
    protected EditorDocument currentDocument;
    protected int currentIndex;
    protected char ch;
    protected int bp;
    protected char[] buf;
    protected int stateFlags;
    public static final int IN_JAVA_DOC = 2;
    public static final int IN_COMMENT = 1;
    public static final int NORMAL = 0;
    public static final char EOF = '\u0000';

    static {
        EOF = '\u0000';
        NORMAL = 0;
        IN_COMMENT = 1;
        IN_JAVA_DOC = 2;
    }

    protected int checkSymbol(int n2) {
        if (this.isSymbol(this.ch)) {
            this.ch = this.buf[++this.bp];
            while (this.isSymbol(this.ch) && this.ch != '/') {
                this.ch = this.buf[++this.bp];
            }
            return 8;
        }
        return -1;
    }

    protected int checkString(int n2) {
        if (this.ch == '\"') {
            this.ch = this.buf[++this.bp];
            while (this.ch != '\"' && this.ch != '\n' && this.ch != '\u0000') {
                if (this.ch == '\\') {
                    this.ch = this.buf[++this.bp];
                }
                this.ch = this.buf[++this.bp];
            }
            if (this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            return 9;
        }
        if (this.ch == '\'') {
            this.ch = this.buf[++this.bp];
            while (this.ch != '\'' && this.ch != '\n' && this.ch != '\u0000') {
                if (this.ch == '\\') {
                    this.ch = this.buf[++this.bp];
                }
                this.ch = this.buf[++this.bp];
            }
            if (this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            return 9;
        }
        return -1;
    }

    protected int checkNumber(int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (this.ch) {
            case '0': {
                this.ch = this.buf[++this.bp];
                if (this.ch != 'x' && this.ch != 'X') break;
                bl = true;
                this.ch = this.buf[++this.bp];
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.ch = this.buf[++this.bp];
                break;
            }
            default: {
                return -1;
            }
        }
        block12: while (true) {
            switch (this.ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.ch = this.buf[++this.bp];
                    continue block12;
                }
                case 'E': 
                case 'e': {
                    if (bl) {
                        this.ch = this.buf[++this.bp];
                        continue block12;
                    }
                    if (bl3) {
                        return 10;
                    }
                    this.ch = this.buf[++this.bp];
                    if (this.ch != '+' && this.ch != '-') continue block12;
                    this.ch = this.buf[++this.bp];
                    continue block12;
                }
                case 'D': 
                case 'F': 
                case 'd': 
                case 'f': {
                    this.ch = this.buf[++this.bp];
                    if (bl) continue block12;
                    return 10;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'a': 
                case 'b': 
                case 'c': {
                    if (!bl) {
                        return 10;
                    }
                    this.ch = this.buf[++this.bp];
                    continue block12;
                }
                case '.': {
                    if (bl || bl2 || bl3) {
                        return 10;
                    }
                    bl2 = true;
                    this.ch = this.buf[++this.bp];
                    continue block12;
                }
                case 'L': 
                case 'l': {
                    this.ch = this.buf[++this.bp];
                    return 10;
                }
            }
            if (!Character.isDigit(this.ch)) break;
            this.ch = this.buf[++this.bp];
        }
        return 10;
    }

    protected int checkIdentifier(int n2) {
        if (this.isValidIdentifierStart(this.ch) && this.ch != '\u0000') {
            int n3 = this.bp++;
            this.ch = this.buf[this.bp];
            while (this.isValidIdentifierPart(this.ch) && this.ch != '\u0000') {
                this.ch = this.buf[++this.bp];
            }
            String string = new String(this.buf, n3, this.bp - n3);
            if (this.isKeyword(string)) {
                return 6;
            }
            if (this.isExtendedKeyword(string)) {
                return 11;
            }
            return 7;
        }
        return -1;
    }

    protected int checkComment(int n2) {
        if ((n2 & 1) != 0) {
            while (true) {
                if (this.ch != '*' && this.ch != '\u0000') {
                    this.ch = this.buf[++this.bp];
                    continue;
                }
                while (this.ch == '*') {
                    this.ch = this.buf[++this.bp];
                }
                if (this.ch == '/' || this.ch == '\u0000') break;
            }
            if (this.ch == '\u0000') {
                return 5;
            }
            this.ch = this.buf[++this.bp];
            this.stateFlags &= 0xFFFFFFFE;
            return 5;
        }
        if (this.ch == '/') {
            this.ch = this.buf[++this.bp];
            if (this.ch == '/') {
                this.ch = this.buf[++this.bp];
                while (this.ch != '\n' && this.ch != '\u0000') {
                    this.ch = this.buf[++this.bp];
                }
                return 5;
            }
            if (this.ch == '*') {
                while (true) {
                    this.ch = this.buf[++this.bp];
                    if (this.ch != '*' && this.ch != '\u0000') continue;
                    while (this.ch == '*') {
                        this.ch = this.buf[++this.bp];
                    }
                    if (this.ch == '/' || this.ch == '\u0000') break;
                }
                if (this.ch != '\u0000') {
                    this.ch = this.buf[++this.bp];
                    return 5;
                }
                this.stateFlags |= 1;
                return 5;
            }
            this.ch = this.buf[--this.bp];
        }
        return -1;
    }

    protected int checkWhitespace(int n2) {
        if (this.ch == ' ' || this.ch == '\t' || this.ch == '\r' || this.ch == '\n') {
            this.ch = this.buf[++this.bp];
            while (this.ch == ' ' || this.ch == '\t' || this.ch == '\r' || this.ch == '\n') {
                this.ch = this.buf[++this.bp];
            }
            return 4;
        }
        return -1;
    }

    protected boolean isSymbol(char c2) {
        switch (c2) {
            case '!': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidIdentifierPart(char c2) {
        switch (c2) {
            case '$': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return true;
            }
            case ' ': 
            case '(': 
            case '.': {
                return false;
            }
        }
        return Character.isJavaIdentifierPart(c2);
    }

    protected boolean isValidIdentifierStart(char c2) {
        switch (c2) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return true;
            }
        }
        return Character.isJavaIdentifierStart(c2);
    }

    protected abstract boolean isExtendedKeyword(String var1);

    protected abstract boolean isKeyword(String var1);

    protected int nextToken(int n2) {
        int n3 = -1;
        n3 = this.checkComment(n2);
        if (n3 != -1) {
            return n3;
        }
        n3 = this.checkWhitespace(n2);
        if (n3 != -1) {
            return n3;
        }
        n3 = this.checkIdentifier(n2);
        if (n3 != -1) {
            return n3;
        }
        n3 = this.checkNumber(n2);
        if (n3 != -1) {
            return n3;
        }
        n3 = this.checkString(n2);
        if (n3 != -1) {
            return n3;
        }
        n3 = this.checkSymbol(n2);
        if (n3 != -1) {
            return n3;
        }
        if (this.ch == '\u0000') {
            return -1;
        }
        this.ch = this.buf[++this.bp];
        return 12;
    }

    protected void initialize(Segment segment, Segment segment2) {
        int n2 = segment.count + segment2.count;
        this.buf = new char[n2 + 1];
        System.arraycopy(segment.array, segment.offset, this.buf, 0, segment.count);
        System.arraycopy(segment2.array, segment2.offset, this.buf, segment.count, segment2.count);
        this.buf[n2] = '\u0000';
        this.ch = this.buf[0];
        this.bp = 0;
    }

    protected void initialize(Segment segment) {
        int n2 = segment.count;
        this.buf = new char[n2 + 1];
        System.arraycopy(segment.array, segment.offset, this.buf, 0, n2);
        this.buf[n2] = '\u0000';
        this.ch = this.buf[0];
        this.bp = 0;
    }

    protected boolean scanLine(EditorDocument.StyledLeafElement styledLeafElement, EditorDocument.StyledLeafElement styledLeafElement2, int n2) {
        EditorDocument.RunInfo runInfo = new EditorDocument.RunInfo();
        Segment segment = new Segment();
        styledLeafElement.getText(segment);
        Segment segment2 = new Segment();
        styledLeafElement2.getText(segment2);
        this.initialize(segment, segment2);
        int n3 = segment.count;
        while (true) {
            int n4 = this.bp;
            int n5 = this.nextToken(this.stateFlags);
            if (n5 == -1 || n4 == this.bp) break;
            if (n3 == -1 || this.bp < n3) {
                runInfo.a(this.bp - n4, n5);
                continue;
            }
            runInfo.a(n3 - n4, n5);
            styledLeafElement.setStateFlags(this.stateFlags);
            styledLeafElement.setRunInfo(runInfo);
            runInfo = new EditorDocument.RunInfo();
            if (this.bp > n3) {
                runInfo.a(this.bp - n3, n5);
            }
            n3 = -1;
        }
        if (n3 != -1) {
            styledLeafElement.setStateFlags(this.stateFlags);
            styledLeafElement.setRunInfo(runInfo);
            runInfo = new EditorDocument.RunInfo();
        }
        styledLeafElement2.setStateFlags(this.stateFlags);
        return styledLeafElement2.setRunInfo(runInfo);
    }

    protected boolean scanLine(EditorDocument.StyledLeafElement styledLeafElement, int n2) {
        EditorDocument.RunInfo runInfo = new EditorDocument.RunInfo();
        Segment segment = new Segment();
        styledLeafElement.getText(segment);
        this.initialize(segment);
        while (true) {
            int n3 = this.bp;
            int n4 = this.nextToken(this.stateFlags);
            if (n4 == -1 || n3 == this.bp) break;
            runInfo.a(this.bp - n3, n4);
        }
        styledLeafElement.setStateFlags(this.stateFlags);
        return styledLeafElement.setRunInfo(runInfo);
    }

    public void parse(DocumentEvent documentEvent) {
        Element element;
        this.currentDocument = (EditorDocument)documentEvent.getDocument();
        int n2 = documentEvent.getOffset();
        int n3 = documentEvent.getLength();
        Element element2 = this.currentDocument.getDefaultRootElement();
        this.startIndex = element2.getElementIndex(n2);
        this.endIndex = element2.getElementIndex(n2 + n3);
        Element element3 = element2.getElement(this.startIndex);
        if (this.startIndex > 0 && n2 == element3.getStartOffset()) {
            --this.startIndex;
        }
        this.stateFlags = 0;
        if (this.startIndex > 0) {
            element = (EditorDocument.StyledLeafElement)element2.getElement(this.startIndex - 1);
            this.stateFlags = ((EditorDocument.StyledLeafElement)element).getStateFlags();
        }
        this.currentIndex = this.startIndex;
        while (this.currentIndex < element2.getElementCount()) {
            element = element2.getElement(this.currentIndex);
            EditorDocument.StyledLeafElement styledLeafElement = null;
            EditorDocument.StyledLeafElement styledLeafElement2 = null;
            if (element.isLeaf()) {
                styledLeafElement = (EditorDocument.StyledLeafElement)element;
            } else if (element.getElementCount() == 2) {
                styledLeafElement = (EditorDocument.StyledLeafElement)element.getElement(1);
            } else {
                styledLeafElement = (EditorDocument.StyledLeafElement)element.getElement(0);
                styledLeafElement2 = (EditorDocument.StyledLeafElement)element.getElement(2);
            }
            boolean bl = false;
            bl = styledLeafElement2 == null ? this.scanLine(styledLeafElement, this.stateFlags) : this.scanLine(styledLeafElement, styledLeafElement2, this.stateFlags);
            if (!bl && this.currentIndex > this.endIndex) break;
            ++this.currentIndex;
        }
        this.currentDocument.fireRowsChanged(this.startIndex, this.currentIndex - 1);
        this.currentDocument = null;
    }

    protected static int initMap(HashMap hashMap, String[] stringArray, boolean bl) {
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = bl ? stringArray[i2] : stringArray[i2].toUpperCase();
            hashMap.put(string, string);
            if (string.length() <= n2) continue;
            n2 = string.length();
        }
        return n2;
    }
}

