/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.unittest.utils;

import com.borland.jbuilder.build.JavaBuildPropertyGroup;
import com.borland.jbuilder.java.JavaNames;
import com.borland.jbuilder.java.SourceInfo;
import com.borland.jbuilder.node.AutomaticPackages;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.paths.ProjectPathSet;
import com.borland.jbuilder.wizard.common.ProjectUtil;
import com.borland.jbuilder.wizard.jbx.BasicClassWizard;
import com.borland.jbuilder.wizard.newproject.ProjectWizard;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.wizard.WizardDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class UnitTestUtil {
    private static final String[] a = new String[]{"TestCase", "TestSuite"};

    public static JBProject getProject() {
        Project project = Browser.getActiveBrowser().getActiveProject();
        if (project == null || !(project instanceof JBProject)) {
            WizardDialog wizardDialog = new WizardDialog(Browser.getActiveBrowser(), new ProjectWizard());
            wizardDialog.show();
            project = Browser.getActiveBrowser().getProjectView().getActiveUserProject();
        }
        return (JBProject)project;
    }

    public String removeCharacter(String string, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2++] == c2) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String genClassName(String string, String string2) {
        ProjectPathSet projectPathSet;
        Url url;
        String string3;
        String string4;
        File file;
        String string5;
        Browser browser = Browser.getActiveBrowser();
        JBProject jBProject = (JBProject)browser.getActiveProject();
        if (jBProject == null) {
            return "";
        }
        int n2 = 1;
        while (BasicClassWizard.nodeExists(jBProject, string, string5 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(n2).append(".java")))) || (file = new File(string4 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string3 = (url = (projectPathSet = jBProject.getPaths()).getTestPath()).getFile()))).append(File.separator).append(string.replace('.', File.separatorChar)).append(File.separator).append(string5))))).exists()) {
            ++n2;
        }
        return String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(n2)));
    }

    public static void createTestNode(JBProject jBProject, String string, String string2) {
        if (AutomaticPackages.isAutoPackagesEnabled(jBProject)) {
            return;
        }
        Url url = new Url(new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(UnitTestUtil.getTestPathString(jBProject)))).append('/').append(string.replace('.', '/')).append('/').append(string2).append(".java")))));
        FileNode fileNode = jBProject.getNode(url);
        Node node = ProjectUtil.getSuggestedParent(jBProject, string);
        fileNode.setParent(node);
    }

    public static String getTestPathString(JBProject jBProject) {
        ProjectPathSet projectPathSet = jBProject.getPaths();
        Url url = projectPathSet.getTestPath();
        return url.getFile();
    }

    public static int getMethodLineNumber(String string, String string2) {
        Browser browser = Browser.getActiveBrowser();
        JBProject jBProject = (JBProject)browser.getActiveProject();
        Url url = jBProject.findSourcePathUrl(String.valueOf(String.valueOf(string.replace('.', '/'))).concat(".java"));
        if (url == null) {
            return -1;
        }
        Object object = SourceInfo.lock;
        synchronized (object) {
            try {
                SourceInfo sourceInfo = new SourceInfo(url);
                SourceInfo.Class clazz = sourceInfo.lookupClass(string);
                SourceInfo.Method method = clazz.lookupMethod(string2, new String[0]);
                int n2 = method.getLine();
                return n2;
            }
            catch (Exception exception) {
                int n3 = -1;
                return n3;
            }
        }
    }

    public static String[] getAllTestClass(JavaFileNode javaFileNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = SourceInfo.lock;
        synchronized (object) {
            try {
                SourceInfo sourceInfo = new SourceInfo(javaFileNode.getUrl(), javaFileNode.getEncoding());
                sourceInfo.setSourceVersion(JavaBuildPropertyGroup.SOURCE_VERSION.getValue(javaFileNode.getProject()));
                SourceInfo.Class[] classArray = sourceInfo.getClasses();
                for (int i2 = 0; i2 < classArray.length; ++i2) {
                    if (!UnitTestUtil.b(classArray[i2]) && !UnitTestUtil.a(classArray[i2])) continue;
                    arrayList.add(classArray[i2].getName());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getFirstTestClass(JavaFileNode javaFileNode) {
        Object object = SourceInfo.lock;
        synchronized (object) {
            try {
                SourceInfo sourceInfo = new SourceInfo(javaFileNode.getUrl(), javaFileNode.getEncoding());
                sourceInfo.setSourceVersion(JavaBuildPropertyGroup.SOURCE_VERSION.getValue(javaFileNode.getProject()));
                SourceInfo.Class[] classArray = sourceInfo.getClasses();
                for (int i2 = 0; i2 < classArray.length; ++i2) {
                    if (!UnitTestUtil.b(classArray[i2]) && !UnitTestUtil.a(classArray[i2])) continue;
                    String string = classArray[i2].getName();
                    return string;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean a(SourceInfo.Class clazz) {
        SourceInfo.Method[] methodArray = clazz.getMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            SourceInfo.Method method = methodArray[i2];
            if (method.getParameterNames().length != 0) continue;
            if ("void".equals(method.getReturnType())) {
                String string = method.getName();
                if (method.getVisibility() != 1 || !"runTest".equals(string) && !string.startsWith("test")) continue;
                return true;
            }
            if (!"suite".equals(method.getName()) || !"Test".equals(method.getReturnType()) || !method.isStatic() || method.getVisibility() != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean b(SourceInfo.Class clazz) {
        return UnitTestUtil.extendsTestClass(clazz.getSuperName());
    }

    public static boolean extendsTestClass(String string) {
        if (string != null) {
            string = JavaNames.getClassName(string);
            for (int i2 = 0; i2 < a.length; ++i2) {
                if (!a[i2].equals(string)) continue;
                return true;
            }
        }
        return false;
    }
}

