/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.unittest;

import com.borland.jbuilder.unittest.Res;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;

public class JBTestRunner
extends BaseTestRunner {
    private boolean briefFailures = false;
    private PrintStream writer = System.out;
    private final String STARTING_INDENT = "  ";
    static Class class$java$lang$String;

    public JBTestRunner() {
    }

    public JBTestRunner(PrintStream writer) {
        this();
        if (writer != null) {
            // empty if block
        }
    }

    public void writeHierarchy(String[] args) {
        try {
            this.writer.println("<testhierarchy>");
            int i2 = 0;
            while (i2 < args.length) {
                Object retObj;
                Class<?> testClass;
                if (args[i2].startsWith("-")) continue;
                try {
                    testClass = Class.forName(args[i2]);
                }
                catch (Exception e2) {
                    System.err.println(Res.getString(1));
                    return;
                }
                boolean foundConstructor = true;
                Class[] partypes = null;
                Object[] arglist = null;
                Constructor<?> ct = null;
                try {
                    partypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JBTestRunner.class$("java.lang.String")) : class$java$lang$String};
                    ct = testClass.getConstructor(partypes);
                    arglist = new Object[]{args[i2]};
                }
                catch (Exception e3) {
                    foundConstructor = false;
                }
                if (!foundConstructor) {
                    partypes = new Class[]{};
                    ct = testClass.getConstructor(partypes);
                    arglist = new Object[]{};
                }
                if ((retObj = ct.newInstance(arglist)) instanceof Test) {
                    this.recurseTestCases("  ", (Test)retObj, args[i2]);
                    break;
                }
                Class[] noArg = new Class[]{};
                Method suiteMeth = null;
                try {
                    suiteMeth = retObj.getClass().getMethod("suite", noArg);
                    if (suiteMeth == null) {
                        this.writer.println(String.valueOf(String.valueOf(new StringBuffer("<problem>").append(Res.getString(2)).append("</problem>"))));
                    } else {
                        Object[] noParams = new Object[0];
                        Object t2 = suiteMeth.invoke(retObj, noParams);
                        if (t2 != null && t2 instanceof Test) {
                            this.recurseTestCases("  ", (Test)t2, args[i2]);
                        }
                    }
                }
                catch (Exception e4) {
                    this.writer.println(String.valueOf(String.valueOf(new StringBuffer("<problem>").append(e4.toString()).append("</problem>"))));
                }
                break;
            }
        }
        catch (Exception e5) {
            this.writer.println(String.valueOf(String.valueOf(new StringBuffer("<problem>").append(e5.toString()).append("</problem>"))));
        }
        this.writer.println("</testhierarchy>");
        this.writer.flush();
    }

    private void listMethods(String indent, Test su) {
        Method[] allMethods = su.getClass().getMethods();
        String className = su.getClass().getName();
        for (int i2 = 0; i2 < allMethods.length; ++i2) {
            String methName = allMethods[i2].getName();
            if (!methName.startsWith("test")) continue;
            this.writer.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(indent))).append("  <testcase name=\"").append(methName).append("(").append(className).append(")\"/>"))));
        }
    }

    private void recurseTestCases(String indent, Test su, String name) {
        boolean doSuite = false;
        if (su instanceof TestSuite) {
            if (((TestSuite)su).testCount() == 0) {
                doSuite = true;
            } else {
                this.writer.print(String.valueOf(String.valueOf(indent)).concat("<testsuite name=\""));
                if (name != null) {
                    this.writer.print(name);
                } else {
                    this.writer.print(((TestSuite)su).toString());
                }
                this.writer.println("\">");
                Enumeration e2 = ((TestSuite)su).tests();
                while (e2.hasMoreElements()) {
                    this.recurseTestCases(String.valueOf(String.valueOf(indent)).concat("  "), (Test)e2.nextElement(), null);
                }
                this.writer.println(String.valueOf(String.valueOf(indent)).concat("</testsuite>"));
            }
        }
        if (doSuite || su instanceof TestCase) {
            try {
                Class[] noArg = new Class[]{};
                Method suiteMeth = null;
                try {
                    suiteMeth = su.getClass().getMethod("suite", noArg);
                }
                catch (Exception e3) {
                    suiteMeth = null;
                }
                if (suiteMeth != null) {
                    Object[] noParams = new Object[0];
                    Test t2 = (Test)suiteMeth.invoke((Object)su, noParams);
                    if (t2 != null) {
                        if (t2 instanceof TestSuite) {
                            Enumeration e4 = ((TestSuite)t2).tests();
                            if (!e4.hasMoreElements()) {
                                return;
                            }
                            Test t22 = (Test)e4.nextElement();
                            if (t22.getClass().equals(su.getClass())) {
                                this.writer.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(indent))).append("<testsuite name=\"").append(su.toString()).append("\">"))));
                                this.listMethods(indent, su);
                                this.writer.println(String.valueOf(String.valueOf(indent)).concat("</testsuite>"));
                                return;
                            }
                        }
                        this.recurseTestCases(String.valueOf(String.valueOf(indent)).concat("  "), t2, name);
                    }
                    return;
                }
                if (indent.equals("  ")) {
                    this.writer.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(indent))).append("<testsuite name=\"").append(su.toString()).append("\">"))));
                    this.listMethods(indent, su);
                    this.writer.println(String.valueOf(String.valueOf(indent)).concat("</testsuite>"));
                } else {
                    String str = su.toString();
                    if (str.indexOf("warning(junit.framework") == -1) {
                        this.writer.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(indent))).append("<testcase name=\"").append(str).append("\"/>"))));
                    }
                }
            }
            catch (Exception e5) {
                System.err.println(e5);
            }
        } else {
            this.writer.println("***");
        }
    }

    private void throwableToXml(Throwable t2) {
        this.writer.println("<stacktrace><![CDATA[");
        t2.printStackTrace(this.writer);
        this.writer.println("]]></stacktrace>");
        this.writer.println("<message><![CDATA[");
        this.writer.println(t2.getMessage());
        this.writer.println("]]></message>");
    }

    public synchronized void addError(Test test2, Throwable t2) {
        this.writer.flush();
        if (this.briefFailures) {
            this.writer.println("<error/>");
        } else {
            this.writer.println("<error>");
            this.throwableToXml(t2);
            this.writer.println("</error>");
        }
        this.writer.flush();
    }

    public synchronized void addFailure(Test test2, AssertionFailedError t2) {
        this.writer.flush();
        if (this.briefFailures) {
            this.writer.println("<failure/>");
        } else {
            this.writer.println("<failure>");
            this.throwableToXml((Throwable)t2);
            this.writer.println("</failure>");
        }
        this.writer.flush();
    }

    public TestSuiteLoader getLoader() {
        return new StandardTestSuiteLoader();
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    public TestResult doRun(Test suite, boolean wait) {
        TestResult result = this.createTestResult();
        result.addListener((TestListener)this);
        long startTime = System.currentTimeMillis();
        this.writer.flush();
        suite.run(result);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        return result;
    }

    public synchronized void startTest(Test p0) {
        if (p0 instanceof TestCase) {
            this.writer.println(String.valueOf(String.valueOf(new StringBuffer("<testcase name=\"").append(((TestCase)p0).toString()).append("\">"))));
        } else {
            this.writer.println(String.valueOf(String.valueOf(new StringBuffer("<testcase type=\"other\" name=\"").append(p0.getClass().getName()).append("\">"))));
        }
        this.writer.flush();
    }

    public void endTest(Test p0) {
        System.err.flush();
        System.out.flush();
        this.writer.println("</testcase>");
        this.writer.flush();
    }

    public static void main(String[] args) {
        JBTestRunner runner = new JBTestRunner();
        if (args.length < 1) {
            runner.writer.println(String.valueOf(String.valueOf(new StringBuffer("<problem>").append(Res.getString(3)).append("<problem>"))));
            return;
        }
        try {
            runner.writer.println("<?xml version=\"1.0\"?>");
            runner.writer.println("<testrun>");
            runner.writeHierarchy(args);
            runner.writer.flush();
            TestResult r2 = runner.start(args);
            runner.writer.flush();
            runner.writer.println("</testrun>");
            System.exit(0);
        }
        catch (Exception e2) {
            runner.writer.println(String.valueOf(String.valueOf(new StringBuffer("<problem>").append(e2.getMessage()).append("</problem>"))));
        }
    }

    public static void run(Test suite) {
        JBTestRunner runner = new JBTestRunner();
        runner.doRun(suite, false);
    }

    protected TestResult start(String[] args) throws Exception {
        try {
            this.writer.println(String.valueOf(String.valueOf(new StringBuffer("<testresults date=\"").append(new Date()).append("\">"))));
            this.writer.println(String.valueOf(String.valueOf(new StringBuffer("<testsuite name=\"").append(args[0]).append("\">"))));
            TestResult ret = this.doRun(this.getTest(args[0]), false);
            this.writer.println("</testsuite>");
            this.writer.println("</testresults>");
            TestResult testResult = ret;
            return testResult;
        }
        catch (Exception e2) {
            this.writer.println(String.valueOf(String.valueOf(new StringBuffer("<problem>").append(e2).append("</problem>"))));
            return null;
        }
    }

    protected void runFailed(String message) {
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("<problem>").append(message).append("</problem>"))));
        System.exit(-1);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

