/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.java;

import com.borland.compiler.interfaces.Storage;
import com.borland.compiler.util.Host;
import com.borland.jbuilder.java.c;
import com.borland.primetime.util.Streams;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.FileFilesystem;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UrlStorage
implements Storage {
    private Buffer e;
    private OutputStream c = null;
    private InputStream d = null;
    private Url a;
    static final char b = File.separatorChar;

    public void close() {
        try {
            if (this.d != null) {
                this.d.close();
                this.d = null;
            }
            if (this.c != null) {
                this.c.close();
                this.c = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Storage createDir(String string) throws IOException {
        Url url = this.a.getRelativeUrl(string.replace(File.separatorChar, '/'));
        return new UrlStorage(url);
    }

    public Storage create(String string) throws IOException {
        try {
            Url url = this.a.getRelativeUrl(string.replace(File.separatorChar, '/'));
            OutputStream outputStream = VFS.getOutputStream(url);
            UrlStorage urlStorage = new UrlStorage(url, null, outputStream, null);
            return urlStorage;
        }
        catch (IOException iOException) {
            Storage storage = null;
            return storage;
        }
    }

    public String toString() {
        if (this.a.getFilesystem() == FileFilesystem.FILESYSTEM) {
            return this.a.getFileObject().toString();
        }
        return this.a.toString();
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof UrlStorage) {
            return this.a.equals(((UrlStorage)object).a);
        }
        return false;
    }

    public Storage openDir(String string) {
        Url url = this.a.getRelativeUrl(string.replace(File.separatorChar, '/'));
        return new UrlStorage(url);
    }

    public Storage open(String string) {
        Url url = this.a.getRelativeUrl(string.replace(File.separatorChar, '/'));
        return new UrlStorage(url);
    }

    public String[] list() throws IOException {
        Url[] urlArray = VFS.getChildren(this.a, 3);
        String[] stringArray = new String[urlArray.length];
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            stringArray[i2] = urlArray[i2].getName().replace('/', File.separatorChar);
        }
        return stringArray;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.d != null) {
            throw new IOException(com.borland.jbuilder.java.c.a(2));
        }
        if (this.c == null) {
            this.c = VFS.getOutputStream(this.a);
        }
        this.c.write(byArray, n2, n3);
        this.close();
    }

    public int read(byte[] byArray) throws IOException {
        int n2;
        if (this.c != null) {
            throw new IOException(com.borland.jbuilder.java.c.a(1));
        }
        if (this.e != null) {
            this.e.check();
            byte[] byArray2 = this.e.getContent();
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length < byArray2.length ? byArray.length : byArray2.length);
            return byArray2.length;
        }
        if (this.d == null) {
            this.d = VFS.getInputStream(this.a);
        }
        int n3 = (n2 = this.d.available()) < byArray.length ? n2 : byArray.length;
        int n4 = this.d.read(byArray, 0, n3);
        this.close();
        if (n4 != n3) {
            throw new IOException(com.borland.jbuilder.java.c.a(0));
        }
        return n2;
    }

    public byte[] read() throws IOException {
        if (this.c != null) {
            throw new IOException(com.borland.jbuilder.java.c.a(1));
        }
        if (this.e != null) {
            this.e.check();
            return this.e.getContent();
        }
        if (this.d == null) {
            this.d = VFS.getInputStream(this.a);
        }
        return Streams.read(this.d);
    }

    public boolean isDirectory() {
        return VFS.isDirectory(this.a);
    }

    public String getParent() {
        Url url = this.a.getParent();
        File file = url.getFileObject();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return url.toString();
    }

    public String getCanonicalPath() {
        return this.getPath();
    }

    public String getPath() {
        File file = this.a.getFileObject();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return this.a.toString();
    }

    public String getName() {
        return this.a.getName();
    }

    public long modDate() {
        long l2 = VFS.getLastModified(this.a);
        return Host.javaTimeToTimeStamp(l2);
    }

    public Url getUrl() {
        return this.a;
    }

    public UrlStorage(Url url) {
        this(url, null, null, null);
    }

    public UrlStorage(Url url, InputStream inputStream, OutputStream outputStream, Buffer buffer) {
        this.a = VFS.getCanonicalUrl(url);
        this.d = inputStream;
        this.c = outputStream;
        this.e = buffer != null ? buffer : VFS.findBuffer(url);
    }
}

