/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.enterprise.ejb.weblogic;

import com.borland.jbuilder.enterprise.EnterpriseUtils;
import com.borland.jbuilder.enterprise.ear.EarGrpUtils;
import com.borland.jbuilder.enterprise.ejb.AppServer;
import com.borland.jbuilder.enterprise.ejb.AppServerManager;
import com.borland.jbuilder.enterprise.ejb.CommandLineDeploySettings;
import com.borland.jbuilder.enterprise.ejb.weblogic.WebLogicAppServer51;
import com.borland.jbuilder.enterprise.ejb.weblogic.WebLogicAppServer60;
import com.borland.jbuilder.enterprise.ejb.weblogic.WebLogicDeployOptionsControls;
import com.borland.jbuilder.enterprise.ejb.weblogic.WebLogicDeployOptionsControls60;
import com.borland.jbuilder.enterprise.ejb.weblogic.WebLogicDeploySettings;
import com.borland.jbuilder.enterprise.ejb.weblogic.WebLogicDeploySettings60;
import com.borland.jbuilder.enterprise.ejb.weblogic.WebLogicEjbDeployer51;
import com.borland.jbuilder.enterprise.ejb.weblogic.WebLogicPropertyGroup;
import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.properties.GlobalProperty;
import com.borland.primetime.properties.MultipleNodeProperty;
import com.borland.primetime.properties.NodeProperty;
import com.borland.primetime.vfs.Url;
import java.util.ArrayList;

public class WebLogicEjbDeployer60
extends WebLogicEjbDeployer51 {
    protected WebLogicDeployOptionsControls createDeployOptionsControls() {
        return new WebLogicDeployOptionsControls60();
    }

    protected GlobalProperty getServerNameGlobalProperty() {
        return WebLogicPropertyGroup.DEPLOY_SERVER_60;
    }

    protected GlobalProperty getPasswordGlobalProperty() {
        return WebLogicPropertyGroup.DEPLOY_PASSWORD_60;
    }

    protected NodeProperty getServerNameNodeProperty() {
        return WebLogicPropertyGroup.DEPLOY_NODE_SERVER_60;
    }

    protected NodeProperty getPasswordNodeProperty() {
        return WebLogicPropertyGroup.DEPLOY_NODE_PASSWORD_60;
    }

    protected NodeProperty getUnitNameNodeProperty() {
        return WebLogicPropertyGroup.DEPLOY_NODE_UNIT_NAME_60;
    }

    protected String getDefaultSystemPassword() {
        String string = WebLogicPropertyGroup.SYSTEM_PASSWORD_60.getValue();
        return string == null ? "" : string;
    }

    protected String getDefaultNodeUnitName(AppServer appServer, FileNode fileNode) {
        FileNode fileNode2 = appServer.getDeployableNode(fileNode);
        return WebLogicDeploySettings.getDeployUnitNameBasedOnUrlName(fileNode2.getUrl());
    }

    protected void saveSettingsForSelectedNode(CommandLineDeploySettings commandLineDeploySettings, FileNode fileNode) {
        super.saveSettingsForSelectedNode(commandLineDeploySettings, fileNode);
        if (!(commandLineDeploySettings instanceof WebLogicDeploySettings60)) {
            return;
        }
        WebLogicDeploySettings60 webLogicDeploySettings60 = (WebLogicDeploySettings60)commandLineDeploySettings;
        this.getServerNameNodeProperty().setValue(fileNode, webLogicDeploySettings60.getDeployServerName());
        AppServer appServer = AppServerManager.getAppServer(fileNode.getProject());
        Node node = appServer.getCompanionNode(fileNode);
        if (node != null) {
            this.getServerNameNodeProperty().setValue(node, webLogicDeploySettings60.getDeployServerName());
        }
    }

    protected void restoreSettingsForSelectedNode(CommandLineDeploySettings commandLineDeploySettings, FileNode fileNode) {
        String string;
        super.restoreSettingsForSelectedNode(commandLineDeploySettings, fileNode);
        if (!(commandLineDeploySettings instanceof WebLogicDeploySettings60)) {
            return;
        }
        WebLogicDeploySettings60 webLogicDeploySettings60 = (WebLogicDeploySettings60)commandLineDeploySettings;
        String string2 = webLogicDeploySettings60.getDeployPassword();
        if (string2 == null || string2.equals("")) {
            string2 = this.getDefaultSystemPassword();
            webLogicDeploySettings60.setDeployPassword(string2);
        }
        if ((string = this.getServerNameNodeProperty().getValue(fileNode)) == null || string.equals("")) {
            string = WebLogicDeploySettings60.DEFAULT_SERVER_NAME;
        }
        webLogicDeploySettings60.setDeployServerName(string);
    }

    protected String getDeployActionOptions(WebLogicDeploySettings webLogicDeploySettings, JBProject jBProject) {
        String string = webLogicDeploySettings.getDeployAction();
        String string2 = webLogicDeploySettings.getDeployJarName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(webLogicDeploySettings.getDeployPassword());
        if (!"list".equals(string)) {
            stringBuffer.append(' ');
            stringBuffer.append(webLogicDeploySettings.getDeployUnitName());
            if ("deploy".equals(string) || "update".equals(string)) {
                stringBuffer.append(' ');
                stringBuffer.append(AppServer.formatJarFileParameter(string2));
            }
        }
        return stringBuffer.toString();
    }

    protected CommandLineDeploySettings getDefaultDeploySettings(JBProject jBProject) {
        CommandLineDeploySettings commandLineDeploySettings = super.getDefaultDeploySettings(jBProject);
        if (!(commandLineDeploySettings instanceof WebLogicDeploySettings60)) {
            return commandLineDeploySettings;
        }
        WebLogicDeploySettings60 webLogicDeploySettings60 = (WebLogicDeploySettings60)commandLineDeploySettings;
        webLogicDeploySettings60.setDeployPassword(this.getDefaultSystemPassword());
        webLogicDeploySettings60.setDeployServerName(WebLogicDeploySettings60.DEFAULT_SERVER_NAME);
        return commandLineDeploySettings;
    }

    protected void addComponentArg(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("-component ");
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        stringBuffer.append(' ');
    }

    protected CommandLineDeploySettings customizeSettingsForDeployCommand(CommandLineDeploySettings commandLineDeploySettings, JBProject jBProject, ArrayList arrayList) {
        WebLogicDeploySettings60 webLogicDeploySettings60 = (WebLogicDeploySettings60)super.customizeSettingsForDeployCommand(commandLineDeploySettings, jBProject, arrayList);
        if (!"list".equals(webLogicDeploySettings60.getDeployAction())) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = webLogicDeploySettings60.getDeployServerName();
            String string2 = webLogicDeploySettings60.getDeployJarName();
            if (string2 != null) {
                if (string2.endsWith(".ear")) {
                    Url[] urlArray = EarGrpUtils.getSelectedArchives(string2, jBProject);
                    if (urlArray != null) {
                        for (int i2 = 0; i2 < urlArray.length; ++i2) {
                            String string3;
                            Url url = urlArray[i2];
                            if (url == null || !"jar".equals(string3 = url.getFileExtension()) && !"war".equals(string3)) continue;
                            String string4 = EnterpriseUtils.getUrlNameNoExtension(url);
                            this.addComponentArg(stringBuffer, string4, string);
                        }
                    }
                } else {
                    this.addComponentArg(stringBuffer, webLogicDeploySettings60.getDeployUnitName(), string);
                }
            }
            stringBuffer.append(webLogicDeploySettings60.getDeployOptions());
            webLogicDeploySettings60.setDeployOptions(stringBuffer.toString());
        }
        return webLogicDeploySettings60;
    }

    protected GlobalProperty getVmParametersGlobalProperty() {
        return WebLogicPropertyGroup.DEPLOY_VM_PARAMETERS_60;
    }

    protected GlobalProperty getOptionsGlobalProperty() {
        return WebLogicPropertyGroup.DEPLOY_OPTIONAL_PARAMETERS_60;
    }

    protected MultipleNodeProperty getVmParametersNodeProperty() {
        return WebLogicPropertyGroup.DEPLOY_NODE_VM_PARAMETERS_60;
    }

    protected MultipleNodeProperty getOptionsNodeProperty() {
        return WebLogicPropertyGroup.DEPLOY_NODE_OPTIONAL_PARAMETERS_60;
    }

    public CommandLineDeploySettings readSettings(Project project) {
        WebLogicDeploySettings60 webLogicDeploySettings60 = new WebLogicDeploySettings60();
        webLogicDeploySettings60.setDeployAction(WebLogicPropertyGroup.DEPLOY_ACTION_60.getValue());
        webLogicDeploySettings60.setDeployPassword(WebLogicPropertyGroup.DEPLOY_PASSWORD_60.getValue());
        webLogicDeploySettings60.setDeployUnitName(WebLogicPropertyGroup.DEPLOY_UNIT_NAME_60.getValue());
        webLogicDeploySettings60.setDeployOptions(WebLogicPropertyGroup.DEPLOY_OPTIONAL_PARAMETERS_60.getValue());
        webLogicDeploySettings60.setDeployVmParameters(WebLogicPropertyGroup.DEPLOY_VM_PARAMETERS_60.getValue());
        webLogicDeploySettings60.setDeployServerName(WebLogicPropertyGroup.DEPLOY_SERVER_60.getValue());
        return webLogicDeploySettings60;
    }

    public void writeSettings(CommandLineDeploySettings commandLineDeploySettings, Project project) {
        if (!(commandLineDeploySettings instanceof WebLogicDeploySettings60)) {
            return;
        }
        WebLogicDeploySettings60 webLogicDeploySettings60 = (WebLogicDeploySettings60)commandLineDeploySettings;
        WebLogicPropertyGroup.DEPLOY_ACTION_60.setValue(webLogicDeploySettings60.getDeployAction());
        WebLogicPropertyGroup.DEPLOY_PASSWORD_60.setValue(webLogicDeploySettings60.getDeployPassword());
        WebLogicPropertyGroup.DEPLOY_UNIT_NAME_60.setValue(webLogicDeploySettings60.getDeployUnitName());
        WebLogicPropertyGroup.DEPLOY_OPTIONAL_PARAMETERS_60.setValue(webLogicDeploySettings60.getDeployOptions());
        WebLogicPropertyGroup.DEPLOY_VM_PARAMETERS_60.setValue(webLogicDeploySettings60.getDeployVmParameters());
        WebLogicPropertyGroup.DEPLOY_SERVER_60.setValue(webLogicDeploySettings60.getDeployServerName());
    }

    protected String getVersionString() {
        return AppServer.makeFullName(WebLogicAppServer51.APP_SERVER_NAME, WebLogicAppServer60.APP_SERVER_VERSION);
    }

    protected CommandLineDeploySettings createDeploySettings() {
        return new WebLogicDeploySettings60();
    }

    public static void initOpenTool(byte by, byte by2) {
        if (JBuilderInfo.isEnterpriseEnabled()) {
            AppServerManager.registerEjbDeployer(new WebLogicEjbDeployer60(), WebLogicAppServer51.APP_SERVER_NAME, WebLogicAppServer60.APP_SERVER_VERSION);
        }
    }
}

