/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.enterprise.ear;

import com.borland.enterprise.module.IModule;
import com.borland.enterprise.xml.api.IEjbJar;
import com.borland.enterprise.xml.api.IRootXmlObject;
import com.borland.enterprise.xml.util.DescriptorPair;
import com.borland.jbuilder.enterprise.AbstractDeploymentDescriptor;
import com.borland.jbuilder.enterprise.ear.EarDeploymentDescriptor;
import com.borland.jbuilder.node.EJBGRPFileNode;
import com.borland.jbuilder.node.EarGrpFileNode;
import com.borland.jbuilder.wizard.ear.EarPropertyGroup;
import com.borland.jbuilder.wizard.ear.EjbModulePropertyGroup;
import com.borland.jbuilder.wizard.ear.WebModulePropertyGroup;
import com.borland.jbuilder.wizard.webapp.WebContextNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class EarGrpUtils {
    public static final String META_INF = "META-INF";
    public static final String IAS_DESCRIPTOR = "application-inprise.xml";
    public static final String GENERIC_DESCRIPTOR = "application.xml";

    static {
        GENERIC_DESCRIPTOR = GENERIC_DESCRIPTOR;
        IAS_DESCRIPTOR = IAS_DESCRIPTOR;
        META_INF = META_INF;
    }

    public static Url[] getSelectedArchives(String string, Project project) {
        Url[] urlArray = null;
        EarGrpFileNode earGrpFileNode = EarGrpUtils.findEarGroup(string, project);
        if (earGrpFileNode != null) {
            urlArray = EarPropertyGroup.getArchives(earGrpFileNode, true);
        }
        return urlArray;
    }

    public static WebContextNode[] getWebContextNodes(String string, Project project) {
        WebContextNode[] webContextNodeArray = null;
        EarGrpFileNode earGrpFileNode = EarGrpUtils.findEarGroup(string, project);
        if (earGrpFileNode != null) {
            webContextNodeArray = WebModulePropertyGroup.getWebContextNodes(earGrpFileNode);
        }
        return webContextNodeArray;
    }

    public static EJBGRPFileNode[] getEjbGroups(String string, Project project) {
        EJBGRPFileNode[] eJBGRPFileNodeArray = null;
        EarGrpFileNode earGrpFileNode = EarGrpUtils.findEarGroup(string, project);
        if (earGrpFileNode != null) {
            eJBGRPFileNodeArray = EjbModulePropertyGroup.getEjbGrpNodes(earGrpFileNode);
        }
        return eJBGRPFileNodeArray;
    }

    public static EarGrpFileNode findEarGroup(String string, Project project) {
        Node[] nodeArray = EarGrpUtils.findGroupFiles(project);
        String string2 = string.replace('\\', '/');
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            Url url;
            Url url2;
            EarGrpFileNode earGrpFileNode = (EarGrpFileNode)nodeArray[i2];
            String string3 = earGrpFileNode.getEarUrl().getFile();
            if (string3 == null || !(url2 = (url = earGrpFileNode.getProject().getUrl().getParent()).getRelativeUrl(string3)).getFile().equals(string2)) continue;
            return earGrpFileNode;
        }
        return null;
    }

    public static Node[] findGroupFiles(Project project) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node[] nodeArray = project.getDisplayChildren();
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            if (!(nodeArray[i2] instanceof EarGrpFileNode)) continue;
            arrayList.add(nodeArray[i2]);
        }
        return arrayList.toArray(Node.EMPTY_ARRAY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EarDeploymentDescriptor createDescriptor(Url url) throws IOException {
        EarDeploymentDescriptor earDeploymentDescriptor;
        InputStream inputStream;
        Object object;
        Closeable closeable;
        FileInputStream fileInputStream = new FileInputStream(url.getFileObject());
        if (url.getProtocol() == "zip") {
            closeable = new CheckedInputStream(fileInputStream, new CRC32());
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream((InputStream)closeable));
            String string = url.getFile();
            int n2 = string.lastIndexOf(93);
            if (n2 > -1 && string.length() > n2 + 1 && (string = string.substring(n2 + 1)).startsWith("/") && string.length() > 1) {
                string = string.substring(1);
            }
            while ((object = zipInputStream.getNextEntry()) != null && !((ZipEntry)object).getName().equals(string)) {
            }
            if (object == null) {
                return null;
            }
            inputStream = zipInputStream;
        } else {
            inputStream = fileInputStream;
        }
        try {
            int n3;
            closeable = new ByteArrayOutputStream();
            while ((n3 = inputStream.read()) != -1) {
                ((ByteArrayOutputStream)closeable).write(n3);
            }
            ((ByteArrayOutputStream)closeable).close();
            object = url.getFile();
            int n4 = ((String)object).lastIndexOf(47);
            if (n4 > 0 && ((String)object).length() > n4 + 1) {
                object = ((String)object).substring(n4 + 1);
            }
            EarDeploymentDescriptor earDeploymentDescriptor2 = new EarDeploymentDescriptor((String)object);
            earDeploymentDescriptor2.setBytes(((ByteArrayOutputStream)closeable).toByteArray());
            earDeploymentDescriptor = earDeploymentDescriptor2;
            Object var10_12 = null;
            if (inputStream == null) return earDeploymentDescriptor;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return earDeploymentDescriptor;
    }

    public static void replaceGroupFile(Url url, byte[] byArray) throws IOException {
        Buffer buffer = VFS.getBuffer(url);
        buffer.setContent(byArray);
    }

    public static byte[] createGroupFileContent(EarDeploymentDescriptor[] earDeploymentDescriptorArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EarGrpUtils.createGroupFile(byteArrayOutputStream, earDeploymentDescriptorArray);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] mergeWithGroupFile(Url url, EarDeploymentDescriptor[] earDeploymentDescriptorArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EarGrpUtils.updateGroupFile(VFS.getInputStream(url), (OutputStream)byteArrayOutputStream, earDeploymentDescriptorArray);
        return byteArrayOutputStream.toByteArray();
    }

    public static void updateGroupFile(Url url, OutputStream outputStream, EarDeploymentDescriptor[] earDeploymentDescriptorArray) throws IOException {
        EarGrpUtils.updateGroupFile(VFS.getInputStream(url), outputStream, earDeploymentDescriptorArray);
    }

    public static void updateGroupFile(InputStream inputStream, OutputStream outputStream, EarDeploymentDescriptor[] earDeploymentDescriptorArray) throws IOException {
        int n2;
        EarDeploymentDescriptor[] earDeploymentDescriptorArray2;
        ArrayList<EarDeploymentDescriptor> arrayList = new ArrayList<EarDeploymentDescriptor>();
        if (inputStream != null && (earDeploymentDescriptorArray2 = EarGrpUtils.extractDescriptors(inputStream)) != null) {
            for (n2 = 0; n2 < earDeploymentDescriptorArray2.length; ++n2) {
                arrayList.add(earDeploymentDescriptorArray2[n2]);
            }
        }
        int n3 = arrayList.size();
        for (n2 = 0; n2 < earDeploymentDescriptorArray.length; ++n2) {
            boolean bl = false;
            for (int i2 = 0; i2 < n3; ++i2) {
                EarDeploymentDescriptor earDeploymentDescriptor = (EarDeploymentDescriptor)arrayList.get(i2);
                if (!earDeploymentDescriptor.getName().equals(earDeploymentDescriptorArray[n2].getName())) continue;
                arrayList.set(i2, earDeploymentDescriptorArray[n2]);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(earDeploymentDescriptorArray[n2]);
        }
        AbstractDeploymentDescriptor[] abstractDeploymentDescriptorArray = arrayList.toArray(new EarDeploymentDescriptor[arrayList.size()]);
        EarGrpFileNode.getGrpAccessor().writeDescriptors(outputStream, abstractDeploymentDescriptorArray);
    }

    public static EarDeploymentDescriptor[] extractDescriptors(Url url) throws IOException {
        return EarGrpUtils.extractDescriptors(VFS.getInputStream(url));
    }

    private static EarDeploymentDescriptor[] a(IModule iModule) {
        ArrayList<EarDeploymentDescriptor> arrayList = new ArrayList<EarDeploymentDescriptor>();
        DescriptorPair descriptorPair = iModule.getDescriptorPair();
        String string = descriptorPair.getStandard().getXmlPath();
        byte[] byArray = iModule.getStandardDescriptorStorage().getBytes();
        arrayList.add(new EarDeploymentDescriptor(string.substring(string.lastIndexOf("/") + 1), System.currentTimeMillis(), byArray));
        String string2 = descriptorPair.getVendor().getXmlPath();
        byArray = iModule.getVendorDescriptorStorage().getBytes();
        if (byArray != null && byArray.length > 0) {
            arrayList.add(new EarDeploymentDescriptor(string2.substring(string2.lastIndexOf("/") + 1), System.currentTimeMillis(), byArray));
        }
        return arrayList.toArray(new EarDeploymentDescriptor[arrayList.size()]);
    }

    public static EarDeploymentDescriptor[] extractDescriptor(IEjbJar iEjbJar) {
        try {
            EarDeploymentDescriptor[] earDeploymentDescriptorArray;
            IModule iModule = iEjbJar.getIModule();
            EarGrpUtils.a(iModule, iEjbJar);
            EarDeploymentDescriptor[] earDeploymentDescriptorArray2 = earDeploymentDescriptorArray = EarGrpUtils.a(iModule);
            return earDeploymentDescriptorArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static EarDeploymentDescriptor[] extractDescriptors(InputStream inputStream) throws IOException {
        return EarGrpFileNode.readDescriptors(inputStream);
    }

    public static EarDeploymentDescriptor getDescriptorByName(EarDeploymentDescriptor[] earDeploymentDescriptorArray, String string) {
        for (int i2 = 0; i2 < earDeploymentDescriptorArray.length; ++i2) {
            if (!string.equals(earDeploymentDescriptorArray[i2].getName())) continue;
            return earDeploymentDescriptorArray[i2];
        }
        return null;
    }

    public static EarDeploymentDescriptor[] getDescriptorsByName(EarDeploymentDescriptor[] earDeploymentDescriptorArray, Collection collection) {
        ArrayList<EarDeploymentDescriptor> arrayList = new ArrayList<EarDeploymentDescriptor>();
        for (int i2 = 0; i2 < earDeploymentDescriptorArray.length; ++i2) {
            if (!collection.contains(earDeploymentDescriptorArray[i2].getName())) continue;
            arrayList.add(earDeploymentDescriptorArray[i2]);
        }
        return arrayList.toArray(new EarDeploymentDescriptor[arrayList.size()]);
    }

    private static void a(IModule iModule, IEjbJar iEjbJar) {
        iModule.setXmlRoot((IRootXmlObject)iEjbJar);
        iModule.save();
    }

    public static void createGroupFile(Url url, EarDeploymentDescriptor[] earDeploymentDescriptorArray) throws IOException {
        OutputStream outputStream;
        Buffer buffer;
        try {
            buffer = VFS.getBuffer(url);
            outputStream = buffer.getOutputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            url.getFileObject().getParentFile().mkdirs();
            buffer = VFS.getBuffer(url);
            outputStream = buffer.getOutputStream();
        }
        EarGrpUtils.createGroupFile(outputStream, earDeploymentDescriptorArray);
        buffer.save(true);
    }

    public static void createGroupFile(OutputStream outputStream, EarDeploymentDescriptor[] earDeploymentDescriptorArray) throws IOException {
        EarGrpUtils.updateGroupFile(null, outputStream, earDeploymentDescriptorArray);
    }
}

