/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.cot.dm.accessors;

import com.borland.jbuilder.cot.CotHintContainer;
import com.borland.jbuilder.cot.dm.accessors.PropertyAccessor;
import com.borland.jbuilder.cot.dm.accessors.PropertyAccessorManager;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ComplexPropertyAccessor
extends PropertyAccessor {
    protected PropertyAccessorManager accessorManager;
    protected PropertyAccessor[] accessors;
    protected PropertyDescriptor[] subproperties;

    public abstract Object getHintValue();

    public void removeHintValue() {
        if (this.accessors != null) {
            int n2 = this.accessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.accessors[i2] == null) continue;
                this.accessors[i2].removeHintValue();
            }
        }
    }

    public void addHintValue(Object object) {
        if (object != null && this.subproperties != null && this.accessors != null) {
            int n2 = this.subproperties.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.accessors[i2] == null) continue;
                try {
                    Object object2 = this.extractSubpropertyValue(this.subproperties[i2], object);
                    if (this.accessors[i2].isDefault(object2)) continue;
                    this.accessors[i2].addHintValue(object2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void resetValue(boolean bl) {
        super.resetValue(bl);
        if (this.accessors != null) {
            int n2 = this.accessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.accessors[i2] == null) continue;
                this.accessors[i2].resetValue(bl);
            }
        }
    }

    protected Object extractSubpropertyValue(PropertyDescriptor propertyDescriptor, Object object) throws InvocationTargetException, IllegalAccessException {
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            return method.invoke(object, new Object[0]);
        }
        return null;
    }

    protected void setLiveValue(Object object) throws InvocationTargetException, IllegalAccessException {
        super.setLiveValue(object);
        if (this.accessors != null) {
            int n2 = this.accessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.accessors[i2] == null) continue;
                if (this.accessors[i2].getLiveInstance() != null) {
                    try {
                        this.accessors[i2].getDefault();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.accessors[i2].setLiveInstance(object);
            }
        }
    }

    protected void setSubpropertyDefaults(Object object) {
        if (this.accessors != null) {
            int n2 = this.accessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.accessors[i2] == null) continue;
                try {
                    this.accessors[i2].setDefault(this.extractSubpropertyValue(this.subproperties[i2], object));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setDefault(Object object) {
        super.setDefault(object);
        if (object != null) {
            this.setSubpropertyDefaults(object);
        }
    }

    public void setHintContainer(CotHintContainer cotHintContainer) {
        super.setHintContainer(cotHintContainer);
        if (this.accessors != null) {
            int n2 = this.accessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.accessors[i2] == null) continue;
                this.accessors[i2].setHintContainer(cotHintContainer);
            }
        }
    }

    public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        super.setPropertyDescriptor(propertyDescriptor);
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(propertyDescriptor.getPropertyType());
            this.subproperties = beanInfo.getPropertyDescriptors();
            int n2 = this.subproperties.length;
            this.accessors = new PropertyAccessor[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.accessors[i2] = this.accessorManager.getAccessor(this.subproperties[i2]);
                if (this.accessors[i2] == null) continue;
                this.accessors[i2].setPropertyDescriptor(this.subproperties[i2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ComplexPropertyAccessor(PropertyAccessorManager propertyAccessorManager) {
        this.accessorManager = propertyAccessorManager;
    }
}

