/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.build;

import com.borland.compiler.symtab.Proj;
import com.borland.jbuilder.build.BuildUtil;
import com.borland.jbuilder.build.ExternalBuildTask;
import com.borland.jbuilder.build.JavaBuildTask;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JspFileNode;
import com.borland.jbuilder.runtime.jsp.JspLineMapping;
import com.borland.jbuilder.runtime.jsp.JspSourceBridge;
import com.borland.primetime.build.BuildProcess;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.node.UrlNode;
import com.borland.primetime.util.GeneratedFile;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JspJavaBuildTask
extends JavaBuildTask {
    public static final Object SHARED_JAVA_BUILD_TASK = new Object();
    protected JspSourcePosition currentSourcePosition;
    protected List jspNodes;
    protected Map jspParentMap = new HashMap();
    protected Url sourceDestinationDir;
    protected String jspJavaOutputPath;
    protected String jspJavaSourcePath;
    protected String jspClassPath;
    protected JspSourceBridge jspSourceBridge;

    protected JavaBuildTask.SourcePosition newSourcePosition() {
        this.currentSourcePosition = new JspSourcePosition(this.jspSourceBridge, this.jspParentMap);
        return this.currentSourcePosition;
    }

    protected void prepareCompileSwitches(Proj proj, Project project) {
        super.prepareCompileSwitches(proj, project);
        proj.encoding = "UTF8";
    }

    protected String prepareOutputPath(JBProject jBProject) {
        File file = new File(this.jspJavaOutputPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return this.jspJavaOutputPath;
    }

    protected String prepareClassPath(JBProject jBProject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.prepareClassPath(jBProject));
        stringBuffer.append(File.pathSeparatorChar);
        stringBuffer.append(this.jspClassPath);
        return stringBuffer.toString();
    }

    protected String prepareSourcePath(JBProject jBProject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.jspJavaSourcePath);
        return stringBuffer.toString();
    }

    public boolean build(BuildProcess buildProcess, Project project, boolean bl) {
        super.build(buildProcess, project, bl);
        this.removeJspJavaFiles((JBProject)project);
        return false;
    }

    protected void removeJspJavaFiles(JBProject jBProject) {
        Node[] nodeArray = new UrlNode[this.jspNodes.size()];
        this.jspNodes.toArray(nodeArray);
        ExternalBuildTask.deleteGeneratedFiles("Jspc", (UrlNode[])nodeArray);
        ExternalBuildTask.informChildrenChanged(nodeArray);
        GeneratedFile.deleteDir(this.jspJavaSourcePath);
        try {
            VFS.delete(BuildUtil.getGeneratedDir(jBProject).getRelativeUrl(".jsp"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void copyJavaSource(Url url) {
        String string = url.getFile().substring(this.jspJavaSourcePath.length() + 1);
        Url url2 = this.sourceDestinationDir.getRelativeUrl(string);
        url2.getFileObject().delete();
        GeneratedFile.copyFile(url, url2);
    }

    public void addBuildSource(Node node, Url url) {
        if (!this.jspNodes.contains(node)) {
            this.jspNodes.add(node);
        }
        Url url2 = ((JspFileNode)node).getUrl();
        this.jspParentMap.put(url, url2);
        if (this.sourceDestinationDir != null) {
            this.copyJavaSource(url);
        }
        this.addBuildSource(url);
    }

    public JspJavaBuildTask(JspSourceBridge jspSourceBridge, String string, String string2, String string3, Url url) {
        this.jspNodes = new ArrayList();
        this.jspSourceBridge = jspSourceBridge;
        this.jspClassPath = string;
        this.jspJavaSourcePath = string2;
        this.jspJavaOutputPath = string3;
        this.sourceDestinationDir = url;
    }

    protected static class JspSourcePosition
    extends JavaBuildTask.SourcePosition {
        protected JspLineMapping jspLineMapping;
        protected Map lineMapMap;
        protected Set jspErrorSet = new HashSet();
        protected Map jspParentMap;
        protected JspSourceBridge jspSourceBridge;

        public Set getJspsWithErrors() {
            return this.jspErrorSet;
        }

        protected void getLineMap(Url url) {
            this.jspLineMapping = (JspLineMapping)this.lineMapMap.get(url);
            if (this.jspLineMapping == null) {
                this.jspLineMapping = this.jspSourceBridge.newJspLineMapping(url, this.url);
                this.jspLineMapping.generate();
                this.lineMapMap.put(url, this.jspLineMapping);
            }
        }

        protected void translatePositionToLineAndColumn(int n2, boolean bl) {
            super.translatePositionToLineAndColumn(n2, bl);
            if (this.url != null && n2 != 0) {
                this.line = this.jspLineMapping.getJspLine(this.line);
                if (this.line == -1) {
                    this.line = -1;
                }
                this.col = -1;
            }
        }

        protected void translateUrl(Url url, boolean bl) {
            if (url == null) {
                super.translateUrl(url, bl);
                return;
            }
            this.url = (Url)this.jspParentMap.get(url);
            if (bl) {
                this.jspErrorSet.add(this.url);
            }
            this.getLineMap(url);
        }

        public JspSourcePosition(JspSourceBridge jspSourceBridge, Map map) {
            this.lineMapMap = new HashMap();
            this.jspSourceBridge = jspSourceBridge;
            this.jspParentMap = map;
        }
    }
}

