/*
 * Decompiled with CFR 0.152.
 */
package com.borland.compiler.util;

import com.borland.compiler.util.a;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Vector {
    protected int capacityIncrement;
    protected int elementCount;
    protected Object[] elementData;

    public final String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        for (int i2 = 0; i2 <= n2; ++i2) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, vector.elementData, 0, this.elementCount);
            Vector vector2 = vector;
            return vector2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final void removeAllElements() {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
    }

    public final boolean removeElement(Object object) {
        int n2 = this.indexOf(object);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final void addElement(Object object) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
    }

    public final void insertElementAt(Object object, int n2) {
        if (n2 >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" >= ").append(this.elementCount).append(1))));
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = object;
        ++this.elementCount;
    }

    public final void removeElementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" >= ").append(this.elementCount))));
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void setElementAt(Object object, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" >= ").append(this.elementCount))));
        }
        this.elementData[n2] = object;
    }

    public final Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final Object elementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" >= ").append(this.elementCount))));
        }
        try {
            Object object = this.elementData[n2];
            return object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(n2)).concat(" < 0"));
        }
    }

    public final int lastIndexOf(Object object, int n2) {
        int n3 = n2;
        while (--n3 >= 0) {
            if (!object.equals(this.elementData[n3])) continue;
            return n3;
        }
        return -1;
    }

    public final int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount);
    }

    public final int indexOf(Object object, int n2) {
        for (int i2 = n2; i2 < this.elementCount; ++i2) {
            if (!object.equals(this.elementData[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public final Enumeration elements() {
        return new a(this);
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final int size() {
        return this.elementCount;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final void setSize(int n2) {
        if (n2 > this.elementCount) {
            this.ensureCapacity(n2);
        } else {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
        }
        this.elementCount = n2;
    }

    public final void ensureCapacity(int n2) {
        int n3 = this.elementData.length;
        if (n2 > n3) {
            int n4;
            Object[] objectArray = this.elementData;
            int n5 = n4 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
            if (n4 < n2) {
                n4 = n2;
            }
            this.elementData = new Object[n4];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void trimToSize() {
        int n2 = this.elementData.length;
        if (this.elementCount < n2) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void copyInto(Object[] objectArray) {
        int n2 = this.elementCount;
        while (n2-- > 0) {
            objectArray[n2] = this.elementData[n2];
        }
    }

    public Vector() {
        this(10);
    }

    public Vector(int n2) {
        this(n2, 0);
    }

    public Vector(int n2, int n3) {
        this.elementData = new Object[n2];
        this.capacityIncrement = n3;
    }
}

