/*
 * Decompiled with CFR 0.152.
 */
package com.borland.compiler.storage;

import com.borland.compiler.interfaces.Storage;
import com.borland.compiler.storage.a;
import com.borland.compiler.util.Host;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PlainFile
implements Storage {
    private FileOutputStream a;
    private FileInputStream b;
    public File f;

    public void close() {
        try {
            if (this.b != null) {
                this.b.close();
                this.b = null;
            }
            if (this.a != null) {
                this.a.close();
                this.a = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Storage createDir(String string) throws IOException {
        File file = new File(this.f, string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        return new PlainFile(file);
    }

    public Storage create(String string) throws IOException {
        try {
            File file = new File(this.f, string);
            file.renameTo(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PlainFile plainFile = new PlainFile(file, null, fileOutputStream);
            return plainFile;
        }
        catch (IOException iOException) {
            Storage storage = null;
            return storage;
        }
    }

    public Storage openDir(String string) {
        return new PlainFile(new File(this.f, string));
    }

    public Storage open(String string) {
        File file = new File(this.f, string);
        if (file.exists()) {
            return new PlainFile(file, null, null);
        }
        return null;
    }

    public String[] list() throws IOException {
        if (this.b != null || this.a != null) {
            throw new IOException(com.borland.compiler.storage.a.a(8));
        }
        return this.f.list();
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.b != null) {
            throw new IOException(com.borland.compiler.storage.a.a(11));
        }
        if (this.a == null) {
            this.a = new FileOutputStream(this.f);
        }
        this.a.write(byArray, n2, n3);
        this.close();
    }

    public int read(byte[] byArray) throws IOException {
        int n2;
        if (this.a != null) {
            throw new IOException(com.borland.compiler.storage.a.a(10));
        }
        if (this.b == null) {
            this.b = new FileInputStream(this.f);
        }
        int n3 = (n2 = this.b.available()) < byArray.length ? n2 : byArray.length;
        int n4 = this.b.read(byArray, 0, n3);
        this.close();
        if (n4 != n3) {
            throw new IOException(com.borland.compiler.storage.a.a(7));
        }
        return n2;
    }

    public byte[] read() throws IOException {
        if (this.a != null) {
            throw new IOException(com.borland.compiler.storage.a.a(10));
        }
        if (this.b == null) {
            this.b = new FileInputStream(this.f);
        }
        int n2 = this.b.available();
        byte[] byArray = new byte[n2];
        int n3 = this.b.read(byArray, 0, n2);
        this.close();
        if (n3 != n2) {
            throw new IOException(com.borland.compiler.storage.a.a(7));
        }
        return byArray;
    }

    public boolean isDirectory() {
        return this.b == null && this.a == null && this.f.isDirectory();
    }

    public boolean exists() {
        return this.b != null || this.a != null || this.f.exists();
    }

    public String getParent() {
        return this.f.getParent();
    }

    public String getCanonicalPath() {
        try {
            String string = this.f.getCanonicalPath();
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
    }

    public String getPath() {
        return this.f.getPath();
    }

    public String getName() {
        return this.f.getName();
    }

    public String toString() {
        return this.getCanonicalPath();
    }

    public int hashCode() {
        return this.f.getAbsolutePath().hashCode() + (int)this.modDate();
    }

    public boolean equals(Object object) {
        return object instanceof PlainFile && this.f.getAbsolutePath().equals(((PlainFile)object).f.getAbsolutePath()) && this.modDate() == ((PlainFile)object).modDate();
    }

    public long modDate() {
        return Host.fileTimeStamp(this.f.getPath());
    }

    public PlainFile(File file) {
        this(file, null, null);
    }

    private PlainFile(File file, FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        this.f = file;
        this.b = fileInputStream;
        this.a = fileOutputStream;
    }
}

