/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dx.dataset;

import com.borland.dx.dataset.AggManager;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnList;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.DirectIndex;
import com.borland.dx.dataset.InternalRow;
import com.borland.dx.dataset.LoadCancel;
import com.borland.dx.dataset.MatrixData;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.RowVariant;
import com.borland.dx.dataset.SortDescriptor;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import java.util.Locale;
import java.util.Vector;

public abstract class IndexData
extends MatrixData {
    private int[] a;
    private String e;
    private String d;
    protected int indexUpdateCount;
    protected boolean saveOriginal;
    protected int indexesLength;
    protected DirectIndex[] indexes;
    private InternalRow b;
    protected boolean resolvable;
    protected DirectIndex deleteIndex;
    protected DirectIndex updateIndex;
    protected DirectIndex insertIndex;
    DataSet[] c;

    public int[] getRequiredOrdinals() {
        return this.a;
    }

    public void initRequiredOrdinals(StorageDataSet storageDataSet) {
        int n2;
        ColumnList columnList = storageDataSet.x();
        Column[] columnArray = columnList.rb;
        int n3 = columnList.qb;
        Vector<Column> vector = new Vector<Column>();
        boolean bl = false;
        this.a = null;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!columnArray[n2].isRequired()) continue;
            vector.add(columnArray[n2]);
        }
        for (n2 = 0; n2 < this.indexesLength; ++n2) {
            SortDescriptor sortDescriptor = this.indexes[n2].getSort();
            if (sortDescriptor == null || !sortDescriptor.isPrimary()) continue;
            String[] stringArray = sortDescriptor.getKeys();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Column column = storageDataSet.getColumn(stringArray[i2]);
                if (column.isRequired()) continue;
                vector.add(column);
            }
        }
        if (vector.size() > 0) {
            this.a = new int[vector.size()];
            for (n2 = 0; n2 < this.a.length; ++n2) {
                this.a[n2] = ((Column)vector.elementAt(n2)).getOrdinal();
            }
        }
    }

    public IndexData getIndexData() {
        return this;
    }

    static final DataSet[] c(DataSet[] dataSetArray, DataSet dataSet) {
        int n2 = IndexData.b(dataSetArray, dataSet);
        if (n2 > -1) {
            if (dataSetArray.length == 1) {
                dataSetArray = null;
            } else {
                DataSet[] dataSetArray2 = new DataSet[dataSetArray.length - 1];
                System.arraycopy(dataSetArray, 0, dataSetArray2, 0, n2);
                if (n2 < dataSetArray2.length) {
                    System.arraycopy(dataSetArray, n2 + 1, dataSetArray2, n2, dataSetArray2.length - n2);
                }
                dataSetArray = dataSetArray2;
            }
        }
        return dataSetArray;
    }

    static final DataSet[] a(DataSet[] dataSetArray, DataSet dataSet) {
        if (IndexData.b(dataSetArray, dataSet) < 0) {
            DataSet[] dataSetArray2;
            if (dataSetArray == null) {
                dataSetArray2 = new DataSet[1];
            } else {
                dataSetArray2 = new DataSet[dataSetArray.length + 1];
                System.arraycopy(dataSetArray, 0, dataSetArray2, 0, dataSetArray.length);
            }
            dataSetArray2[dataSetArray2.length - 1] = dataSet;
            dataSetArray = dataSetArray2;
        }
        return dataSetArray;
    }

    static int b(DataSet[] dataSetArray, DataSet dataSet) {
        if (dataSetArray != null) {
            for (int i2 = 0; i2 < dataSetArray.length; ++i2) {
                if (dataSetArray[i2] != dataSet) continue;
                return i2;
            }
        }
        return -1;
    }

    public final void removeDataSet(DataSet dataSet) {
        this.c = IndexData.c(this.c, dataSet);
    }

    public final void addDataSet(DataSet dataSet) {
        this.c = IndexData.a(this.c, dataSet);
    }

    public MatrixData getData() {
        return this;
    }

    public void setCalcNames(String string, String string2) {
        this.d = string;
        this.e = string2;
    }

    public String getCalcAggFieldsName() {
        return this.e;
    }

    public String getCalcFieldsName() {
        return this.d;
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public void notifyRecalc(StorageDataSet storageDataSet) {
        this.d = this.a(storageDataSet.getCalcFieldsListener());
        this.e = this.a(storageDataSet.getCalcAggFieldsListener());
    }

    private final String a(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    public boolean needsRecalc(StorageDataSet storageDataSet) {
        String string = this.a(storageDataSet.getCalcFieldsListener());
        if (string == null != (this.d == null)) {
            return true;
        }
        if (string != null && !string.equals(this.d)) {
            return true;
        }
        string = this.a(storageDataSet.getCalcAggFieldsListener());
        if (string == null != (this.e == null)) {
            return true;
        }
        return string != null && !string.equals(this.e);
    }

    public boolean isMemoryData() {
        return false;
    }

    public final int getUpdatedRowCount() {
        this.openPersistentIndex(2);
        return this.updateIndex == null ? 0 : this.updateIndex.lastRow() + 1;
    }

    public final int getDeletedRowCount() {
        this.openPersistentIndex(1);
        return this.deleteIndex == null ? 0 : this.deleteIndex.lastRow() + 1;
    }

    public final int getInsertedRowCount() {
        this.openPersistentIndex(4);
        return this.insertIndex == null ? 0 : this.insertIndex.lastRow() + 1;
    }

    public final void setLoadCancel(StorageDataSet storageDataSet, LoadCancel loadCancel) {
        storageDataSet.a(loadCancel);
    }

    public void cancelOperation() {
    }

    public Object getDataMonitor() {
        return this;
    }

    public final void closeIndexes() {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].close();
        }
        if (this.insertIndex != null) {
            this.insertIndex.close();
        }
        if (this.deleteIndex != null) {
            this.deleteIndex.close();
        }
        if (this.updateIndex != null) {
            this.updateIndex.close();
        }
    }

    public final void indexUpdate(long l2) {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].updateStore(l2);
        }
    }

    public void getUpdatedRows(StorageDataSet storageDataSet, DataSetView dataSetView) {
        MatrixData.setStorageDataSet(dataSetView, storageDataSet);
    }

    public void getDeletedRows(StorageDataSet storageDataSet, DataSetView dataSetView) {
        MatrixData.setStorageDataSet(dataSetView, storageDataSet);
    }

    public void getInsertedRows(StorageDataSet storageDataSet, DataSetView dataSetView) {
        this.openPersistentIndex(4);
        if (this.insertIndex != null) {
            MatrixData.setStorageDataSet(dataSetView, storageDataSet);
        }
    }

    public final void recalc(StorageDataSet storageDataSet, AggManager aggManager) {
        DataSetView dataSetView = new DataSetView();
        dataSetView.setStorageDataSet(storageDataSet);
        dataSetView.open();
        while (dataSetView.inBounds()) {
            dataSetView.b();
            dataSetView.next();
        }
        dataSetView.post();
        dataSetView.close();
    }

    public final InternalRow getInternalReadRow(StorageDataSet storageDataSet) {
        if (this.b == null) {
            this.b = new InternalRow(storageDataSet, this);
        }
        return this.b;
    }

    public final void clearInternalReadRow() {
        this.b = null;
    }

    public final void markIndexesForUpdate(RowVariant[] rowVariantArray) {
        this.indexUpdateCount = 0;
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            if (!this.indexes[i2].markForUpdate(rowVariantArray)) continue;
            ++this.indexUpdateCount;
        }
    }

    public final void indexDelete(long l2) {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].deleteStore(l2);
        }
    }

    public final void indexAdd(long l2) {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].addStore(l2);
        }
    }

    public final void resetPendingStatus(boolean bl) {
        if (this.updateIndex != null) {
            this.updateIndex.resetPending(bl);
        }
        if (this.insertIndex != null) {
            this.insertIndex.resetPending(bl);
        }
        if (this.deleteIndex != null) {
            this.deleteIndex.resetPendingDeletes(bl);
        }
    }

    public final void resetPendingStatus(long l2, boolean bl) {
        int n2 = this.getStatus(l2);
        if ((n2 & 0x200) != 0) {
            if ((n2 & 1) != 0) {
                this.deleteIndex.resetPendingDelete(l2, bl);
            }
            if ((n2 & 2) != 0) {
                this.updateIndex.resetPending(l2, bl);
            }
            if ((n2 & 4) != 0) {
                this.insertIndex.resetPending(l2, bl);
            }
        }
    }

    public final int saveRow(int n2) {
        this.saveOriginal = false;
        if (this.updateIndex != null && this.resolvable && (n2 & 6) == 0) {
            this.saveOriginal = true;
        }
        return n2;
    }

    public long replaceLoadedRow(long l2, ReadWriteRow readWriteRow, RowVariant[] rowVariantArray, int n2) {
        if (l2 == (long)-1 || this.getStatus(l2) != 8) {
            return this.insertRow(readWriteRow, rowVariantArray, n2);
        }
        this.replaceStoreRow(l2, rowVariantArray, n2);
        return l2;
    }

    public final void updateRow(long l2, Variant[] variantArray, RowVariant[] rowVariantArray, Column[] columnArray) {
        int n2 = rowVariantArray.length;
        if (variantArray == null) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                rowVariantArray[n3].changed = false;
            }
            n2 = columnArray.length;
            for (n3 = 0; n3 < n2; ++n3) {
                rowVariantArray[columnArray[n3].getOrdinal()].changed = true;
            }
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                rowVariantArray[i2].changed = !rowVariantArray[i2].equalsInstance(variantArray[i2]);
            }
        }
        this.markIndexesForUpdate(rowVariantArray);
        this.updateStoreRow(l2, rowVariantArray, columnArray);
    }

    public final void emptyRow(long l2) {
        this.emptyStoreRow(l2);
    }

    public final void deleteRow(long l2) {
        if (this.resolvable) {
            int n2 = this.getStatus(l2);
            if ((n2 & 4) != 0) {
                this.emptyStoreRow(l2);
            } else {
                if ((n2 & 2) != 0) {
                    this.restoreStoreRow(l2);
                }
                this.deleteStoreRow(l2);
                if (this.deleteIndex != null && this.resolvable) {
                    this.deleteIndex.addStore(l2);
                }
                this.indexDelete(l2);
            }
        } else {
            this.emptyStoreRow(l2);
        }
    }

    public DirectIndex[] getIndices() {
        return this.indexes;
    }

    public final boolean indexExists(SortDescriptor sortDescriptor, RowFilterListener rowFilterListener) {
        return this.findIndex(sortDescriptor, sortDescriptor.getLocale(), rowFilterListener, 14, 17) != null;
    }

    public DirectIndex findIndex(SortDescriptor sortDescriptor, Locale locale, RowFilterListener rowFilterListener, int n2, int n3) {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            if (this.a(sortDescriptor, this.indexes[i2].getSort())) {
                return this.indexes[i2];
            }
            if (!this.a(sortDescriptor, this.indexes[i2].getSort(), locale) || this.indexes[i2].getVisibleMask() != n2 || this.indexes[i2].getInvisibleMask() != n3 || !this.indexes[i2].hasRowFilterListener(rowFilterListener)) continue;
            return this.indexes[i2];
        }
        return null;
    }

    private final boolean a(SortDescriptor sortDescriptor, SortDescriptor sortDescriptor2, Locale locale) {
        if (sortDescriptor == sortDescriptor2) {
            return true;
        }
        if (sortDescriptor == null || sortDescriptor2 == null) {
            return false;
        }
        return sortDescriptor.equals(sortDescriptor2, locale);
    }

    private final boolean a(SortDescriptor sortDescriptor, SortDescriptor sortDescriptor2) {
        if (sortDescriptor == null || sortDescriptor2 == null) {
            return false;
        }
        return sortDescriptor.b(sortDescriptor2);
    }

    public void freeFetchIndex() {
    }

    public boolean dropIndex(SortDescriptor sortDescriptor, Locale locale, RowFilterListener rowFilterListener, int n2, int n3) {
        DirectIndex directIndex = this.findIndex(sortDescriptor, locale, rowFilterListener, n2, n3);
        if (directIndex != null) {
            directIndex.dropIndex();
            for (int i2 = 0; i2 < this.indexesLength; ++i2) {
                if (this.indexes[i2] != directIndex) continue;
                directIndex.close();
                --this.indexesLength;
                if (this.indexesLength > i2) {
                    System.arraycopy(this.indexes, i2 + 1, this.indexes, i2, this.indexesLength - i2);
                }
                DirectIndex[] directIndexArray = new DirectIndex[this.indexesLength];
                System.arraycopy(this.indexes, 0, directIndexArray, 0, this.indexesLength);
                this.indexes = directIndexArray;
                return true;
            }
        }
        return false;
    }

    public final void dropIndex(DataSet dataSet) {
        this.dropIndex(dataSet.getSort(), dataSet.getStorageDataSet().getLocale(), dataSet.getRowFilterListener(), dataSet.a, dataSet.ab);
    }

    public final void dropAllIndexes() {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].dropIndex();
        }
        this.indexesLength = 0;
        this.indexes = null;
    }

    public void addIndex(DirectIndex directIndex, int n2) {
        if (n2 == 2) {
            this.updateIndex = directIndex;
        } else if (n2 == 1) {
            this.deleteIndex = directIndex;
        } else if (n2 == 4) {
            this.insertIndex = directIndex;
        } else {
            int n3 = this.indexes == null ? 0 : this.indexesLength;
            DirectIndex[] directIndexArray = new DirectIndex[n3 + 1];
            if (n3 > 0) {
                System.arraycopy(this.indexes, 0, directIndexArray, 0, n3);
            }
            this.indexes = directIndexArray;
            this.indexes[n3] = directIndex;
            this.indexesLength = this.indexes.length;
        }
    }

    public void openPersistentIndex(int n2) {
    }

    public final DirectIndex openIndex(StorageDataSet storageDataSet, SortDescriptor sortDescriptor, RowFilterListener rowFilterListener, int n2, int n3, boolean bl) {
        if (n2 == 2 && this.updateIndex != null) {
            return this.updateIndex;
        }
        if (n2 == 1 && this.deleteIndex != null) {
            return this.deleteIndex;
        }
        if (n2 == 4 && this.insertIndex != null) {
            return this.insertIndex;
        }
        DirectIndex directIndex = this.findIndex(sortDescriptor, storageDataSet.getLocale(), rowFilterListener, n2, n3);
        if (directIndex == null) {
            directIndex = this.findIndex(sortDescriptor, storageDataSet.getLocale(), rowFilterListener, n2, n3);
        }
        if (directIndex == null && bl) {
            if (sortDescriptor != null && sortDescriptor.isUnique() && storageDataSet.getDuplicates() != null) {
                DataSetException.deleteDuplicates();
            }
            DataRow dataRow = null;
            RowVariant[] rowVariantArray = null;
            if (rowFilterListener != null && !this.isMemoryData()) {
                dataRow = new DataRow(storageDataSet);
                rowVariantArray = dataRow.b(storageDataSet.x());
            }
            if (sortDescriptor != null && sortDescriptor.isPrimary()) {
                for (int i2 = 0; i2 < this.indexesLength; ++i2) {
                    SortDescriptor sortDescriptor2 = this.indexes[i2].getSort();
                    if (sortDescriptor2 == null || !sortDescriptor2.isPrimary()) continue;
                    DataSetException.i();
                }
                String[] stringArray = sortDescriptor.getKeys();
                if (stringArray == null || stringArray.length < 1) {
                    DataSetException.y();
                }
            }
            if (sortDescriptor != null) {
                if (sortDescriptor.isSortAsInserted()) {
                    if (sortDescriptor.isUnique()) {
                        throw new DataSetException(String.valueOf(String.valueOf(sortDescriptor.getIndexName())).concat(" index cannot be created with SORT_AS_INSERTED and UNIQUE sort options"));
                    }
                } else if (sortDescriptor.getKeys().length < 1 && !sortDescriptor.isSortAsInserted() && n2 != 4) {
                    DataSetException.c(sortDescriptor.getIndexName());
                }
            }
            if ((directIndex = this.createIndex(storageDataSet, sortDescriptor, rowFilterListener, dataRow, rowVariantArray, n2, n3)).isMaintained()) {
                this.addIndex(directIndex, n2);
                if (sortDescriptor != null && sortDescriptor.isPrimary()) {
                    this.initRequiredOrdinals(storageDataSet);
                }
            }
        }
        return directIndex;
    }

    public final DirectIndex openIndex(DataSet dataSet, boolean bl) {
        RowFilterListener rowFilterListener = dataSet.getRowFilterListener();
        DirectIndex directIndex = this.openIndex(dataSet.getStorageDataSet(), dataSet.getSort(), rowFilterListener, dataSet.a, dataSet.ab, bl);
        return directIndex;
    }

    public boolean canCalc() {
        return true;
    }

    public void replaceStoreRow(long l2, RowVariant[] rowVariantArray, int n2) {
        DataSetException.q();
    }

    public void restoreStoreRow(long l2) {
    }

    public void commitRestructure(StorageDataSet storageDataSet) {
    }

    public void prepareRestructure(StorageDataSet storageDataSet) {
    }

    public abstract DirectIndex createIndex(StorageDataSet var1, SortDescriptor var2, RowFilterListener var3, DataRow var4, RowVariant[] var5, int var6, int var7);

    public abstract void emptyStoreRow(long var1);

    public abstract void deleteStoreRow(long var1);
}

