/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeMath
extends ScriptableObject {
    static Class b;
    static Class a;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public double log(double d2) {
        if (d2 < 0.0) {
            return Double.NaN;
        }
        return Math.log(d2);
    }

    public double exp(double d2) {
        if (d2 == Double.POSITIVE_INFINITY) {
            return d2;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return Math.exp(d2);
    }

    public double pow(double d2, double d3) {
        if (d3 == 0.0) {
            return 1.0;
        }
        if (d2 == 0.0 && d3 < 0.0) {
            Double d4 = new Double(d2);
            if (d4.equals(new Double(0.0))) {
                return Double.POSITIVE_INFINITY;
            }
            if ((double)((int)d3) == d3 && ((int)d3 & 1) == 1) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        return Math.pow(d2, d3);
    }

    public double round(double d2) {
        if (d2 != d2) {
            return d2;
        }
        if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            return d2;
        }
        long l2 = Math.round(d2);
        if (l2 == (long)0) {
            if (d2 < 0.0) {
                return ScriptRuntime.negativeZero;
            }
            return d2 == 0.0 ? d2 : 0.0;
        }
        return l2;
    }

    public static double min(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d2 = Double.POSITIVE_INFINITY;
        if (objectArray.length == 0) {
            return d2;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            double d3 = ScriptRuntime.toNumber(objectArray[i2]);
            if (d3 != d3) {
                return d3;
            }
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    public static double max(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d2 = Double.NEGATIVE_INFINITY;
        if (objectArray.length == 0) {
            return d2;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            double d3 = ScriptRuntime.toNumber(objectArray[i2]);
            if (d3 != d3) {
                return d3;
            }
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    public double asin(double d2) {
        if (d2 != d2 || d2 > 1.0 || d2 < -1.0) {
            return Double.NaN;
        }
        return Math.asin(d2);
    }

    public double acos(double d2) {
        if (d2 != d2 || d2 > 1.0 || d2 < -1.0) {
            return Double.NaN;
        }
        return Math.acos(d2);
    }

    public double abs(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return -d2;
        }
        return d2;
    }

    public String getClassName() {
        return "Math";
    }

    public static Scriptable init(Scriptable scriptable) throws PropertyException {
        NativeMath nativeMath = new NativeMath();
        nativeMath.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        nativeMath.setParentScope(scriptable);
        String[] stringArray = new String[]{"atan", "atan2", "ceil", "cos", "floor", "random", "sin", "sqrt", "tan"};
        nativeMath.defineFunctionProperties(stringArray, b == null ? (b = NativeMath.a("java.lang.Math")) : b, 2);
        String[] stringArray2 = new String[]{"acos", "asin", "abs", "exp", "max", "min", "round", "pow", "log"};
        nativeMath.defineFunctionProperties(stringArray2, a == null ? (a = NativeMath.a("org.mozilla.javascript.NativeMath")) : a, 2);
        ((FunctionObject)nativeMath.get("max", scriptable)).setLength((short)2);
        ((FunctionObject)nativeMath.get("min", scriptable)).setLength((short)2);
        nativeMath.defineProperty("E", new Double(Math.E), 7);
        nativeMath.defineProperty("PI", new Double(Math.PI), 7);
        nativeMath.defineProperty("LN10", new Double(2.302585092994046), 7);
        nativeMath.defineProperty("LN2", new Double(0.6931471805599453), 7);
        nativeMath.defineProperty("LOG2E", new Double(1.4426950408889634), 7);
        nativeMath.defineProperty("LOG10E", new Double(0.4342944819032518), 7);
        nativeMath.defineProperty("SQRT1_2", new Double(0.7071067811865476), 7);
        nativeMath.defineProperty("SQRT2", new Double(1.4142135623730951), 7);
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineProperty("Math", nativeMath, 2);
        return nativeMath;
    }
}

