/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import com.fourthpass.runtimehelp.a;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.f;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    private Scriptable a;
    private Hashtable b;

    public boolean hasInstance(Scriptable scriptable) {
        if (scriptable instanceof NativeJavaObject && !(scriptable instanceof NativeJavaClass)) {
            Object object = ((NativeJavaObject)scriptable).unwrap();
            return this.getClassObject().isInstance(object);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(new StringBuffer("[JavaClass ").append(this.getClassObject().getName()).append("]"));
    }

    public static Scriptable constructSpecific(Context context, Scriptable scriptable, Scriptable scriptable2, Constructor constructor, Object[] objectArray) throws JavaScriptException {
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(scriptable2);
        Class clazz = constructor.getDeclaringClass();
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = NativeJavaObject.coerceType(classArray[i2], objectArray[i2]);
        }
        try {
            Scriptable scriptable4 = (Scriptable)NativeJavaObject.wrap(scriptable3, constructor.newInstance(objectArray), clazz);
            return scriptable4;
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray2 = new Object[]{instantiationException.getMessage(), clazz.getName()};
            throw Context.reportRuntimeError(Context.a("msg.cant.instantiate", objectArray2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = NativeJavaMethod.a(objectArray);
            String string2 = constructor.toString();
            Object[] objectArray3 = new Object[]{illegalArgumentException.getMessage(), string2, string};
            throw Context.reportRuntimeError(Context.a("msg.bad.ctor.sig", objectArray3));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JavaScriptException.a(scriptable, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray4 = new Object[]{illegalAccessException.getMessage()};
            throw Context.reportRuntimeError(Context.a("msg.java.internal.private", objectArray4));
        }
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        Object[] objectArray2;
        String string;
        Class clazz;
        block5: {
            clazz = this.getClassObject();
            int n2 = clazz.getModifiers();
            if (!Modifier.isInterface(n2) && !Modifier.isAbstract(n2)) {
                Member[] memberArray = this.members.a();
                Member member = NativeJavaMethod.a(memberArray, objectArray);
                Constructor constructor = (Constructor)member;
                if (constructor == null) {
                    String string2 = NativeJavaMethod.a(objectArray);
                    Object[] objectArray3 = new Object[]{clazz.getName(), string2};
                    throw Context.reportRuntimeError(Context.a("msg.no.java.ctor", objectArray3));
                }
                return NativeJavaClass.constructSpecific(context, scriptable, this, constructor, objectArray);
            }
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
            string = "";
            try {
                objectArray2 = scriptable2.get("JavaAdapter", scriptable2);
                if (objectArray2 != Scriptable.NOT_FOUND) {
                    Function function = (Function)objectArray2;
                    Object[] objectArray4 = new Object[]{this, objectArray[0]};
                    Scriptable scriptable3 = function.construct(context, scriptable2, objectArray4);
                    return scriptable3;
                }
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                if (string3 == null) break block5;
                string = string3;
            }
        }
        objectArray2 = new Object[]{string, clazz.getName()};
        throw Context.reportRuntimeError(Context.a("msg.cant.instantiate", objectArray2));
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (objectArray.length == 1 && objectArray[0] instanceof Scriptable) {
            Class clazz = this.getClassObject();
            Scriptable scriptable3 = (Scriptable)objectArray[0];
            do {
                Object object;
                if (!(scriptable3 instanceof Wrapper) || !clazz.isInstance(object = ((Wrapper)((Object)scriptable3)).unwrap())) continue;
                return scriptable3;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
        }
        return this.construct(context, scriptable, objectArray);
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public static NativeJavaClass wrap(Scriptable scriptable, Class clazz) {
        return new NativeJavaClass(scriptable, clazz);
    }

    public Class getClassObject() {
        return (Class)super.unwrap();
    }

    public Object[] getIds() {
        return this.members.b(true);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        this.members.put(string, this.javaObject, object, true);
    }

    public Object get(String string, Scriptable scriptable) {
        if (string.equals("prototype")) {
            return null;
        }
        Object object = Scriptable.NOT_FOUND;
        if (this.b != null && (object = this.b.get(string)) != null) {
            return object;
        }
        if (this.members.b(string, true)) {
            object = this.members.a(this, string, this.javaObject, true);
        } else {
            try {
                String string2 = String.valueOf(new StringBuffer(String.valueOf(this.getClassObject().getName())).append('$').append(string));
                Class clazz = com.fourthpass.runtimehelp.a.a(string2);
                NativeJavaClass nativeJavaClass = NativeJavaClass.wrap(ScriptableObject.getTopLevelScope(this), clazz);
                nativeJavaClass.setParentScope(this);
                object = nativeJavaClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.members.a(string);
            }
        }
        return object;
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.members.b(string, true);
    }

    public String getClassName() {
        return "JavaClass";
    }

    public NativeJavaClass(Scriptable scriptable, Class clazz) {
        super(scriptable, (Object)clazz, org.mozilla.javascript.f.a(scriptable, clazz, clazz));
        this.b = this.members.a(this, this.javaObject, true);
    }
}

