/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeJavaArray
extends NativeJavaObject {
    Scriptable a;
    Class c;
    int b;
    Object d;

    public Scriptable getPrototype() {
        if (this.a == null) {
            this.a = ScriptableObject.getClassPrototype(this.getParentScope(), "Array");
        }
        return this.a;
    }

    public boolean hasInstance(Scriptable scriptable) {
        if (!(scriptable instanceof NativeJavaObject)) {
            return false;
        }
        Object object = ((NativeJavaObject)scriptable).unwrap();
        return this.c.isInstance(object);
    }

    public Object[] getIds() {
        Object[] objectArray = new Object[this.b];
        int n2 = this.b;
        while (--n2 >= 0) {
            objectArray[n2] = new Integer(n2);
        }
        return objectArray;
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.d.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public void put(int n2, Scriptable scriptable, Object object) {
        if (n2 >= 0 && n2 < this.b) {
            Array.set(this.d, n2, NativeJavaObject.coerceType(this.c, object));
            return;
        }
        super.put(n2, scriptable, object);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (!string.equals("length")) {
            super.put(string, scriptable, object);
        }
    }

    public Object get(int n2, Scriptable scriptable) {
        if (n2 >= 0 && n2 < this.b) {
            return NativeJavaObject.wrap(this, Array.get(this.d, n2), this.c);
        }
        return Undefined.instance;
    }

    public Object get(String string, Scriptable scriptable) {
        if (string.equals("length")) {
            return new Integer(this.b);
        }
        return super.get(string, scriptable);
    }

    public boolean has(int n2, Scriptable scriptable) {
        return n2 >= 0 && n2 < this.b;
    }

    public boolean has(String string, Scriptable scriptable) {
        return string.equals("length") || super.has(string, scriptable);
    }

    public NativeJavaArray(Scriptable scriptable, Object object) {
        super(scriptable, null, ScriptRuntime.ObjectClass);
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.d = object;
        this.b = Array.getLength(object);
        this.c = clazz.getComponentType();
    }

    public Object unwrap() {
        return this.d;
    }

    public static NativeJavaArray wrap(Scriptable scriptable, Object object) {
        return new NativeJavaArray(scriptable, object);
    }

    public String getClassName() {
        return "JavaArray";
    }
}

