/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;

public class NativeGlobal {
    static Class a;
    private static int d;
    private static int b;
    private static int c;

    static {
        c = 1;
        b = 2;
        d = 4;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Object CommonError(Context context, Object[] objectArray, Function function, boolean bl) {
        NativeError nativeError = new NativeError();
        nativeError.setPrototype((Scriptable)function.get("prototype", (Scriptable)function));
        nativeError.setParentScope(context.gb);
        if (objectArray.length > 0) {
            nativeError.put("message", (Scriptable)nativeError, objectArray[0]);
        }
        return nativeError;
    }

    public static EcmaError constructError(Context context, String string, String string2, Object object, String string3, int n2) {
        Scriptable scriptable;
        try {
            scriptable = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(classCastException.toString());
        }
        Object[] objectArray = new Object[]{string2};
        try {
            Scriptable scriptable2 = context.newObject(scriptable, string, objectArray);
            EcmaError ecmaError = new EcmaError((NativeError)scriptable2, string3, n2);
            return ecmaError;
        }
        catch (PropertyException propertyException) {
            throw new RuntimeException(propertyException.toString());
        }
        catch (JavaScriptException javaScriptException) {
            throw new RuntimeException(javaScriptException.toString());
        }
        catch (NotAFunctionException notAFunctionException) {
            throw new RuntimeException(notAFunctionException.toString());
        }
    }

    public static EcmaError constructError(Context context, String string, String string2, Object object) {
        int[] nArray = new int[]{0};
        String string3 = Context.a(nArray);
        return NativeGlobal.constructError(context, string, string2, object, string3, nArray[0]);
    }

    public static Object evalSpecial(Context context, Scriptable scriptable, Object object, Object[] objectArray, String string, int n2) throws JavaScriptException {
        if (objectArray.length < 1) {
            return Undefined.instance;
        }
        Object object2 = objectArray[0];
        if (!(object2 instanceof String)) {
            String string2 = Context.a("msg.eval.nonstring", null);
            Context.reportWarning(string2);
            return object2;
        }
        int[] nArray = new int[]{n2};
        if (string == null && (string = Context.a(nArray)) == null) {
            string = "<eval'ed string>";
            nArray[0] = 1;
        }
        try {
            Object object3;
            StringReader stringReader = new StringReader((String)object2);
            Object object4 = context.a(3);
            int n3 = context.getOptimizationLevel();
            context.setOptimizationLevel(-1);
            Script script = context.compileReader(scriptable, stringReader, string, nArray[0], object4);
            context.setOptimizationLevel(n3);
            if (script == null) {
                String string3 = Context.a("msg.syntax", null);
                throw new EvaluatorException(string3);
            }
            InterpretedScript interpretedScript = (InterpretedScript)script;
            Object object5 = object3 = interpretedScript.call(context, scriptable, (Scriptable)object, null);
            return object5;
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected io exception");
        }
    }

    public static Object eval(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object[] objectArray2 = new Object[]{"eval"};
        String string = ScriptRuntime.getMessage("msg.cant.call.indirect", objectArray2);
        throw NativeGlobal.constructError(context, "EvalError", string, function);
    }

    public static Object isFinite(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            return Boolean.FALSE;
        }
        double d2 = ScriptRuntime.toNumber(objectArray[0]);
        return d2 != d2 || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Object isNaN(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            return Boolean.TRUE;
        }
        double d2 = ScriptRuntime.toNumber(objectArray[0]);
        return d2 != d2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object unescape(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        StringBuffer stringBuffer = new StringBuffer();
        block0: for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            int n3;
            char c2 = string.charAt(i2);
            if (c2 != '%' || i2 == string.length() - 1) {
                stringBuffer.append(c2);
                continue;
            }
            if (string.charAt(i2 + 1) == 'u') {
                n3 = i2 + 2;
                n2 = i2 + 6;
            } else {
                n3 = i2 + 1;
                n2 = i2 + 3;
            }
            if (n2 > string.length()) {
                stringBuffer.append('%');
                continue;
            }
            String string2 = string.substring(n3, n2);
            for (int i3 = 0; i3 < string2.length(); ++i3) {
                if (TokenStream.f(string2.charAt(i3))) continue;
                stringBuffer.append('%');
                continue block0;
            }
            i2 = n2 - 1;
            stringBuffer.append(new Character((char)Integer.valueOf(string2, 16).intValue()));
        }
        return stringBuffer.toString();
    }

    public static Object escape(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d2;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n2 = c | b | d;
        if (objectArray.length > 1 && ((d2 = ScriptRuntime.toNumber(objectArray[1])) != d2 || (double)(n2 = (int)d2) != d2 || (n2 & ~(c | b | d)) != 0)) {
            String string2 = Context.a("msg.bad.esc.mask", null);
            Context.reportError(string2);
            n2 = c | b | d;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (n2 != 0 && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '@' || c2 == '*' || c2 == '_' || c2 == '-' || c2 == '.' || (c2 == '/' || c2 == '+') && n2 > 3)) {
                stringBuffer.append(c2);
                continue;
            }
            if (c2 < '\u0100') {
                if (c2 == ' ' && n2 == b) {
                    stringBuffer.append('+');
                    continue;
                }
                stringBuffer.append('%');
                stringBuffer.append(cArray[c2 >> 4]);
                stringBuffer.append(cArray[c2 & 0xF]);
                continue;
            }
            stringBuffer.append('%');
            stringBuffer.append('u');
            stringBuffer.append(cArray[c2 >> 12]);
            stringBuffer.append(cArray[(c2 & 0xF00) >> 8]);
            stringBuffer.append(cArray[(c2 & 0xF0) >> 4]);
            stringBuffer.append(cArray[c2 & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static Object parseFloat(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        char c2;
        if (objectArray.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n2 = string.length();
        if (n2 == 0) {
            return ScriptRuntime.NaNobj;
        }
        int n3 = 0;
        while (TokenStream.e(c2 = string.charAt(n3)) && n3 + 1 < n2) {
            ++n3;
        }
        int n4 = n3;
        if (c2 == '+' || c2 == '-') {
            c2 = string.charAt(++n3);
        }
        if (c2 == 'I') {
            if (n3 + 8 > n2 || !string.substring(n3, n3 + 8).equals("Infinity")) {
                return ScriptRuntime.NaNobj;
            }
            double d2 = string.charAt(n4) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            return new Double(d2);
        }
        int n5 = -1;
        int n6 = -1;
        block9: while (n3 < n2) {
            switch (string.charAt(n3)) {
                case '.': {
                    if (n5 != -1) break block9;
                    n5 = n3;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (n6 != -1) break block9;
                    n6 = n3;
                    break;
                }
                case '+': 
                case '-': {
                    if (n6 == n3 - 1) break;
                    break block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    break block9;
                }
            }
            ++n3;
        }
        string = string.substring(n4, n3);
        try {
            Double d3 = Double.valueOf(string);
            return d3;
        }
        catch (NumberFormatException numberFormatException) {
            Double d4 = ScriptRuntime.NaNobj;
            return d4;
        }
    }

    public static Object parseInt(String string, int n2) {
        char c2;
        int n3 = string.length();
        if (n3 == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean bl = false;
        int n4 = 0;
        while (Character.isWhitespace(c2 = string.charAt(n4)) && ++n4 < n3) {
        }
        if (c2 == '+' || (bl = c2 == '-')) {
            ++n4;
        }
        if (n2 == 0) {
            n2 = -1;
        } else {
            if (n2 < 2 || n2 > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (n2 == 16 && n3 - n4 > 1 && string.charAt(n4) == '0' && ((c2 = string.charAt(n4 + 1)) == 'x' || c2 == 'X')) {
                n4 += 2;
            }
        }
        if (n2 == -1) {
            n2 = 10;
            if (n3 - n4 > 1 && string.charAt(n4) == '0') {
                c2 = string.charAt(n4 + 1);
                if (c2 == 'x' || c2 == 'X') {
                    n2 = 16;
                    n4 += 2;
                } else if (c2 != '.') {
                    n2 = 8;
                    ++n4;
                }
            }
        }
        double d2 = ScriptRuntime.a(string, n4, n2);
        return new Double(bl ? -d2 : d2);
    }

    public static void init(Scriptable scriptable) throws PropertyException, NotAFunctionException, JavaScriptException {
        String[] stringArray = new String[]{"eval", "parseInt", "parseFloat", "escape", "unescape", "isNaN", "isFinite"};
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineFunctionProperties(stringArray, a == null ? (a = NativeGlobal.a("org.mozilla.javascript.NativeGlobal")) : a, 2);
        scriptableObject.defineProperty("NaN", ScriptRuntime.NaNobj, 2);
        scriptableObject.defineProperty("Infinity", new Double(Double.POSITIVE_INFINITY), 2);
        scriptableObject.defineProperty("undefined", Undefined.instance, 2);
        String[] stringArray2 = new String[]{"ConversionError", "EvalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError"};
        Method[] methodArray = FunctionObject.findMethods(a == null ? (a = NativeGlobal.a("org.mozilla.javascript.NativeGlobal")) : a, "CommonError");
        Context context = Context.b();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            String string = stringArray2[i2];
            FunctionObject functionObject = new FunctionObject(string, methodArray[0], scriptableObject);
            scriptableObject.defineProperty(string, functionObject, 2);
            Scriptable scriptable2 = context.newObject(scriptable, "Error");
            scriptable2.put("name", scriptable2, (Object)string);
            functionObject.put("prototype", (Scriptable)functionObject, (Object)scriptable2);
        }
    }
}

