/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.DocumentProxy;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import ice.storm.PilotContext;
import ice.storm.PropertyListenerSet;
import ice.storm.ViewportVisitor;
import ice.storm.f;
import ice.storm.h;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Viewport {
    private static int a;
    protected final PropertyListenerSet propertyListeners;
    protected Hashtable params = null;
    protected f curFrameset = null;
    protected f frameset = null;
    protected Component pilotComponent = null;
    protected Pilot pilot = null;
    protected Container container = null;
    protected h pilotContext = null;
    protected Vector children = new Vector();
    protected Viewport parent = null;
    private String b;
    private String c;
    private static final Object d;

    static {
        d = new Object();
        a = 0;
    }

    public DynamicObject getDocumentObject() {
        DynamicObject dynamicObject = null;
        Pilot pilot = this.getPilot();
        if (pilot != null) {
            dynamicObject = pilot.getDocumentObject();
        }
        if (dynamicObject == null) {
            dynamicObject = new DocumentProxy(this.getId());
        }
        return dynamicObject;
    }

    public static URL getContextViewBaseURL() {
        URL uRL = null;
        Viewport viewport = Viewport.contextView();
        if (viewport != null) {
            uRL = viewport.getBaseURL();
        }
        return uRL;
    }

    public static Viewport contextView() {
        return (Viewport)DynEnv.getContextFieldOrNull(d);
    }

    public static Viewport setContextView(Viewport viewport) {
        return (Viewport)DynEnv.setContextField(d, viewport);
    }

    public URL getBaseURL() {
        Pilot pilot = this.getParentChainPilot();
        if (pilot != null) {
            return pilot.getBaseLocation();
        }
        return null;
    }

    public URL getLocationURL() {
        Pilot pilot = this.getParentChainPilot();
        if (pilot != null) {
            return pilot.getCurrentLocationURL();
        }
        return null;
    }

    public String getLocation() {
        Pilot pilot = this.getParentChainPilot();
        if (pilot != null) {
            return pilot.getCurrentLocation();
        }
        return null;
    }

    public void viewportLayout(int n2, int n3, int n4, int n5) {
        if (this.pilotComponent != null) {
            this.pilotComponent.setBounds(n2, n3, n4, n5);
            return;
        }
        if (this.frameset != null) {
            this.frameset.a(n2, n3, n4, n5);
        }
    }

    void a(Viewport viewport) {
        if (this.pilotComponent != null) {
            if (this.container != null) {
                this.container.remove(this.pilotComponent);
            }
            this.pilotComponent = null;
        }
        this.frameset = viewport.frameset;
        this.children = viewport.children;
        viewport.frameset = null;
        viewport.children = null;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            Viewport viewport2 = (Viewport)this.children.elementAt(i2);
            viewport2.parent = this;
            viewport2.a(this.container);
        }
    }

    final void a() {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            Viewport viewport = (Viewport)this.children.elementAt(i2);
            viewport.dispose();
        }
        this.children.removeAllElements();
        if (this.pilot != null && this.pilotComponent == null) {
            this.pilotComponent = this.pilot.createComponent();
            if (this.pilotComponent != null && this.container != null) {
                this.container.add(this.pilotComponent);
                this.container.validate();
            }
        }
        if (this.frameset != null) {
            this.frameset.b();
        }
        this.frameset = null;
        this.curFrameset = null;
    }

    public void dispose() {
        this.removePilot();
        this.a();
        if (this.pilotContext != null) {
            this.pilotContext.a();
        }
        this.container = null;
        this.parent = null;
        this.pilotContext = null;
    }

    public void removePilot() {
        if (this.pilot == null) {
            return;
        }
        h h2 = this.pilotContext;
        if (h2 != null) {
            h2.b();
        }
        if (this.pilotComponent != null) {
            if (this.container != null) {
                this.container.remove(this.pilotComponent);
            }
            this.pilotComponent = null;
        }
        this.pilot = null;
    }

    public void setPilot(Pilot pilot) {
        if (this.pilot != null) {
            this.removePilot();
        }
        this.pilot = pilot;
        if (this.children.size() == 0) {
            this.pilotComponent = this.pilot.createComponent();
            if (this.pilotComponent != null && this.container != null) {
                this.container.add(this.pilotComponent);
                this.container.validate();
            }
        }
    }

    public Pilot getParentChainPilot() {
        Viewport viewport = this;
        do {
            Pilot pilot;
            if ((pilot = viewport.getPilot()) == null) continue;
            return pilot;
        } while ((viewport = viewport.getParent()) != null);
        return null;
    }

    public Pilot getPilot() {
        return this.pilot;
    }

    public Component getPilotComponent() {
        return this.pilotComponent;
    }

    public Viewport findViewportInTreeByName(String string) {
        switch (string.length()) {
            case 4: {
                if (!"_top".equals(string)) break;
                Viewport viewport = this;
                while (true) {
                    Viewport viewport2;
                    if ((viewport2 = viewport.getParent()) == null) {
                        return viewport;
                    }
                    viewport = viewport2;
                }
            }
            case 5: {
                if (!"_self".equals(string)) break;
                return this;
            }
            case 7: {
                if (!"_parent".equals(string)) break;
                return this.getParent();
            }
        }
        Viewport viewport = this;
        do {
            Viewport viewport3;
            if ((viewport3 = viewport.findViewportByName(string)) == null) continue;
            return viewport3;
        } while ((viewport = viewport.getParent()) != null);
        return null;
    }

    public Viewport getImmediateChildWithProperty(Object object, Object object2) {
        int n2 = this.children.size();
        for (int i2 = 0; i2 != n2; ++i2) {
            Viewport viewport = (Viewport)this.children.elementAt(i2);
            if (viewport.getProperty(object) != object2) continue;
            return viewport;
        }
        return null;
    }

    public Viewport findImmediateChild(String string) {
        int n2 = this.children.size();
        for (int i2 = 0; i2 != n2; ++i2) {
            Viewport viewport = (Viewport)this.children.elementAt(i2);
            if (!string.equals(viewport.c) && !string.equals(viewport.b)) continue;
            return viewport;
        }
        return null;
    }

    public Viewport findViewportByName(String string) {
        if (string.equals(this.c) || string.equals(this.b)) {
            return this;
        }
        int n2 = this.children.size();
        for (int i2 = 0; i2 != n2; ++i2) {
            Viewport viewport = (Viewport)this.children.elementAt(i2);
            Viewport viewport2 = viewport.findViewportByName(string);
            if (viewport2 == null) continue;
            return viewport2;
        }
        return null;
    }

    public void getViewAndAllChildren(Vector vector) {
        vector.addElement(this);
        Vector vector2 = this.children;
        int n2 = vector2.size();
        for (int i2 = 0; i2 != n2; ++i2) {
            Viewport viewport = (Viewport)vector2.elementAt(i2);
            viewport.getViewAndAllChildren(vector);
        }
    }

    public void iterate(ViewportVisitor viewportVisitor) {
        if (viewportVisitor == null) {
            return;
        }
        viewportVisitor.visit(this);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            Viewport viewport = (Viewport)this.children.elementAt(i2);
            viewport.iterate(viewportVisitor);
        }
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    void b(Viewport viewport) {
        if (this.parent != null) {
            return;
        }
        this.parent = viewport;
    }

    public Viewport getParent() {
        return this.parent;
    }

    public Viewport getFirstNonFramesetChild() {
        if (this.children.size() == 0) {
            return this;
        }
        return ((Viewport)this.children.elementAt(0)).getFirstNonFramesetChild();
    }

    public Viewport getChildByIndex(int n2) {
        if (n2 >= 0 && n2 < this.children.size()) {
            return (Viewport)this.children.elementAt(n2);
        }
        return null;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public Enumeration getChildren() {
        if (this.children.size() == 0) {
            return null;
        }
        return this.children.elements();
    }

    public void addChild(Viewport viewport) {
        if (this.frameset != null && this.curFrameset == null) {
            return;
        }
        viewport.b(this);
        this.children.addElement(viewport);
        if (this.curFrameset != null) {
            f f2 = this.curFrameset;
            while (f2.c() != null && !f2.a()) {
                f2 = f2.c();
            }
            f2.a(viewport);
        }
    }

    public void endFrameset() {
        if (this.curFrameset != null) {
            this.curFrameset = this.curFrameset.c();
        }
    }

    public void beginFrameset(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        f f2 = new f(nArray, nArray2, nArray3, nArray4);
        if (this.frameset == null) {
            this.curFrameset = this.frameset = f2;
        } else {
            this.curFrameset.a(f2);
            this.curFrameset = f2;
        }
    }

    public boolean isStopRequested() {
        if (this.pilotContext != null) {
            return this.pilotContext.isStopRequested();
        }
        return true;
    }

    PilotContext b() {
        return this.pilotContext;
    }

    void a(h h2) {
        this.pilotContext = h2;
    }

    public Object getProperty(Object object) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(object);
    }

    public void removeProperty(Object object) {
        if (this.params == null) {
            return;
        }
        this.params.remove(object);
    }

    public void setProperty(Object object, Object object2) {
        if (this.params == null) {
            this.params = new Hashtable();
        }
        this.params.put(object, object2);
    }

    void a(Container container) {
        this.container = container;
        if (this.children.size() > 0) {
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                Viewport viewport = (Viewport)this.children.elementAt(i2);
                viewport.a(container);
            }
        }
    }

    public Container getTopLevelContainer() {
        Container container = this.container;
        if (container != null) {
            Container container2;
            while ((container2 = container.getParent()) != null) {
                container = container2;
            }
        }
        return container;
    }

    public Container getContainer() {
        return this.container;
    }

    public void removeAllPropertyChangeListeners() {
        this.propertyListeners.removeAllPropertyChangeListeners();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void setName(String string) {
        if (string != null && string.length() != 0) {
            this.pilotContext.firePropertyChange("nameChange", this.b, string);
            this.b = string;
        }
    }

    public String getName() {
        return this.b;
    }

    public String getId() {
        return this.c;
    }

    public Viewport(String string) {
        this.propertyListeners = new PropertyListenerSet();
        this.b = string != null ? string : "view";
        this.c = Viewport.a(this.b);
    }

    public Viewport() {
        this(null);
    }

    private static String a(String string) {
        return String.valueOf(new StringBuffer("__").append(string).append(++a));
    }
}

