/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCGaugeArea;
import com.klg.jclass.swing.gauge.JCLinearGauge;
import com.klg.jclass.swing.gauge.LinearConstraint;
import com.klg.jclass.swing.gauge.LinearLayout;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import javax.swing.JLabel;

public class JCLinearScale
extends JCAbstractScale {
    protected Orientation orientation = Orientation.HORIZONTAL;
    protected boolean useZoomFactorForMin = true;
    protected boolean useZoomFactorForMax = true;

    public JCLinearScale(JCLinearGauge jCLinearGauge) {
        super(jCLinearGauge);
        this.setLayout(new LinearLayout());
        this.setForeground(Color.white);
        GaugeUtil.createLegendPopulatorRenderer(jCLinearGauge, this);
    }

    public JCLinearScale(JCLinearGauge jCLinearGauge, JCAbstractScale.Direction direction, double d, double d2, Orientation orientation, Color color) {
        super(jCLinearGauge, direction, d, d2, color);
        this.setLayout(new LinearLayout());
        GaugeUtil.createLegendPopulatorRenderer(jCLinearGauge, this);
    }

    public Component add(Component component) {
        this.add(component, new LinearConstraint(this.getGauge(), Double.MAX_VALUE, Integer.MAX_VALUE));
        return component;
    }

    public Component add(Component component, int n) {
        this.add(component, new LinearConstraint(this.getGauge(), Double.MAX_VALUE, Integer.MAX_VALUE), n);
        return component;
    }

    protected void drawImage(Graphics graphics, Image image, Rectangle rectangle) {
        JLabel jLabel = new JLabel();
        if (super.getScaleImage()) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getForeground(), jLabel);
        } else {
            graphics.drawImage(image, rectangle.x, rectangle.y, this.getForeground(), jLabel);
        }
    }

    public JCLinearGauge getLinearGauge() {
        return (JCLinearGauge)this.getGauge();
    }

    Dimension getMaximumScaleSize() {
        return new Dimension(49372, 678495);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getBounds().width, this.getParent().getBounds().height);
    }

    public Rectangle getScaleSize() {
        JCGaugeArea jCGaugeArea = this.getGauge().getGaugeArea();
        Insets insets = jCGaugeArea.getInsets();
        Insets insets2 = this.getInsets();
        int n = jCGaugeArea.getBounds().width;
        int n2 = jCGaugeArea.getBounds().height;
        int n3 = Math.max(insets2.left, insets.left);
        int n4 = Math.max(insets2.right, insets.right);
        int n5 = Math.max(insets2.top, insets.top);
        int n6 = Math.max(insets2.bottom, insets.bottom);
        int n7 = n3;
        int n8 = n5;
        n -= n3 + n4;
        n2 -= n5 + n6;
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        if (this.useZoomFactorForMin || this.useZoomFactorForMax) {
            if (this.orientation == Orientation.VERTICAL) {
                double d = (double)n - (double)n * this.zoomFactor;
                if (this.useZoomFactorForMin && this.useZoomFactorForMax) {
                    n7 += (int)(d / 2.0);
                } else if (this.useZoomFactorForMin) {
                    n7 += (int)d;
                }
                n = (int)((double)n * this.zoomFactor);
            } else {
                double d = (double)n2 - (double)n2 * this.zoomFactor;
                if (this.useZoomFactorForMin && this.useZoomFactorForMax) {
                    n8 += (int)(d / 2.0);
                } else if (this.useZoomFactorForMin) {
                    n8 += (int)d;
                }
                n2 = (int)((double)n2 * this.zoomFactor);
            }
        }
        return new Rectangle(n7, n8, n, n2);
    }

    public boolean getUseZoomFactorForMax() {
        return this.useZoomFactorForMax;
    }

    public boolean getUseZoomFactorForMin() {
        return this.useZoomFactorForMin;
    }

    public void paintComponent(Graphics graphics) {
        JCLinearGauge jCLinearGauge = this.getLinearGauge();
        Rectangle rectangle = this.getScaleSize();
        super.paintComponent(graphics);
        Graphics graphics2 = graphics.create();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.image != null) {
            this.drawImage(graphics2, this.image, rectangle);
        } else {
            graphics2.fillRect(n, n2, n3, n4);
        }
        Rectangle rectangle2 = graphics2.getClipBounds();
        n3 = rectangle2.width;
        n4 = rectangle2.height;
        Graphics2D graphics2D = (Graphics2D)graphics2;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
        graphics2D.setColor(color);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.25f);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(alphaComposite);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(-15.0));
        Font font = new Font("serif", 1, 25).deriveFont(affineTransform);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("D");
        stringBuffer.append("E");
        stringBuffer.append("V");
        stringBuffer.append("E");
        stringBuffer.append("L");
        stringBuffer.append("O");
        stringBuffer.append("P");
        stringBuffer.append("M");
        stringBuffer.append("E");
        stringBuffer.append("N");
        stringBuffer.append("T");
        stringBuffer.append(" ");
        stringBuffer.append("V");
        stringBuffer.append("E");
        stringBuffer.append("R");
        stringBuffer.append("S");
        stringBuffer.append("I");
        stringBuffer.append("O");
        stringBuffer.append("N");
        stringBuffer.append("   ");
        String string = stringBuffer.toString();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        int n5 = (int)textLayout.getBounds().getWidth();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n6 = 0;
        do {
            stringBuffer2.append(string);
        } while ((double)(n6 += n5) < 1.5 * (double)n3);
        String string2 = stringBuffer2.toString();
        AttributedString attributedString = new AttributedString(string2);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, string2.length());
        TextLayout textLayout2 = new TextLayout(string2, font, fontRenderContext);
        float f = 5.0f;
        float f2 = 0.0f;
        while ((double)f2 < 1.5 * (double)n4) {
            textLayout2.draw(graphics2D, f, f2 += textLayout2.getAscent());
            f2 += textLayout2.getDescent() + textLayout2.getLeading();
        }
        graphics2D.setComposite(composite);
        graphics2.dispose();
    }

    public double pick(Point point) {
        double d = this.min;
        Rectangle rectangle = this.getScaleSize();
        d = this.orientation == Orientation.VERTICAL ? GaugeUtil.positionToValue(point.y, this.min, this.max, rectangle.y, rectangle.y + rectangle.height) : GaugeUtil.positionToValue(point.x, this.min, this.max, rectangle.x, rectangle.x + rectangle.width);
        if (this.direction.equals(JCAbstractScale.Direction.BACKWARD) ^ this.orientation == Orientation.VERTICAL) {
            d = this.max - d + this.min;
        }
        d = GaugeUtil.clamp(d, this.min, this.max);
        return d;
    }

    public void redraw() {
        if (this.getGauge().getRepaintEnabled()) {
            this.repaint();
        }
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.redraw();
    }

    public void setUseZoomFactorForMax(boolean bl) {
        this.useZoomFactorForMax = bl;
    }

    public void setUseZoomFactorForMin(boolean bl) {
        this.useZoomFactorForMin = bl;
    }

    public void update(Graphics graphics) {
    }

    public static class Orientation {
        public static final Orientation HORIZONTAL = new Orientation();
        public static final Orientation VERTICAL = new Orientation();

        private Orientation() {
        }
    }
}

