/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCAbstractTick;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCTickStyle;
import com.klg.jclass.swing.gauge.RadialConstraint;
import com.klg.jclass.swing.gauge.RadialLayout;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCCircularTick
extends JCAbstractTick
implements Serializable {
    static final long serialVersionUID = -5247737898082678005L;

    public JCCircularTick(JCCircularScale jCCircularScale) {
        super(jCCircularScale, jCCircularScale.getMin(), jCCircularScale.getMax());
        this.setLayout(new RadialLayout());
    }

    public JCCircularTick(JCCircularScale jCCircularScale, boolean bl, double d, double d2, double d3, boolean bl2, int n, double d4, boolean bl3, boolean bl4, double d5, double d6, double d7, Color color, JCTickStyle jCTickStyle, Font font, Color color2) {
        super(jCCircularScale, bl, d, d2, d3, bl2, n, d4, bl3, bl4, d5, d6, d7, color, jCTickStyle, font, color2);
        this.setLayout(new RadialLayout());
    }

    public void calcCircularTicks(Graphics graphics) {
        JCCircularScale jCCircularScale = this.getCircularScale();
        double d = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d2 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d3 = jCCircularScale.getRadius();
        if (d >= d2) {
            d2 += 360.0;
        }
        double d4 = d2 == d ? 360.0 : Math.abs(d2 - d);
        int n = (int)(GaugeUtil.toRadians(d4) * d3);
        this.calcTicks(graphics, n);
    }

    public JCCircularScale getCircularScale() {
        return (JCCircularScale)this.getScale();
    }

    public Dimension getPreferredSize() {
        return this.getCircularScale().getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = false;
        JCCircularScale jCCircularScale = this.getCircularScale();
        JCAbstractScale.Direction direction = jCCircularScale.getDirection();
        Rectangle rectangle = jCCircularScale.getCircularGauge().getArcBounds();
        super.paintComponent(graphics);
        if (this.automatic) {
            this.calcCircularTicks(graphics);
        }
        double d = jCCircularScale.getMin();
        double d2 = jCCircularScale.getMax();
        double d3 = Math.max(0.0, this.innerExtent);
        double d4 = Math.max(0.0, this.outerExtent);
        double d5 = Math.max(0.0, this.labelExtent);
        if (!this.isVisible() || d >= d2 || d3 >= d4 || this.startValue > this.stopValue || this.incrementValue <= 0.0 || this.tickWidth <= 0.0) {
            return;
        }
        double d6 = jCCircularScale.getRadius();
        double d7 = (double)rectangle.x + d6;
        double d8 = (double)rectangle.y + d6;
        double d9 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d10 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d11 = d3 * d6;
        double d12 = d4 * d6;
        double d13 = this.startValue;
        while (d13 <= this.stopValue && d13 <= d2) {
            if (d13 < d) {
                d13 += this.incrementValue;
                continue;
            }
            if (bl && this.automatic && (d13 == this.stopValue || 1.0 + Math.abs(this.stopValue - d13) == 1.0)) break;
            if (this.drawTicks) {
                if (this.tickStyle == JCTickStyle.LINE) {
                    double d14 = direction.equals(JCAbstractScale.Direction.FORWARD) ? d13 : d2 - d13 + d;
                    double d15 = GaugeUtil.valueToAngle(d14, d, d2, d9, d10);
                    double d16 = GaugeUtil.toRadians(d15);
                    double d17 = Math.cos(d16);
                    double d18 = Math.sin(d16);
                    Graphics graphics2 = graphics.create();
                    graphics2.setColor(this.tickColor);
                    int n = (int)d7 + (int)(d11 * d17);
                    int n2 = (int)d8 - (int)(d11 * d18);
                    int n3 = (int)d7 + (int)(d12 * d17);
                    int n4 = (int)d8 - (int)(d12 * d18);
                    graphics2.drawLine(n, n2, n3, n4);
                    graphics2.dispose();
                } else if (this.tickStyle == JCTickStyle.CIRCLE) {
                    GaugeUtil.drawCircleForCircularScale(graphics, jCCircularScale, this.tickColor, d13, d3, d4);
                } else {
                    GaugeUtil.drawCircularPolygon(graphics, jCCircularScale, this.tickColor, d3, d4, this.tickWidth, d13, this.reversed, true, this.tickStyle);
                }
            }
            d13 += this.incrementValue;
        }
    }

    public void redraw(boolean bl) {
        if (this.getCircularScale().getGauge().getRepaintEnabled()) {
            if (bl) {
                this.redrawLabels();
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void redrawLabels() {
        JCCircularScale jCCircularScale = this.getCircularScale();
        JCAbstractScale.Direction direction = jCCircularScale.getDirection();
        if (this.drawLabels) {
            Graphics graphics;
            boolean bl;
            this.removeAll();
            double d = jCCircularScale.getMin();
            double d2 = jCCircularScale.getMax();
            Rectangle rectangle = jCCircularScale.getCircularGauge().getArcBounds();
            double d3 = jCCircularScale.getRadius();
            double d4 = (double)rectangle.x + d3;
            double d5 = (double)rectangle.y + d3;
            double d6 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
            double d7 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
            if (d6 >= d7) {
                d7 += 360.0;
            }
            boolean bl2 = bl = d6 == d7;
            if (this.automatic && (graphics = this.getGraphics()) != null) {
                this.calcCircularTicks(graphics);
            }
            double d8 = Math.max(0.0, this.labelExtent);
            double d9 = this.startValue;
            while (d9 <= this.stopValue && d9 <= d2 && this.incrementValue != 0.0) {
                if (d9 < d) {
                    d9 += this.incrementValue;
                    continue;
                }
                if (bl && this.automatic && (d9 == this.stopValue || 1.0 + Math.abs(this.stopValue - d9) == 1.0)) break;
                double d10 = d9;
                if (direction.equals(JCAbstractScale.Direction.BACKWARD)) {
                    d10 = d2 - d9 + d;
                }
                double d11 = GaugeUtil.valueToAngle(d10, d, d2, 0.0, GaugeUtil.arcAngle(d6, d7));
                JComponent jComponent = null;
                RadialConstraint radialConstraint = new RadialConstraint(jCCircularScale.getCircularGauge(), d8, d11);
                if (this.labelGenerator != null) {
                    jComponent = this.labelGenerator.makeLabel(this, d9, radialConstraint);
                } else {
                    String string = JCNumberUtil.format(d9, this.precision);
                    jComponent = new JLabel(string);
                    jComponent.setFont(this.getFont());
                    jComponent.setForeground(this.fontColor);
                }
                jComponent.setSize(jComponent.getPreferredSize());
                this.add((Component)jComponent, radialConstraint);
                d9 += this.incrementValue;
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.redrawLabels();
    }
}

