/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.util.ActionMulticaster;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.SerializableImage;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public class BeanPanel
extends JComponent
implements Serializable {
    private static final long serialVersionUID = 200L;
    protected transient WindowListener winListener = new WindowAdapter(){

        public void windowActivated(WindowEvent e) {
            BeanPanel.this.windowActiveChanged(true);
        }

        public void windowDeactivated(WindowEvent e) {
            BeanPanel.this.windowActiveChanged(false);
        }
    };
    protected transient ActionMulticaster actionMulticaster;
    protected transient Image texture;
    protected boolean focusAware = true;
    protected int focusState;
    protected transient boolean foundParentWindow = false;
    transient Rectangle _bounds = new Rectangle();
    static boolean is1dot3;
    static Class class$javax$swing$JComponent;

    public BeanPanel() {
        this.enableEvents(60L);
        super.setLayout(new FlowLayout());
        super.setDoubleBuffered(true);
        super.setOpaque(true);
    }

    public BeanPanel(LayoutManager layout) {
        this.enableEvents(60L);
        super.setLayout(layout);
        super.setDoubleBuffered(true);
        super.setOpaque(true);
    }

    public synchronized void addActionListener(ActionListener l) {
        if (this.actionMulticaster == null) {
            this.actionMulticaster = new ActionMulticaster();
        }
        this.actionMulticaster.add(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.remove(l);
        }
    }

    public void setTexture(Image texture) {
        this.texture = texture;
        if (texture != null) {
            ImageLoader.waitForImage(this, texture);
        }
        this.repaint();
    }

    public Image getTexture() {
        return this.texture;
    }

    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public boolean isOpaque() {
        return this.texture != null ? true : super.isOpaque();
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.repaint();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            Rectangle clip = g.getClipBounds();
            if (this.texture != null) {
                ImageTexture.texture(this.texture, g, clip.x, clip.y, clip.width, clip.height);
            } else {
                g.setColor(this.getBackground());
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
            }
        }
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.dispatch(e);
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        super.processKeyEvent(e);
        if (!e.isConsumed()) {
            switch (e.getID()) {
                case 401: {
                    this.processKeyPressed(e);
                    break;
                }
                case 400: {
                    this.processKeyTyped(e);
                    break;
                }
                case 402: {
                    this.processKeyReleased(e);
                }
            }
        }
    }

    protected void processKeyPressed(KeyEvent e) {
    }

    protected void processKeyTyped(KeyEvent e) {
    }

    protected void processKeyReleased(KeyEvent e) {
    }

    protected void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseEvent(e);
        if (!e.isConsumed()) {
            switch (e.getID()) {
                case 501: {
                    this.processMousePressed(e);
                    break;
                }
                case 502: {
                    this.processMouseReleased(e);
                    break;
                }
                case 500: {
                    this.processMouseClicked(e);
                    break;
                }
                case 504: {
                    this.processMouseEntered(e);
                    break;
                }
                case 505: {
                    this.processMouseExited(e);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseMotionEvent(e);
        if (!e.isConsumed()) {
            switch (e.getID()) {
                case 503: {
                    this.processMouseMoved(e);
                    break;
                }
                case 506: {
                    this.processMouseDragged(e);
                }
            }
        }
    }

    protected void processMousePressed(MouseEvent e) {
        if (e.getClickCount() == 1 && this.isFocusTraversable()) {
            this.requestFocus();
        }
    }

    protected void processMouseReleased(MouseEvent e) {
    }

    protected void processMouseClicked(MouseEvent e) {
    }

    protected void processMouseEntered(MouseEvent e) {
    }

    protected void processMouseExited(MouseEvent e) {
    }

    protected void processMouseMoved(MouseEvent e) {
    }

    protected void processMouseDragged(MouseEvent e) {
    }

    protected void setFocusAware(boolean aware) {
        this.focusAware = aware;
    }

    protected boolean isFocusAware() {
        return this.focusAware;
    }

    public boolean isFocusTraversable() {
        return this.focusAware;
    }

    protected void processFocusEvent(FocusEvent e) {
        if (this.focusAware) {
            switch (e.getID()) {
                case 1004: {
                    this.focusState |= 2;
                    break;
                }
                case 1005: {
                    this.focusState &= 0xFFFFFFFD;
                }
            }
        }
        super.processFocusEvent(e);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void windowActiveChanged(boolean active) {
        this.focusState = active ? (this.focusState &= 0xFFFFFFDF) : (this.focusState |= 0x20);
    }

    public void addNotify() {
        super.addNotify();
        this.findParentWindow();
    }

    public void removeNotify() {
        this.dropParentWindow();
        super.removeNotify();
    }

    protected void findParentWindow() {
        Container c;
        if (this.foundParentWindow) {
            return;
        }
        for (c = this.getParent(); c != null && !(c instanceof Window); c = c.getParent()) {
        }
        if (c instanceof Window) {
            ((Window)c).addWindowListener(this.winListener);
            this.foundParentWindow = true;
        }
    }

    protected void dropParentWindow() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof Window); c = c.getParent()) {
        }
        if (c instanceof Window) {
            ((Window)c).removeWindowListener(this.winListener);
        }
        this.foundParentWindow = false;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.texture != null) {
            s.writeObject(SerializableImage.create(this.texture));
        } else {
            s.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof SerializableImage) {
            this.texture = ((SerializableImage)data).getImage();
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        serialVersionUID = 200L;
        is1dot3 = true;
        try {
            Method method = (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = BeanPanel.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getMethod("getInputVerifier", null);
            is1dot3 = method != null;
        }
        catch (NoSuchMethodException e) {
            is1dot3 = false;
        }
    }
}

