/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.view.ChoiceView;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class ChoiceControl
extends ChoiceView
implements DataChangeListener,
AccessListener,
WritableSingletonModel,
BlackBox,
ColumnAware,
Serializable {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled = false;

    public ChoiceControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public void setModel(SingletonModel sm) {
        if (sm == this) {
            throw new IllegalArgumentException(Res.bundle.getString(76));
        }
        super.setModel(sm);
    }

    public void setItems(DataSet dataSet, String columnName) {
        if (dataSet != null && columnName != null) {
            try {
                DataSetView clonedCursor = dataSet.cloneDataSetView();
                clonedCursor.open();
                clonedCursor.first();
                String[] s = new String[clonedCursor.getRowCount()];
                int i = 0;
                while (clonedCursor.inBounds()) {
                    s[i++] = clonedCursor.getString(columnName);
                    clonedCursor.next();
                }
                this.setItems(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void accessChange(AccessEvent event) {
        switch (event.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception ex) {
                    event.appendException(ex);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void dataChanged(DataChangeEvent event) {
        this.updateSelection();
    }

    public void postRow(DataChangeEvent event) throws Exception {
        this.updateSelection();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        this.columnName = newColumnName;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            PickListDescriptor pl = column.getPickList();
            if (pl != null) {
                this.fillFromPickList(pl);
            }
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color bg = column.getBackground();
        Color fg = column.getForeground();
        Font f = column.getFont();
        if (bg != null) {
            this.setBackground(bg);
        }
        if (fg != null) {
            this.setForeground(fg);
        }
        if (f != null) {
            this.setFont(f);
        }
    }

    private void fillFromPickList(PickListDescriptor pl) {
    }

    public Object get() {
        return this.getModel().get();
    }

    public boolean canSet(boolean startEdit) {
        return this.getWriteModel() != null ? this.getWriteModel().canSet(startEdit) : false;
    }

    public void set(Object data) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(data);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void enableModelEvents(boolean enable) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(enable);
        }
    }
}

