/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CMIME;
import java.io.IOException;
import java.io.InputStream;

class ProgressInputStream
extends InputStream {
    private InputStream iStream;
    private long size;
    private int startPercent;
    private int endPercent;
    private long totalBytesRead = 0L;
    private long bytesInLastFire = 0L;
    private long gapBytes;
    private Object syncObj;
    private CMIME cMIME;

    ProgressInputStream(InputStream inputStream, long l, int n, int n2, CMIME cMIME, Object object) {
        this.iStream = inputStream;
        this.size = l;
        this.startPercent = n;
        this.endPercent = n2;
        this.cMIME = cMIME;
        this.syncObj = object;
        this.gapBytes = n2 > n ? this.size / (long)(n2 - n) : 1000000L;
    }

    private void tryToFireProgress(int n) {
        this.totalBytesRead += (long)n;
        if (this.totalBytesRead - this.bytesInLastFire > this.gapBytes) {
            Object object = this.syncObj;
            synchronized (object) {
                this.cMIME.fireProgress(this.startPercent + (int)(this.totalBytesRead * (long)(this.endPercent - this.startPercent) / this.size));
                this.bytesInLastFire = this.totalBytesRead;
            }
        }
    }

    public int read() throws IOException {
        int n = this.iStream.read();
        this.tryToFireProgress(1);
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.iStream.read(byArray);
        this.tryToFireProgress(n);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.iStream.read(byArray, n, n2);
        this.tryToFireProgress(n3);
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this.skip(l);
        this.totalBytesRead += l;
        return l2;
    }

    public void close() throws IOException {
        this.iStream.close();
    }
}

