/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.Element;
import ipworks.IPWorksException;
import ipworks.Index;
import ipworks.Xmlp;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

class CXMLp {
    private static final int FLUSH_TEXT = 0;
    private static final int FLUSH_WHITESPACE = 1;
    private static final int FLUSH_MIXED = 2;
    private static final int FLUSH_MIDTEXT = 3;
    private static final int S_text = 0;
    private static final int S_tag = 1;
    private static final int S_tag_start = 2;
    private static final int S_tag_gap = 3;
    private static final int S_attr = 4;
    private static final int S_attr_gap = 5;
    private static final int S_equals = 6;
    private static final int S_value = 7;
    private static final int S_after_open = 8;
    private static final int S_nl = 9;
    private static final int S_nl_tago = 10;
    private static final int S_squoted = 11;
    private static final int S_dquoted = 12;
    private static final int S_end = 13;
    private static final int S_entity = 14;
    private static final int S_entity_in_value = 15;
    private static final int S_entity_in_squoted = 16;
    private static final int S_entity_in_dquoted = 17;
    private static final int S_junk_tag = 18;
    private static final int S_pre_comment = 19;
    private static final int S_comment = 20;
    private static final int S_pi = 21;
    private static final int S_meta_open = 22;
    private static final int S_meta = 23;
    private static final int S_special_section = 24;
    private static final int S_special_section_id = 25;
    private static final int S_squoted_in_meta = 26;
    private static final int S_dquoted_in_meta = 27;
    private static final int S_markup_in_meta = 28;
    private static final int XMLFLAG_IGNORE_BAD_ATTRIBUTE_PREFIX = 1;
    private static final int XMLFLAG_IGNORE_BAD_ELEMENT_PREFIX = 2;
    private static final boolean EMPTY = true;
    private static final boolean NOT_EMPTY = false;
    private int state = 0;
    private char prevChar;
    private char prevprevChar;
    private StringBuffer textBuffer;
    private StringBuffer entityBuffer;
    private StringBuffer scratchBuffer;
    private StringBuffer entityValBuffer;
    private String currentElement;
    private String currentAttribute;
    private boolean validate = false;
    private boolean buildDOM = false;
    private Vector namespaceNames;
    private Vector namespaceValues;
    private Vector elementNames;
    private Vector elementToNamespaceIndex;
    private Vector attributeNames;
    private Vector attributeNamespaces;
    private Vector attributeValues;
    private Element rElement;
    private Element xElement;
    private String extraNameChars = "";
    private String extraSpaceChars = "";
    private int flags = 0;
    private boolean flushOnEOL = true;
    private int offset;
    private Xmlp sink;

    CXMLp(Xmlp xmlp, Object object) {
        this.sink = xmlp;
        this.resetBuffers();
    }

    private void resetBuffers() {
        this.state = 0;
        this.prevChar = (char)32;
        this.prevprevChar = (char)32;
        this.offset = 0;
        this.textBuffer = new StringBuffer();
        this.entityBuffer = new StringBuffer();
        this.scratchBuffer = new StringBuffer();
        this.entityValBuffer = new StringBuffer();
        this.currentElement = "";
        this.currentAttribute = "";
        this.namespaceNames = new Vector();
        this.namespaceValues = new Vector();
        this.elementNames = new Vector();
        this.elementToNamespaceIndex = new Vector();
        this.attributeNames = new Vector();
        this.attributeNamespaces = new Vector();
        this.attributeValues = new Vector();
        this.xElement = null;
        this.rElement = null;
    }

    String do_Attr(String string) throws IPWorksException {
        return (String)this.attributeValues.elementAt(this.attributeNames.indexOf(string));
    }

    void do_Flush() throws IPWorksException {
        this.flush();
    }

    void do_Input(String string) throws IPWorksException {
        this.input(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void do_ParseFile(String string) throws IPWorksException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(string);
                byte[] byArray = new byte[10000];
                int n = fileInputStream.read(byArray);
                block7: while (n > 0) {
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            n = fileInputStream.read(byArray);
                            continue block7;
                        }
                        this.put((char)byArray[n2]);
                        ++n2;
                    }
                }
            }
            catch (IOException iOException) {
                throw new IPWorksException(iOException);
            }
            Object var7_7 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return;
    }

    void do_Reset() throws IPWorksException {
        this.reset();
    }

    int getAttrCount() {
        return this.attributeNames.size();
    }

    String getAttrName(int n) {
        try {
            return (String)this.attributeNames.elementAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    String getAttrValue(int n) {
        try {
            return (String)this.attributeValues.elementAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    String getAttrNamespace(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            this.translateAttributePrefix(this.getAttrName(n), stringBuffer, stringBuffer2);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        return stringBuffer2.toString();
    }

    String getAttrPrefix(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            this.translateAttributePrefix(this.getAttrName(n), stringBuffer, stringBuffer2);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    int getElementCount() {
        return this.elementNames.size();
    }

    String getElements(int n) throws IPWorksException {
        try {
            return (String)this.elementNames.elementAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IPWorksException(indexOutOfBoundsException);
        }
    }

    int getNamespaceCount() {
        return this.namespaceNames.size();
    }

    String getNamespaces(int n) throws IPWorksException {
        try {
            return (String)this.namespaceValues.elementAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IPWorksException(indexOutOfBoundsException);
        }
    }

    String getPrefixes(int n) throws IPWorksException {
        try {
            return (String)this.namespaceNames.elementAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IPWorksException(indexOutOfBoundsException);
        }
    }

    String getExtraNameChars() {
        return this.extraNameChars;
    }

    void setExtraNameChars(String string) throws IPWorksException {
        if (string == null) {
            return;
        }
        this.extraNameChars = this.extraNameChars + string;
    }

    String getExtraSpaceChars() {
        return this.extraSpaceChars;
    }

    void setExtraSpaceChars(String string) throws IPWorksException {
        if (string == null) {
            return;
        }
        this.extraSpaceChars = this.extraSpaceChars + string;
    }

    int getFlags() {
        return this.flags;
    }

    void setFlags(int n) {
        this.flags = n;
    }

    boolean getFlushOnEOL() {
        return this.flushOnEOL;
    }

    void setFlushOnEOL(boolean bl) throws IPWorksException {
        this.flushOnEOL = bl;
    }

    boolean getBuildDOM() {
        return this.buildDOM;
    }

    void setBuildDOM(boolean bl) throws IPWorksException {
        this.buildDOM = bl;
    }

    boolean getValidate() {
        return this.validate;
    }

    void setValidate(boolean bl) throws IPWorksException {
        this.validate = bl;
    }

    int getOffset() {
        return this.offset;
    }

    void setInputText(String string) throws IPWorksException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.put(string.charAt(n2));
            ++n2;
        }
    }

    void setInputText(byte[] byArray) throws IPWorksException {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.put((char)byArray[n2]);
            ++n2;
        }
    }

    void setFlushText(boolean bl) {
        if (bl) {
            this.flushText(0);
        }
    }

    void setResetText(boolean bl) {
        if (bl) {
            this.flushText(0);
        }
        this.resetBuffers();
    }

    void input(String string) throws IPWorksException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.put(string.charAt(n2));
            ++n2;
        }
    }

    void reset() {
        this.flushText(0);
        this.resetBuffers();
    }

    void flush() throws IPWorksException {
        this.flushText(0);
        if (this.validate && this.elementNames.size() > 0) {
            throw new IPWorksException(206);
        }
    }

    int getXChildren() {
        if (this.xElement == null) {
            return 0;
        }
        return this.xElement.children.size();
    }

    String getXElement() {
        if (this.xElement == null) {
            return "";
        }
        return this.xElement.name;
    }

    String getXNamespace() {
        if (this.xElement == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            this.translateElementPrefix(this.xElement.name, stringBuffer, stringBuffer2);
        }
        catch (IPWorksException iPWorksException) {
            return "";
        }
        return stringBuffer2.toString();
    }

    String getXParent() {
        if (this.xElement == null || this.xElement.parent == null) {
            return "";
        }
        return this.xElement.parent.name;
    }

    String getXPrefix() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            this.translateElementPrefix(this.getXElement(), stringBuffer, stringBuffer2);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    String getXText() {
        if (this.xElement == null) {
            return "";
        }
        return this.xElement.text.toString();
    }

    String getXPath() {
        if (this.xElement == null) {
            return "";
        }
        String string = "";
        Element element = this.xElement;
        while (element != null) {
            string = "/" + element.name + string;
            element = element.parent;
        }
        return string;
    }

    void setXPath(String string) throws IPWorksException {
        if (string == null || string.equals("") || string.equals(".")) {
            return;
        }
        if (this.rElement == null) {
            throw new IPWorksException(210);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        boolean bl = false;
        if (string.startsWith("/") || this.xElement == null) {
            this.xElement = this.rElement;
            bl = true;
        }
        while (stringTokenizer.hasMoreTokens()) {
            this.locate(stringTokenizer.nextToken(), bl);
            bl = false;
        }
        this.attributeNames = this.xElement.attributeNames;
        this.attributeValues = this.xElement.attributeValues;
        this.attributeNamespaces = this.xElement.attributeNamespaces;
    }

    private void locate(String string, boolean bl) throws IPWorksException {
        int n;
        if (this.xElement.equals("..")) {
            if (this.xElement.parent != null) {
                this.xElement = this.xElement.parent;
            }
            return;
        }
        if (bl) {
            if (string.startsWith(this.xElement.name)) {
                string = string.substring(this.xElement.name.length());
            } else if (string.startsWith(this.xElement.nameSansPrefix)) {
                string = string.substring(this.xElement.nameSansPrefix.length());
            } else {
                throw new IPWorksException(207);
            }
            if (string.length() == 0) {
                return;
            }
        }
        if ((n = this.xElement.childrenNames.indexOf(string)) != -1) {
            this.xElement = (Element)this.xElement.children.elementAt(n);
            return;
        }
        n = this.xElement.childrenNamesSansPrefix.indexOf(string);
        if (n != -1) {
            this.xElement = (Element)this.xElement.children.elementAt(n);
            return;
        }
        if (string.endsWith("]")) {
            int n2 = string.indexOf("[");
            if (n2 == -1) {
                throw new IPWorksException(207);
            }
            if (n2 > 0) {
                this.locate(string.substring(0, n2), false);
            }
            n = Integer.parseInt(string.substring(n2 + 1, string.length() - 1)) - 1;
            this.xElement = (Element)this.xElement.children.elementAt(n);
            return;
        }
        throw new IPWorksException(207);
    }

    private boolean isSpaceChar(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || this.extraSpaceChars.indexOf(c) != -1;
    }

    private boolean isNameChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == ':' || this.extraNameChars.indexOf(c) != -1;
    }

    private boolean isStartNameChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == ':';
    }

    private boolean isInterestingElement(StringBuffer stringBuffer) {
        return true;
    }

    private void prodText(char c) {
        this.textBuffer.append(c);
    }

    private void prodText(String string) {
        this.textBuffer.append(string);
    }

    private void flushText(int n) {
        if (this.textBuffer.length() == 0) {
            return;
        }
        switch (n) {
            case 0: {
                String string = this.textBuffer.toString();
                this.fireCharacters(string);
                if (!this.buildDOM || this.rElement == null) break;
                this.rElement.text.append(string);
                break;
            }
            case 1: {
                this.fireIgnorableWhitespace(this.textBuffer.toString());
                break;
            }
            case 2: {
                int n2 = this.textBuffer.length();
                while (n2 > 0) {
                    if (this.isSpaceChar(this.textBuffer.charAt(--n2))) continue;
                    ++n2;
                    break;
                }
                if (n2 > 0) {
                    String string = this.textBuffer.toString().substring(0, n2);
                    this.fireCharacters(string);
                    if (this.buildDOM && this.rElement != null) {
                        this.rElement.text.append(string);
                    }
                }
                if (n2 >= this.textBuffer.length()) break;
                this.fireIgnorableWhitespace(this.textBuffer.toString().substring(n2));
                break;
            }
            case 3: {
                int n3 = this.textBuffer.length();
                while (n3 > 0) {
                    if (this.isSpaceChar(this.textBuffer.charAt(--n3))) continue;
                    ++n3;
                    break;
                }
                if (n3 > 0) {
                    String string = this.textBuffer.toString().substring(0, n3);
                    this.fireCharacters(string);
                    if (this.buildDOM && this.rElement != null) {
                        this.rElement.text.append(string);
                    }
                }
                this.textBuffer = new StringBuffer(this.textBuffer.toString().substring(n3));
                return;
            }
        }
        this.textBuffer.setLength(0);
    }

    private void prodEntity(char c) {
        this.flushText(0);
        this.entityValBuffer.setLength(0);
        this.entityValBuffer.append('&');
        this.entityValBuffer.append(this.entityBuffer.toString());
        if (c == ';') {
            this.entityValBuffer.append(c);
        }
        this.fireEvalEntity(this.entityBuffer.toString(), this.entityValBuffer);
        this.entityBuffer.setLength(0);
    }

    private void prodElementName() {
        this.flushText(0);
        this.currentElement = this.scratchBuffer.toString();
        this.scratchBuffer.setLength(0);
        this.currentAttribute = "";
        if (this.validate) {
            int n = -1;
            try {
                n = ((Index)this.elementToNamespaceIndex.lastElement()).value();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.elementNames.addElement(this.currentElement);
            this.elementToNamespaceIndex.addElement(new Index(n));
        }
    }

    private void prodAttributeName() {
        this.currentAttribute = this.scratchBuffer.toString();
        this.scratchBuffer.setLength(0);
    }

    private void prodAttributeValue() {
        if (this.validate && this.currentAttribute.startsWith("xmlns")) {
            int n = 5;
            try {
                if (this.currentAttribute.charAt(5) == ':') {
                    ++n;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            String string = this.currentAttribute.substring(n);
            String string2 = this.scratchBuffer.toString();
            if (this.validate) {
                this.namespaceNames.addElement(string);
                this.namespaceValues.addElement(string2);
                ((Index)this.elementToNamespaceIndex.lastElement()).increment();
            }
            this.fireStartPrefixMapping(string, string2);
        } else {
            this.attributeNames.addElement(this.currentAttribute);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                this.translateAttributePrefix(this.currentAttribute, stringBuffer, stringBuffer2);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            this.attributeNamespaces.addElement(stringBuffer2.toString());
            this.attributeValues.addElement(this.scratchBuffer.toString());
        }
        this.currentAttribute = "";
        this.scratchBuffer.setLength(0);
    }

    private void prodEmptyElement() throws IPWorksException {
        this.scratchBuffer.setLength(0);
        this.scratchBuffer.append(this.currentElement);
        this.prodStartElement(true);
        this.prodEndElement(true);
    }

    private void prodStartElement(boolean bl) throws IPWorksException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.translateElementPrefix(this.currentElement, stringBuffer, stringBuffer2);
        this.fireStartElement(stringBuffer2.toString(), stringBuffer.toString(), this.currentElement, bl);
        if (this.buildDOM) {
            this.rElement = new Element(this.rElement, this.currentElement, stringBuffer.toString(), this.attributeNames, this.attributeNamespaces, this.attributeValues);
        }
        this.attributeNames = new Vector();
        this.attributeNamespaces = new Vector();
        this.attributeValues = new Vector();
        this.currentElement = "";
    }

    private void prodEndElement(boolean bl) throws IPWorksException {
        this.flushText(0);
        String string = this.scratchBuffer.toString();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.validate) {
            this.translateElementPrefix(string, stringBuffer, stringBuffer2);
        }
        this.fireEndElement(stringBuffer2.toString(), stringBuffer.toString(), string, bl);
        if (this.buildDOM && this.rElement.parent != null) {
            this.rElement.parent.children.addElement(this.rElement);
            this.rElement.parent.childrenNames.addElement(this.rElement.name);
            this.rElement.parent.childrenNamesSansPrefix.addElement(this.rElement.nameSansPrefix);
            this.rElement = this.rElement.parent;
        }
        if (this.validate) {
            if (this.elementNames.isEmpty() || !string.equals(this.elementNames.lastElement())) {
                throw new IPWorksException(10201);
            }
            this.elementToNamespaceIndex.setSize(this.elementToNamespaceIndex.size() - 1);
            this.elementNames.setSize(this.elementNames.size() - 1);
            int n = this.namespaceValues.size();
            int n2 = this.elementToNamespaceIndex.isEmpty() ? 0 : ((Index)this.elementToNamespaceIndex.lastElement()).value() + 1;
            while (n > n2) {
                this.fireEndPrefixMapping(this.namespaceNames.lastElement().toString());
                this.namespaceNames.setSize(--n);
                this.namespaceValues.setSize(n);
            }
        }
        this.scratchBuffer.setLength(0);
    }

    private void prodComment() {
        this.flushText(0);
        this.fireComment(this.scratchBuffer.toString());
        this.scratchBuffer.setLength(0);
    }

    private void prodPI() {
        this.flushText(0);
        this.firePI(this.scratchBuffer.toString());
        this.scratchBuffer.setLength(0);
    }

    private void prodMeta() {
        this.flushText(0);
        this.fireMeta(this.scratchBuffer.toString());
        this.scratchBuffer.setLength(0);
    }

    private void prodSpecialSection() {
        this.fireSpecialSection(this.scratchBuffer.toString(), this.textBuffer.toString());
        this.scratchBuffer.setLength(0);
        this.textBuffer.setLength(0);
    }

    private void prodWhitespace() {
        this.fireIgnorableWhitespace("");
    }

    void translateElementPrefix(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IPWorksException {
        int n = string.indexOf(58);
        stringBuffer.append(string.substring(n + 1));
        int n2 = this.namespaceNames.lastIndexOf(n > 0 ? string.substring(0, n) : "");
        if (n2 < 0) {
            if ((this.flags & 2) != 0) {
                throw new IPWorksException(202);
            }
            this.fireError(new IPWorksException(202));
        } else {
            stringBuffer2.append((String)this.namespaceValues.elementAt(n2));
        }
    }

    int translateAttributePrefix(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IPWorksException {
        int n = string.indexOf(58);
        if (n == -1) {
            return -1;
        }
        String string2 = string.substring(0, n);
        int n2 = this.namespaceNames.lastIndexOf(string2);
        if (n2 < 0) {
            if ((this.flags & 1) != 0) {
                throw new IPWorksException(203);
            }
            this.fireError(new IPWorksException(203));
        } else {
            stringBuffer2.append((String)this.namespaceValues.elementAt(n2));
            stringBuffer.append(string2);
        }
        return n2;
    }

    private void put(char c) throws IPWorksException {
        ++this.offset;
        block0 : switch (this.state) {
            case 8: {
                if (this.isSpaceChar(c)) {
                    this.prodText(c);
                    break;
                }
                this.flushText(1);
                this.state = 0;
            }
            case 0: {
                switch (c) {
                    case '&': {
                        this.entityBuffer.setLength(0);
                        this.state = 14;
                        break block0;
                    }
                    case '<': {
                        this.flushText(2);
                        this.scratchBuffer.setLength(0);
                        this.state = 2;
                        break block0;
                    }
                    case '\n': {
                        this.prodText(c);
                        if (!this.flushOnEOL) break block0;
                        this.flushText(3);
                        break block0;
                    }
                }
                this.prodText(c);
                break;
            }
            case 14: {
                if (this.isNameChar(c) || c == '#') {
                    this.entityBuffer.append(c);
                    break;
                }
                this.prodEntity(c);
                this.prodText(this.entityValBuffer.toString());
                this.state = 0;
                if (c == ';') break;
                this.put(c);
                return;
            }
            case 15: {
                if (this.isNameChar(c) || c == '#') {
                    this.entityBuffer.append(c);
                    break;
                }
                this.prodEntity(c);
                this.scratchBuffer.append((Object)this.entityValBuffer);
                this.state = 7;
                if (c == ';') break;
                this.put(c);
                return;
            }
            case 16: {
                if (this.isNameChar(c) || c == '#') {
                    this.entityBuffer.append(c);
                    break;
                }
                this.prodEntity(c);
                this.scratchBuffer.append((Object)this.entityValBuffer);
                this.state = 11;
                if (c == ';') break;
                this.put(c);
                return;
            }
            case 17: {
                if (this.isNameChar(c) || c == '#') {
                    this.entityBuffer.append(c);
                    break;
                }
                this.prodEntity(c);
                this.scratchBuffer.append((Object)this.entityValBuffer);
                this.state = 12;
                if (c == ';') break;
                this.put(c);
                return;
            }
            case 21: {
                if (c == '>' && this.prevChar == '?') {
                    this.scratchBuffer.setLength(this.scratchBuffer.length() - 1);
                    this.prodPI();
                    this.state = 8;
                    break;
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 19: {
                if (c == '-') {
                    this.scratchBuffer.setLength(0);
                    this.state = 20;
                    break;
                }
                this.state = 23;
                this.scratchBuffer.append(c);
                break;
            }
            case 20: {
                if (c == '>' && this.prevChar == '-' && this.prevprevChar == '-') {
                    this.scratchBuffer.setLength(this.scratchBuffer.length() - 2);
                    this.prodComment();
                    this.state = 8;
                    break;
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 25: {
                if (c == '[') {
                    this.state = 24;
                    break;
                }
                if (this.isSpaceChar(c)) break;
                this.scratchBuffer.append(c);
                break;
            }
            case 24: {
                if (c == '>' && this.prevChar == ']' && this.prevprevChar == ']') {
                    this.textBuffer.setLength(this.textBuffer.length() - 2);
                    this.prodSpecialSection();
                    this.state = 0;
                    break;
                }
                this.textBuffer.append(c);
                break;
            }
            case 22: {
                if (c == '[') {
                    this.state = 25;
                    break;
                }
                if (c == '-') {
                    this.scratchBuffer.append(c);
                    this.state = 19;
                    break;
                }
                this.state = 23;
                this.scratchBuffer.append(c);
                break;
            }
            case 23: {
                if (c == '>') {
                    this.state = 8;
                    this.prodMeta();
                    break;
                }
                if (c == '[') {
                    this.state = 28;
                } else if (c == '\"') {
                    this.state = 27;
                } else if (c == '\'') {
                    this.state = 26;
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 28: {
                if (c == ']') {
                    this.state = 23;
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 26: {
                if (c == '\'') {
                    this.state = 23;
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 27: {
                if (c == '\"') {
                    this.state = 23;
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 2: {
                if (this.validate && !this.isNameChar(c) && c != '/' && c != '?' && c != '!') {
                    this.prodText('<');
                    this.state = 0;
                    this.put(c);
                    return;
                }
                this.state = 1;
            }
            case 1: {
                if (this.isNameChar(c)) {
                    this.scratchBuffer.append(c);
                    break;
                }
                if (c == '!') {
                    this.scratchBuffer.setLength(0);
                    this.flushText(0);
                    this.state = 22;
                    break;
                }
                if (c == '?') {
                    this.scratchBuffer.setLength(0);
                    this.flushText(0);
                    this.state = 21;
                    break;
                }
                if (c == '/' && this.prevChar == '<') {
                    this.state = 13;
                    break;
                }
                if (!this.isInterestingElement(this.scratchBuffer)) {
                    this.prodText('<');
                    this.prodText(this.scratchBuffer.toString());
                    this.state = 0;
                    this.put(c);
                    return;
                }
                this.prodElementName();
                if (c == '>') {
                    if (this.prevChar == '/') {
                        this.prodEmptyElement();
                    } else {
                        this.prodStartElement(false);
                    }
                    this.state = 8;
                    break;
                }
                this.state = 3;
                break;
            }
            case 3: {
                if (this.isSpaceChar(c) || c == '/') break;
                if (c == '>') {
                    if (this.prevChar == '/') {
                        this.prodEmptyElement();
                    } else {
                        this.prodStartElement(false);
                    }
                    this.state = 8;
                    break;
                }
                this.scratchBuffer.append(c);
                this.state = 4;
                break;
            }
            case 4: {
                if (this.isSpaceChar(c) || c == '>' || c == '=' || c == '/') {
                    this.prodAttributeName();
                    if (this.isSpaceChar(c)) {
                        this.state = 5;
                        break;
                    }
                    if (c != '=') {
                        this.prodAttributeValue();
                    }
                    if (c == '>') {
                        if (this.prevChar == '/') {
                            this.prodEmptyElement();
                        } else {
                            this.prodStartElement(false);
                        }
                        this.state = 8;
                        break;
                    }
                    this.state = c == '=' ? 6 : 5;
                    break;
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 5: {
                if (this.isSpaceChar(c)) break;
                switch (c) {
                    case '>': {
                        this.prodAttributeValue();
                        if (this.prevChar == '/') {
                            this.prodEmptyElement();
                        } else {
                            this.prodStartElement(false);
                        }
                        this.state = 8;
                        break block0;
                    }
                    case '=': {
                        this.state = 6;
                        break block0;
                    }
                }
                this.prodAttributeValue();
                this.scratchBuffer.append(c);
                this.state = 4;
                break;
            }
            case 6: {
                if (this.isSpaceChar(c)) {
                    if (!this.validate) break;
                    throw new IPWorksException(204);
                }
                switch (c) {
                    case '>': {
                        if (this.validate) {
                            throw new IPWorksException(204);
                        }
                        this.prodAttributeValue();
                        if (this.prevChar == '/') {
                            this.prodEmptyElement();
                        } else {
                            this.prodStartElement(false);
                        }
                        this.state = 8;
                        break block0;
                    }
                    case '\'': {
                        this.state = 11;
                        break block0;
                    }
                    case '\"': {
                        this.state = 12;
                        break block0;
                    }
                    case '&': {
                        this.entityBuffer.setLength(0);
                        this.state = 15;
                        break block0;
                    }
                }
                this.scratchBuffer.append(c);
                this.state = 7;
                break;
            }
            case 7: {
                if (c == '&') {
                    this.entityBuffer.setLength(0);
                    this.state = 15;
                    break;
                }
                if (this.isSpaceChar(c) || c == '>') {
                    if (c == '>' && this.prevChar == '/') {
                        this.scratchBuffer.setLength(this.scratchBuffer.length() - 1);
                    }
                    this.prodAttributeValue();
                    if (c == '>') {
                        if (this.prevChar == '/') {
                            this.prodEmptyElement();
                        } else {
                            this.prodStartElement(false);
                        }
                        this.state = 8;
                        break;
                    }
                    this.state = 3;
                    break;
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 11: {
                switch (c) {
                    case '&': {
                        this.entityBuffer.setLength(0);
                        this.state = 16;
                        break block0;
                    }
                    case '\'': {
                        this.prodAttributeValue();
                        this.state = 3;
                        break block0;
                    }
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 12: {
                switch (c) {
                    case '&': {
                        this.entityBuffer.setLength(0);
                        this.state = 17;
                        break block0;
                    }
                    case '\"': {
                        this.prodAttributeValue();
                        this.state = 3;
                        break block0;
                    }
                }
                this.scratchBuffer.append(c);
                break;
            }
            case 13: {
                if (this.isNameChar(c)) {
                    this.scratchBuffer.append(c);
                    break;
                }
                if (!this.isInterestingElement(this.scratchBuffer)) {
                    this.prodText("</");
                    this.prodText(this.scratchBuffer.toString());
                    this.state = 0;
                    this.put(c);
                    return;
                }
                this.prodEndElement(false);
                this.state = c != '>' ? 18 : 8;
                break;
            }
            case 18: {
                if (this.validate) {
                    throw new IPWorksException(204);
                }
                if (c != '>') break;
                this.state = 0;
            }
        }
        this.prevprevChar = this.prevChar;
        this.prevChar = c;
    }

    void fireCharacters(String string) {
        if (this.sink != null) {
            this.sink.fireCharacters(string.getBytes());
        }
    }

    void fireStartPrefixMapping(String string, String string2) {
        if (this.sink != null) {
            this.sink.fireStartPrefixMapping(string, string2);
        }
    }

    void fireEndPrefixMapping(String string) {
        if (this.sink != null) {
            this.sink.fireEndPrefixMapping(string);
        }
    }

    void fireIgnorableWhitespace(String string) {
        if (this.sink != null) {
            this.sink.fireIgnorableWhitespace(string);
        }
    }

    void fireEvalEntity(String string, StringBuffer stringBuffer) {
        if (this.sink != null) {
            this.sink.fireEvalEntity(string, stringBuffer.toString());
        }
    }

    void fireStartElement(String string, String string2, String string3, boolean bl) {
        if (this.sink != null) {
            this.sink.fireStartElement(string, string2, string3, bl);
        }
    }

    void fireEndElement(String string, String string2, String string3, boolean bl) {
        if (this.sink != null) {
            this.sink.fireEndElement(string, string2, string3, bl);
        }
    }

    void firePI(String string) {
        if (this.sink != null) {
            this.sink.firePI(string);
        }
    }

    void fireComment(String string) {
        if (this.sink != null) {
            this.sink.fireComment(string);
        }
    }

    void fireSpecialSection(String string, String string2) {
        if (this.sink != null) {
            this.sink.fireSpecialSection(string, string2);
        }
    }

    void fireMeta(String string) {
        if (this.sink != null) {
            this.sink.fireMeta(string);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null && iPWorksException != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }
}

