/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CJDKIndependent;
import ipworks.IPWorksException;
import ipworks.Udpport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

class CUDPPort
extends CBase {
    private static final int NOT_ACTIVE = 1;
    private static final int ACTIVE = 2;
    private int state = 1;
    private Udpport sink;
    private DatagramSocket socket = null;
    private DatagramPacket packet;
    private ReaderThread readerThread;
    private String remoteHost = "";
    private int remotePort = 0;
    private String localHost = "";
    private int localPort = 0;
    private int inBufferSize = 2048;
    private int outBufferSize = 2048;
    private boolean acceptData = true;
    private boolean useConnection = false;
    private boolean dontRoute = false;
    private int maxPacketSize = 2048;

    CUDPPort(Udpport udpport, Object object) {
        super(object);
        this.sink = udpport;
    }

    void do_Send(byte[] byArray) throws IPWorksException {
        this.setDataToSend(byArray);
    }

    int getTimeToLive() {
        return 0;
    }

    void setTimeToLive(int n) throws IPWorksException {
        throw new IPWorksException();
    }

    int getQOSFlags() {
        return 0;
    }

    void setQOSFlags(int n) throws IPWorksException {
        throw new IPWorksException();
    }

    void setActive(boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (bl) {
                if (this.state == 2) {
                    throw new IPWorksException(2104);
                }
                this.doActivate();
            } else if (this.state == 2) {
                this.doDisactivate();
            }
        }
    }

    boolean getActive() {
        return this.state == 2;
    }

    private void doActivate() throws IPWorksException {
        try {
            InetAddress inetAddress = this.localHost.length() == 0 ? InetAddress.getLocalHost() : InetAddress.getByName(this.localHost);
            InetAddress inetAddress2 = InetAddress.getByName(this.remoteHost);
            this.socket = new DatagramSocket(this.localPort, inetAddress);
            if (this.useConnection) {
                CJDKIndependent.cJDKSocketsIndependent.datagramSocketConnect(this.socket, inetAddress2, this.remotePort);
            }
            CJDKIndependent.cJDKSocketsIndependent.datagramSocketSetSendBufferSize(this.socket, this.outBufferSize);
            CJDKIndependent.cJDKSocketsIndependent.datagramSocketSetReceiveBufferSize(this.socket, this.inBufferSize);
            this.packet = new DatagramPacket(CBase.BYTE0, 0, inetAddress2, this.remotePort);
            this.readerThread = new ReaderThread();
            this.readerThread.start();
            this.state = 2;
        }
        catch (IOException iOException) {
            this.doDisactivate();
            throw new IPWorksException(iOException);
        }
    }

    private void doDisactivate() {
        this.state = 1;
        if (this.readerThread != null) {
            this.readerThread.terminate();
            this.readerThread = null;
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        this.packet = null;
    }

    void setUseConnection(boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                throw new IPWorksException(117);
            }
            this.useConnection = bl;
        }
    }

    boolean getUseConnection() {
        return this.useConnection;
    }

    void setAcceptData(boolean bl) {
        Object object = this.syncObj;
        synchronized (object) {
            this.acceptData = bl;
            this.syncObj.notifyAll();
        }
    }

    boolean getAcceptData() {
        return this.acceptData;
    }

    void setMaxPacketSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                throw new IPWorksException(2112);
            }
            this.maxPacketSize = n;
        }
    }

    int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    void setDataToSend(byte[] byArray, int n, int n2) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (byArray == null) {
                return;
            }
            if (this.state == 2) {
                try {
                    CJDKIndependent.cJDKSocketsIndependent.setData(this.packet, byArray, n, n2);
                    this.socket.send(this.packet);
                }
                catch (IOException iOException) {
                    throw new IPWorksException(iOException);
                }
            } else {
                throw new IPWorksException(109);
            }
        }
    }

    void setDataToSend(byte[] byArray) throws IPWorksException {
        this.setDataToSend(byArray, 0, byArray.length);
    }

    void setDontRoute(boolean bl) {
        Object object = this.syncObj;
        synchronized (object) {
            this.dontRoute = bl;
        }
    }

    boolean getDontRoute() {
        return this.dontRoute;
    }

    boolean getShareLocalPort() {
        return false;
    }

    void setShareLocalPort(boolean bl) throws IPWorksException {
        throw new IPWorksException();
    }

    void setInBufferSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                try {
                    CJDKIndependent.cJDKSocketsIndependent.datagramSocketSetReceiveBufferSize(this.socket, n);
                }
                catch (SocketException socketException) {
                    throw new IPWorksException(socketException);
                }
            }
            this.inBufferSize = n;
        }
    }

    int getInBufferSize() {
        return this.inBufferSize;
    }

    void setOutBufferSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                try {
                    CJDKIndependent.cJDKSocketsIndependent.datagramSocketSetSendBufferSize(this.socket, n);
                }
                catch (SocketException socketException) {
                    throw new IPWorksException(socketException);
                }
            }
            this.outBufferSize = n;
        }
    }

    int getOutBufferSize() {
        return this.outBufferSize;
    }

    void setLocalHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                throw new IPWorksException(2119);
            }
            this.localHost = string != null ? string : "";
        }
    }

    String getLocalHost() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                String string = this.socket.getLocalAddress().getHostAddress();
                return string;
            }
            String string = this.localHost;
            return string;
        }
    }

    void setLocalPort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                throw new IPWorksException(2106);
            }
            this.localPort = n;
        }
    }

    int getLocalPort() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                int n = this.socket.getLocalPort();
                return n;
            }
            int n = this.localPort;
            return n;
        }
    }

    void setRemoteHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (string == null) {
                string = "";
            }
            if (this.state == 2) {
                if (this.useConnection) {
                    throw new IPWorksException(114);
                }
                try {
                    this.packet.setAddress(InetAddress.getByName(string));
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IPWorksException(unknownHostException);
                }
            }
            this.remoteHost = string;
        }
    }

    String getRemoteHost() {
        return this.remoteHost;
    }

    void setRemotePort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                if (this.useConnection) {
                    throw new IPWorksException(115);
                }
                this.packet.setPort(n);
            }
            this.remotePort = n;
        }
    }

    int getRemotePort() {
        return this.remotePort;
    }

    void fireDataIn(byte[] byArray, String string, int n) {
        if (this.sink != null) {
            this.sink.fireDataIn(byArray, string, n);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    private class ReaderThread
    extends Thread {
        private boolean running = true;

        private ReaderThread() {
        }

        void terminate() {
            this.running = false;
            CUDPPort.this.syncObj.notifyAll();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            DatagramSocket datagramSocket;
            DatagramPacket datagramPacket;
            int n;
            Object object = CUDPPort.this.syncObj;
            synchronized (object) {
                if (!this.running) {
                    return;
                }
                n = CUDPPort.this.inBufferSize;
                datagramPacket = new DatagramPacket(new byte[CUDPPort.this.inBufferSize], CUDPPort.this.inBufferSize);
                datagramSocket = CUDPPort.this.socket;
            }
            while (true) {
                Object object2;
                try {
                    while (true) {
                        Object object3 = CUDPPort.this.syncObj;
                        synchronized (object3) {
                            if (CUDPPort.this.inBufferSize != datagramPacket.getLength()) {
                                if (CUDPPort.this.inBufferSize <= n) {
                                    datagramPacket.setLength(CUDPPort.this.inBufferSize);
                                } else {
                                    datagramPacket.setData(new byte[CUDPPort.this.inBufferSize]);
                                    n = CUDPPort.this.inBufferSize;
                                }
                            }
                        }
                        datagramSocket.receive(datagramPacket);
                        object2 = new byte[datagramPacket.getLength()];
                        System.arraycopy(datagramPacket.getData(), 0, object2, 0, ((Object)object2).length);
                        Object object4 = CUDPPort.this.syncObj;
                        synchronized (object4) {
                            while (true) {
                                if (!this.running || CUDPPort.this.acceptData) {
                                    if (this.running) break;
                                    return;
                                }
                                try {
                                    CUDPPort.this.syncObj.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            CUDPPort.this.fireDataIn((byte[])object2, datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
                        }
                    }
                }
                catch (IOException iOException) {
                    object2 = CUDPPort.this.syncObj;
                    synchronized (object2) {
                        if (!this.running) {
                            return;
                        }
                        CUDPPort.this.fireError(new IPWorksException(iOException));
                    }
                    continue;
                }
                break;
            }
        }
    }
}

