/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CIPPMsg;
import ipworks.IPWorksException;
import ipworks.Snpp;

class CSNPP
extends CIPPMsg {
    static final int idle = 0;
    static final int connect = 1;
    static final int disconnect = 2;
    static final int send = 3;
    static final int resetHeaders = 4;
    static final int actionCommand = 5;
    static final int snppDirectClient = 0;
    static final int snppDirectServer = 1;
    static final int snppDirectInfo = 2;
    private int action = 0;
    private static final int defaultPort = 444;
    private static final String snppEOL = "\r\n";
    private String command;
    private String callerId;
    private String message;
    private String pagerId;
    private Snpp sink = null;

    CSNPP(Snpp snpp, Object object) {
        super(null, object);
        this.sink = snpp;
        this.setEOL(snppEOL.getBytes());
        try {
            this.setRemotePort(444);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        this.doActionResetHeaders();
    }

    void do_Connect() throws IPWorksException {
        this.setAction(1);
    }

    void do_Disconnect() throws IPWorksException {
        this.setAction(2);
    }

    void do_Reset() throws IPWorksException {
        this.setAction(4);
    }

    void do_Send() throws IPWorksException {
        this.setAction(3);
    }

    void sendSNPPCommand(String string) throws IPWorksException {
        if (string != null) {
            this.firePITrail(0, string);
        }
        this.sendCommand(string, snppEOL);
        boolean bl = false;
        while (true) {
            this.firePITrail(1, this.lastReply);
            int n = this.lastReply.length();
            if (n > 0) {
                switch (this.lastReply.charAt(0)) {
                    case '1': {
                        break;
                    }
                    case '2': {
                        if (this.lastReply.startsWith("214")) break;
                    }
                    case '3': 
                    case '8': 
                    case '9': {
                        return;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                throw new IPWorksException(321, this.lastReply);
            }
            this.waitForReply();
        }
    }

    private void doActionSendPage() throws IPWorksException {
        if (this.pagerId.length() == 0) {
            throw new IPWorksException(324);
        }
        this.sendSNPPCommand("PAGE " + this.pagerId);
        if (this.message.indexOf(10) != -1) {
            this.sendSNPPCommand("DATA");
            this.sendSNPPCommand(this.message + "\r\n.");
        } else {
            this.sendSNPPCommand("MESS " + this.message);
        }
        this.sendSNPPCommand("SEND");
    }

    private void doActionResetHeaders() {
        this.pagerId = "";
        this.message = "";
        this.callerId = "";
        this.command = "";
    }

    private void doActionConnect() throws IPWorksException {
        if (!this.getConnected()) {
            this.firePITrail(2, "Connecting to SNPP server.");
            this.blockConnect();
            try {
                this.sendSNPPCommand(null);
                if (this.callerId.length() > 0) {
                    this.sendSNPPCommand("CALL " + this.callerId);
                }
            }
            catch (IPWorksException iPWorksException) {
                try {
                    this.doActionDisconnect();
                }
                catch (IPWorksException iPWorksException2) {
                    // empty catch block
                }
                throw iPWorksException;
            }
        }
    }

    private void doActionDisconnect() throws IPWorksException {
        if (this.getConnected()) {
            try {
                this.firePITrail(2, "Forcing disconnection from SNPP server.");
                this.sendSNPPCommand("QUIT");
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.setConnected(false);
                throw throwable;
            }
            this.setConnected(false);
            {
            }
        }
    }

    void setAction(int n) throws IPWorksException {
        this.setSNPPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setSNPPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(323);
            }
            this.restart();
            this.action = n;
        }
        try {
            switch (n) {
                case 3: {
                    this.doActionConnect();
                    this.doActionSendPage();
                    break;
                }
                case 1: {
                    this.doActionConnect();
                    break;
                }
                case 2: {
                    this.doActionDisconnect();
                    break;
                }
                case 4: {
                    this.doActionResetHeaders();
                    break;
                }
                case 5: {
                    if (this.command.length() <= 0) break;
                    this.sendSNPPCommand(this.command);
                }
            }
            Object var5_5 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Object object3 = this.syncObj;
            synchronized (object3) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var5_6 = null;
                Object object4 = this.syncObj;
                synchronized (object4) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
    }

    int getAction() {
        return this.action;
    }

    String getServerName() {
        return this.getRemoteHost();
    }

    void setServerName(String string) throws IPWorksException {
        this.setRemoteHost(string);
    }

    int getServerPort() {
        return this.getRemotePort();
    }

    void setServerPort(int n) throws IPWorksException {
        this.setRemotePort(n);
    }

    String getPagerId() {
        return this.pagerId;
    }

    void setPagerId(String string) {
        this.pagerId = string != null ? string : "";
    }

    String getMessage() {
        return this.message;
    }

    void setMessage(String string) {
        this.message = string != null ? string : "";
    }

    String getCallerId() {
        return this.callerId;
    }

    void setCallerId(String string) {
        this.callerId = string != null ? string : "";
    }

    void setCommand(String string) throws IPWorksException {
        this.command = string != null ? string : "";
        this.setSNPPAction(5);
    }

    void fireConnected(IPWorksException iPWorksException) {
        super.fireConnected(iPWorksException);
        if (iPWorksException == null) {
            this.firePITrail(2, "Connected.");
        } else {
            this.fireError(new IPWorksException(322));
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        super.fireDisconnected(iPWorksException);
        if (iPWorksException == null) {
            this.firePITrail(2, "Disonnected.");
        } else {
            this.fireError(new IPWorksException(322));
        }
    }

    void firePITrail(int n, String string) {
        if (this.sink != null) {
            this.sink.firePITrail(n, string);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }
}

