/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CUDPPort;
import ipworks.IPWorksException;
import ipworks.Netclock;
import java.util.Date;

class CNetClock
extends CUDPPort {
    private static final long SHIFT_1900_1970 = 2208970800000L;
    private static final long SHIFT_GMT_EST = 18000000L;
    private static final long SHIFT = 2208988800000L;
    private static final int PORT = 37;
    private static final String SERVER = "clock.psu.edu";
    private static final int IDLE = 0;
    private static final int GET_TIME = 1;
    private static final int GETANDSET_TIME = 2;
    private int action = 0;
    private String time = "";
    private String localTime = "";
    private long starttime;
    private Netclock sink;

    CNetClock(Netclock netclock, Object object) {
        super(null, object);
        this.sink = netclock;
        try {
            this.setRemotePort(37);
            this.setRemoteHost(SERVER);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
    }

    void do_GetAndSetTime() throws IPWorksException {
        this.setAction(2);
    }

    void do_GetTime() throws IPWorksException {
        this.setAction(1);
    }

    int getAction() {
        return this.action;
    }

    private void restart() throws IPWorksException {
        this.localTime = "";
        this.time = "";
        this.starttime = this.timeout == 0 ? 0L : System.currentTimeMillis();
    }

    private void interrupt() {
        try {
            this.setActive(false);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        Object object = this.syncObj;
        synchronized (object) {
            this.localTime = "";
            this.time = "";
            this.syncObj.notifyAll();
        }
    }

    void setAction(int n) throws IPWorksException {
        this.setNCAction(n);
    }

    private void setNCAction(int n) throws IPWorksException {
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.action != 0) {
                throw new IPWorksException(174);
            }
            this.restart();
            this.action = n;
        }
        try {
            this.setUseConnection(true);
            this.setActive(true);
            this.setDataToSend("time?".getBytes());
            Object object2 = this.syncObj;
            synchronized (object2) {
                while (this.time.length() == 0) {
                    this.waitWhileProcessingEvents(this.starttime);
                }
            }
            Object var6_6 = null;
            this.action = 0;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.action = 0;
            this.setActive(false);
            throw throwable;
        }
        this.setActive(false);
    }

    String getLocalTime() {
        return this.localTime;
    }

    String getServerTime() {
        return this.time;
    }

    int getTimePort() {
        return this.getRemotePort();
    }

    void setTimePort(int n) throws IPWorksException {
        this.setRemotePort(n);
    }

    String getTimeServer() {
        return this.getRemoteHost();
    }

    void setTimeServer(String string) throws IPWorksException {
        this.setRemoteHost(string);
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    void fireDataIn(byte[] byArray, String string, int n) {
        try {
            this.setActive(false);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        long l = (((long)byArray[0] & 0xFFL) << 24) + (((long)byArray[1] & 0xFFL) << 16) + (((long)byArray[2] & 0xFFL) << 8) + ((long)byArray[3] & 0xFFL);
        Date date = new Date(l * 1000L - 2208988800000L);
        this.time = date.toGMTString();
        this.localTime = date.toString();
    }
}

