/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.IPWorksException;
import ipworks.Ipinfo;
import java.io.IOException;
import java.net.InetAddress;

class CIPInfo {
    private static final int maxRequests = 1000;
    private static final int resolveHostAddress = 1;
    private static final int resolveHostName = 2;
    private int requestId = 0;
    int pendingRequests = 0;
    CResolverThread[] request = new CResolverThread[1000];
    protected Object syncObj;
    protected String hostName = "";
    protected String hostAddress = "";
    protected String otherAddresses = "";
    private Ipinfo sink = null;

    CIPInfo(Ipinfo ipinfo, Object object) {
        this.sink = ipinfo;
        this.syncObj = object;
    }

    String do_ResolveAddress(String string) throws IPWorksException {
        this.setHostAddress(string);
        return this.hostName;
    }

    String do_ResolveName(String string) throws IPWorksException {
        this.setHostName(string);
        return this.hostAddress;
    }

    private void resolve(String string, int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingRequests == 1000) {
                throw new IPWorksException(131);
            }
            int n2 = this.requestId;
            while (this.request[n2] != null) {
                if (++n2 != 1000) continue;
                n2 = 0;
            }
            this.requestId = n2;
            ++this.pendingRequests;
            this.request[this.requestId] = new CResolverThread(string, n, this.requestId);
        }
        this.request[this.requestId].start();
    }

    void setHostAddress(String string) throws IPWorksException {
        this.resolve(string, 1);
    }

    String getHostAddress() {
        Object object = this.syncObj;
        synchronized (object) {
            String string = this.hostAddress;
            return string;
        }
    }

    String getHostAliases() {
        return "";
    }

    void setHostName(String string) throws IPWorksException {
        this.resolve(string, 2);
    }

    String getHostName() {
        Object object = this.syncObj;
        synchronized (object) {
            String string = this.hostName;
            return string;
        }
    }

    String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    String getOtherAddresses() {
        Object object = this.syncObj;
        synchronized (object) {
            String string = this.otherAddresses;
            return string;
        }
    }

    void setPendingRequests(int n) {
        if (n < 0) {
            n = 0;
        }
        Object object = this.syncObj;
        synchronized (object) {
            int n2 = this.requestId;
            while (this.pendingRequests > n) {
                if (++n2 == 1000) {
                    n2 = 0;
                }
                if (this.request[n2] == null) continue;
                this.request[n2].terminate();
                this.request[n2] = null;
                --this.pendingRequests;
            }
        }
    }

    int getPendingRequests() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.pendingRequests;
            return n;
        }
    }

    int getRequestId() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.requestId;
            return n;
        }
    }

    String getServiceAliases() {
        return "";
    }

    String getServiceName() {
        return "";
    }

    void setServiceName(String string) throws IPWorksException {
        throw new IPWorksException(999);
    }

    int getServicePort() {
        return 0;
    }

    void setServicePort(int n) throws IPWorksException {
        throw new IPWorksException(999);
    }

    String getServiceProtocol() {
        return "";
    }

    void setServiceProtocol(String string) throws IPWorksException {
        throw new IPWorksException(999);
    }

    void fireRequestComplete(int n, IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireRequestComplete(n, iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireRequestComplete(n, 0, "OK");
            }
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireError(0, "OK");
            }
        }
    }

    class CResolverThread
    extends Thread {
        private String whatString;
        private int whatInt;
        private int rId;
        private boolean running = true;

        CResolverThread(String string, int n, int n2) {
            this.whatString = string;
            this.whatInt = n;
            this.rId = n2;
        }

        void terminate() {
            this.running = false;
        }

        public void run() {
            IPWorksException iPWorksException = null;
            switch (this.whatInt) {
                case 1: {
                    String string = "";
                    try {
                        string = InetAddress.getByName(this.whatString).getHostName();
                    }
                    catch (IOException iOException) {
                        iPWorksException = new IPWorksException(iOException);
                    }
                    Object object = CIPInfo.this.syncObj;
                    synchronized (object) {
                        if (this.running) {
                            CIPInfo.this.hostName = string;
                            --CIPInfo.this.pendingRequests;
                            CIPInfo.this.request[this.rId] = null;
                            if (iPWorksException != null) {
                                CIPInfo.this.fireError(iPWorksException);
                            }
                            CIPInfo.this.fireRequestComplete(this.rId, iPWorksException);
                        }
                        break;
                    }
                }
                case 2: {
                    Object object;
                    String string = "";
                    String string2 = "";
                    try {
                        object = InetAddress.getAllByName(this.whatString);
                        int n = ((InetAddress[])object).length;
                        StringBuffer stringBuffer = new StringBuffer();
                        int n2 = 1;
                        while (n2 < n) {
                            stringBuffer.append(object[n2].getHostAddress()).append(" ");
                            ++n2;
                        }
                        string = stringBuffer.toString();
                        string2 = n > 0 ? object[0].getHostAddress() : "";
                    }
                    catch (IOException iOException) {
                        iPWorksException = new IPWorksException(iOException);
                    }
                    object = CIPInfo.this.syncObj;
                    synchronized (object) {
                        if (this.running) {
                            CIPInfo.this.hostAddress = string2;
                            CIPInfo.this.otherAddresses = string;
                            --CIPInfo.this.pendingRequests;
                            CIPInfo.this.request[this.rId] = null;
                            if (iPWorksException != null) {
                                CIPInfo.this.fireError(iPWorksException);
                            }
                            CIPInfo.this.fireRequestComplete(this.rId, iPWorksException);
                        }
                        break;
                    }
                }
            }
        }
    }
}

