/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CIPPMsg;
import ipworks.IPWorksException;
import ipworks.Imap;
import ipworks.ImapTokenizer;
import java.util.Vector;

class CIMAP
extends CIPPMsg {
    private static final int a_Idle = 0;
    private static final int a_Noop = 1;
    private static final int a_Connect = 2;
    private static final int a_Disconnect = 3;
    private static final int a_SelectMailbox = 4;
    private static final int a_ExamineMailbox = 5;
    private static final int a_CreateMailbox = 6;
    private static final int a_DeleteMailbox = 7;
    private static final int a_RenameMailbox = 8;
    private static final int a_SearchMailbox = 9;
    private static final int a_AppendToMailbox = 10;
    private static final int a_CopyToMailbox = 11;
    private static final int a_CheckMailbox = 12;
    private static final int a_ExpungeMailbox = 13;
    private static final int a_CloseMailbox = 14;
    private static final int a_ListMailboxes = 15;
    private static final int a_ListSubscribedMailboxes = 16;
    private static final int a_SubscribeMailbox = 17;
    private static final int a_UnsubscribeMailbox = 18;
    private static final int a_GetMessageInfo = 19;
    private static final int a_GetMessageHeaders = 20;
    private static final int a_GetMessageText = 21;
    private static final int a_GetMessagePart = 22;
    private static final int a_ResetMessageFlags = 23;
    private static final int a_SetMessageFlags = 24;
    private static final int a_UnsetMessageFlags = 25;
    private static final int a_CommandAction = 26;
    private static final int a_SearchResults = 27;
    private static final int IMAPDIRECT_CLIENT = 0;
    private static final int IMAPDIRECT_SERVER = 1;
    private static final int IMAPDIRECT_INFO = 2;
    private static final int NR_IMAP_DIRECTIONS = 3;
    private static final int defaultPort = 143;
    private static final String imapEol = "\r\n";
    static final String openParTag = "(";
    static final String closeParTag = ")";
    private int action = 0;
    private int subAction = 0;
    private String command = "";
    private String mailbox = "Inbox";
    private String mailboxFlags = "";
    private Vector messageTo = new Vector();
    private Vector messageCc = new Vector();
    private Vector messageBCc = new Vector();
    private String messageContentEncoding = "";
    private String messageContentType = "";
    private int messageCount = 0;
    private String messageDate = "";
    private String messageDeliveryTime = "";
    private String messageFlags = "";
    private String messageFrom = "";
    private String messageHeaders = "";
    private String messageId = "";
    private String messageInReplyTo = "";
    private String messageNetId = "";
    private String messageReplyTo = "";
    private String messageSender = "";
    private String messageSet = "";
    private int messageSize = 0;
    private String messageSubject = "";
    private String messageText = "";
    private String newMailbox = "";
    private String partId = "";
    private String password = "";
    private int recentMessageCount = 0;
    private String searchCriteria = "";
    private boolean UIDMode = false;
    private boolean peekMode = false;
    private String user = "";
    private String searchResults;
    private boolean didSelect = false;
    private int startByte;
    private int endByte;
    private int refCount = 1;
    Imap sink = null;

    CIMAP(Imap imap, Object object) {
        super(null, object);
        this.sink = imap;
        this.setEOL(imapEol.getBytes());
        try {
            this.setInBufferSize(20000);
            this.setMaxLineLength(20000);
            this.setRemotePort(143);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
    }

    void do_AppendToMailbox() throws IPWorksException {
        this.setAction(10);
    }

    void do_CheckMailbox() throws IPWorksException {
        this.setAction(12);
    }

    void do_CloseMailbox() throws IPWorksException {
        this.setAction(14);
    }

    void do_Connect() throws IPWorksException {
        this.setAction(2);
    }

    void do_CopyToMailbox() throws IPWorksException {
        this.setAction(11);
    }

    void do_CreateMailbox() throws IPWorksException {
        this.setAction(6);
    }

    void do_DeleteMailbox() throws IPWorksException {
        this.setAction(7);
    }

    void do_Disconnect() throws IPWorksException {
        this.setAction(3);
    }

    void do_ExamineMailbox() throws IPWorksException {
        this.setAction(5);
    }

    void do_ExpungeMailbox() throws IPWorksException {
        this.setAction(13);
    }

    void do_FetchMessageHeaders() throws IPWorksException {
        this.setAction(20);
    }

    void do_FetchMessageInfo() throws IPWorksException {
        this.setAction(19);
    }

    void do_FetchMessagePart() throws IPWorksException {
        this.setAction(22);
    }

    void do_FetchMessageText() throws IPWorksException {
        this.setAction(21);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_ListMailboxes() throws IPWorksException {
        this.setAction(15);
    }

    void do_ListSubscribedMailboxes() throws IPWorksException {
        this.setAction(16);
    }

    void do_Noop() throws IPWorksException {
        this.setAction(1);
    }

    void do_RenameMailbox() throws IPWorksException {
        this.setAction(8);
    }

    void do_ResetMessageFlags() throws IPWorksException {
        this.setAction(23);
    }

    void do_SearchMailbox() throws IPWorksException {
        this.setAction(9);
    }

    void do_SelectMailbox() throws IPWorksException {
        this.setAction(4);
    }

    void do_AddMessageFlags(String string) throws IPWorksException {
        this.setAction(24);
    }

    void do_SubscribeMailbox() throws IPWorksException {
        this.setAction(17);
    }

    void do_UnsetMessageFlags() throws IPWorksException {
        this.setAction(25);
    }

    void do_UnsubscribeMailbox() throws IPWorksException {
        this.setAction(18);
    }

    boolean getPeekMode() {
        return this.peekMode;
    }

    void setPeekMode(boolean bl) throws IPWorksException {
        this.peekMode = bl;
    }

    int getAction() {
        return this.action;
    }

    void setStartByte(int n) throws IPWorksException {
        this.startByte = n;
    }

    int getStartByte() {
        return this.startByte;
    }

    void setEndByte(int n) throws IPWorksException {
        this.endByte = n;
    }

    int getEndByte() {
        return this.endByte;
    }

    void setCommand(String string) throws IPWorksException {
        this.command = string != null ? string : "";
    }

    String getMailbox() {
        return this.mailbox;
    }

    void setMailbox(String string) throws IPWorksException {
        this.mailbox = string != null ? string : "";
    }

    String getMailboxFlags() {
        return this.mailboxFlags;
    }

    int getMailPort() {
        return this.getRemotePort();
    }

    void setMailPort(int n) throws IPWorksException {
        this.setRemotePort(n);
    }

    String getMailServer() {
        return this.getRemoteHost();
    }

    void setMailServer(String string) throws IPWorksException {
        this.setRemoteHost(string);
    }

    String getMessageBCc(int n) {
        try {
            return (String)this.messageBCc.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    String getMessageCc(int n) {
        try {
            return (String)this.messageCc.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    String getMessageContentEncoding() {
        return this.messageContentEncoding;
    }

    String getMessageContentType() {
        return this.messageContentType;
    }

    int getMessageCount() {
        return this.messageCount;
    }

    String getMessageDate() {
        return this.messageDate;
    }

    String getMessageDeliveryTime() {
        return this.messageDeliveryTime;
    }

    String getMessageFlags() {
        return this.messageFlags;
    }

    void setMessageFlags(String string) throws IPWorksException {
        this.messageFlags = string != null ? string : "";
    }

    String getMessageFrom() {
        return this.messageFrom;
    }

    String getMessageHeaders() {
        return this.messageHeaders;
    }

    void setMessageHeaders(String string) throws IPWorksException {
        this.messageHeaders = string != null ? string : "";
    }

    String getMessageId() {
        return this.messageId;
    }

    String getMessageInReplyTo() {
        return this.messageInReplyTo;
    }

    String getMessageNetId() {
        return this.messageNetId;
    }

    String getMessageReplyTo() {
        return this.messageReplyTo;
    }

    String getMessageSender() {
        return this.messageSender;
    }

    String getMessageSet() {
        return this.messageSet;
    }

    void setMessageSet(String string) throws IPWorksException {
        this.messageSet = string != null ? string : "";
    }

    int getMessageSize() {
        return this.messageSize;
    }

    String getMessageSubject() {
        return this.messageSubject;
    }

    String getMessageText() {
        return this.messageText;
    }

    void setMessageText(String string) throws IPWorksException {
        this.messageText = string != null ? string : "";
    }

    String getMessageTo(int n) {
        try {
            return (String)this.messageTo.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    String getNewMailbox() {
        return this.newMailbox;
    }

    void setNewMailbox(String string) throws IPWorksException {
        this.newMailbox = string != null ? string : "";
    }

    String getPartId() {
        return this.partId;
    }

    void setPartId(String string) throws IPWorksException {
        this.partId = string != null ? string : "";
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String string) throws IPWorksException {
        this.password = string != null ? string : "";
    }

    int getRecentMessageCount() {
        return this.recentMessageCount;
    }

    String getSearchCriteria() {
        return this.searchCriteria;
    }

    void setSearchCriteria(String string) throws IPWorksException {
        this.searchCriteria = string != null ? string : "";
    }

    boolean getUIDMode() {
        return this.UIDMode;
    }

    void setUIDMode(boolean bl) throws IPWorksException {
        this.UIDMode = bl;
    }

    String getUser() {
        return this.user;
    }

    void setUser(String string) throws IPWorksException {
        this.user = string != null ? string : "";
    }

    protected void waitForReply() throws IPWorksException {
        super.waitForReply();
        if (!this.lastReply.endsWith("}")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.lastReply);
        while (this.lastReply.endsWith("}")) {
            int n = 0;
            int n2 = CIMAP.tryParseInt(this.lastReply.substring(this.lastReply.lastIndexOf(123) + 1, this.lastReply.length() - 1));
            while (n <= n2) {
                super.waitForReply();
                stringBuffer.append(imapEol);
                stringBuffer.append(this.lastReply);
                n += this.lastReply.length() + imapEol.length();
            }
        }
        this.lastReply = stringBuffer.toString();
    }

    static int tryParseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String getNameValue(String string) {
        ImapTokenizer imapTokenizer = new ImapTokenizer(string);
        while (imapTokenizer.hasMoreTokens()) {
            String string2 = imapTokenizer.nextToken();
            String string3 = imapTokenizer.nextToken();
            if (!string2.equalsIgnoreCase("NAME")) continue;
            return string3;
        }
        return "";
    }

    private void handleSelectMailbox() {
        ImapTokenizer imapTokenizer = new ImapTokenizer(this.lastReply);
        imapTokenizer.nextToken();
        String string = imapTokenizer.nextToken();
        String string2 = imapTokenizer.nextToken();
        if (string.equalsIgnoreCase("FLAGS")) {
            this.mailboxFlags = string2;
        } else if (string2.equalsIgnoreCase("EXISTS")) {
            this.messageCount = CIMAP.tryParseInt(string);
        } else if (string2.equalsIgnoreCase("RECENT")) {
            this.recentMessageCount = CIMAP.tryParseInt(string);
        }
    }

    private void handleMailboxList() {
        ImapTokenizer imapTokenizer = new ImapTokenizer(this.lastReply);
        imapTokenizer.nextToken();
        imapTokenizer.nextToken();
        String string = imapTokenizer.nextToken();
        String string2 = imapTokenizer.nextToken();
        String string3 = imapTokenizer.nextToken();
        this.fireMailboxList(string3, string2, string);
    }

    private String handleMessageAddress(String string) {
        ImapTokenizer imapTokenizer = new ImapTokenizer(string, true);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = imapTokenizer.nextToken();
        if (!string2.equalsIgnoreCase("NIL")) {
            stringBuffer.append(string2 + " ");
        }
        imapTokenizer.nextToken();
        stringBuffer.append("<" + imapTokenizer.nextToken() + "@" + imapTokenizer.nextToken() + ">");
        return stringBuffer.toString();
    }

    private String handleMessageAddressList(String string) {
        if (string.equalsIgnoreCase("NIL")) {
            return "";
        }
        ImapTokenizer imapTokenizer = new ImapTokenizer(string, true);
        String string2 = imapTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer(this.handleMessageAddress(string2));
        while ((string2 = imapTokenizer.nextToken()).length() > 0) {
            stringBuffer.append(", ").append(this.handleMessageAddress(string2));
        }
        return stringBuffer.toString();
    }

    private Vector handleMessageAddressListToVector(String string) {
        Vector<String> vector = new Vector<String>();
        if (string.equalsIgnoreCase("NIL")) {
            return vector;
        }
        ImapTokenizer imapTokenizer = new ImapTokenizer(string, true);
        String string2 = imapTokenizer.nextToken();
        vector.addElement(this.handleMessageAddress(string2));
        while ((string2 = imapTokenizer.nextToken()).length() > 0) {
            vector.addElement(this.handleMessageAddress(string2));
        }
        return vector;
    }

    private void handleMessageEnvelope(String string) {
        ImapTokenizer imapTokenizer = new ImapTokenizer(string, true);
        this.messageDate = imapTokenizer.nextToken();
        if (this.messageDate.equals("NIL")) {
            this.messageDate = "";
        }
        this.messageSubject = imapTokenizer.nextToken();
        if (this.messageSubject.equals("NIL")) {
            this.messageSubject = "";
        }
        this.messageFrom = this.handleMessageAddressList(imapTokenizer.nextToken());
        this.messageSender = this.handleMessageAddressList(imapTokenizer.nextToken());
        this.messageReplyTo = this.handleMessageAddressList(imapTokenizer.nextToken());
        this.messageTo = this.handleMessageAddressListToVector(imapTokenizer.nextToken());
        this.messageCc = this.handleMessageAddressListToVector(imapTokenizer.nextToken());
        this.messageBCc = this.handleMessageAddressListToVector(imapTokenizer.nextToken());
        this.messageInReplyTo = imapTokenizer.nextToken();
        if (this.messageInReplyTo.equals("NIL")) {
            this.messageInReplyTo = "";
        }
        this.messageNetId = imapTokenizer.nextToken();
        if (this.messageNetId.equals("NIL")) {
            this.messageNetId = "";
        }
    }

    private void handleMessageBody(String string, String string2, String string3) {
        ImapTokenizer imapTokenizer = new ImapTokenizer(string, true);
        String string4 = imapTokenizer.nextToken();
        if (string4.startsWith(openParTag)) {
            String string5 = imapTokenizer.lastToken();
            int n = 1;
            while (string4.startsWith(openParTag)) {
                String string6 = string2.length() != 0 ? string2 + "." : string2;
                this.handleMessageBody(string4, string6 + n++, string5);
                string4 = imapTokenizer.nextToken();
            }
            return;
        }
        String string7 = string4.toLowerCase() + '/' + imapTokenizer.nextToken().toLowerCase();
        String string8 = imapTokenizer.nextToken();
        imapTokenizer.nextToken();
        imapTokenizer.nextToken();
        String string9 = imapTokenizer.nextToken();
        int n = CIMAP.tryParseInt(imapTokenizer.nextToken());
        if (string7.equalsIgnoreCase("message/rfc822")) {
            this.fireMessagePart(string2, n, string7, "", string9, string8, string3);
            imapTokenizer.nextToken();
            String string10 = imapTokenizer.nextToken();
            if (string10.length() == 0) {
                return;
            }
            String string11 = string10.length() > 1 && string10.charAt(1) != openParTag.charAt(0) ? string2 + ".1" : string2;
            this.handleMessageBody(string10, string11, "");
            return;
        }
        String string12 = "";
        try {
            string12 = string8.substring(1, string8.length() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        String string13 = this.getNameValue(string12);
        this.fireMessagePart(string2, n, string7, string13, string9, string8, string3);
    }

    private void handleMessageInfo() {
        String string;
        this.messageHeaders = "";
        this.messageText = "";
        this.messageDeliveryTime = "";
        this.messageDate = "";
        this.messageReplyTo = "";
        this.messageSender = "";
        this.messageFrom = "";
        this.messageFlags = "";
        this.messageNetId = "";
        this.messageInReplyTo = "";
        this.messageId = "";
        this.messageContentEncoding = "";
        this.messageContentType = "";
        this.messageSubject = "";
        this.messageSize = 0;
        this.messageCc = new Vector();
        this.messageBCc = new Vector();
        this.messageTo = new Vector();
        ImapTokenizer imapTokenizer = new ImapTokenizer(this.lastReply);
        imapTokenizer.nextToken();
        this.messageId = imapTokenizer.nextToken();
        imapTokenizer.nextToken();
        imapTokenizer = new ImapTokenizer(imapTokenizer.nextToken(), true);
        while ((string = imapTokenizer.nextToken()).length() > 0) {
            String string2 = imapTokenizer.nextToken();
            if (this.UIDMode && string.equalsIgnoreCase("UID")) {
                this.messageId = string2;
                continue;
            }
            if (string.equalsIgnoreCase("FLAGS")) {
                this.messageFlags = string2.equals("NIL") ? "" : string2;
                continue;
            }
            if (string.equalsIgnoreCase("INTERNALDATE")) {
                this.messageDeliveryTime = string2.equals("NIL") ? "" : string2;
                continue;
            }
            if (string.equalsIgnoreCase("RFC822.SIZE")) {
                this.messageSize = CIMAP.tryParseInt(string2);
                continue;
            }
            if (string.equalsIgnoreCase("ENVELOPE")) {
                this.handleMessageEnvelope(string2);
                continue;
            }
            if (!string.equalsIgnoreCase("BODY") || this.subAction == 27) continue;
            this.handleMessageBody(string2, "", "");
        }
        this.fireMessageInfo(this.messageId, this.messageSubject, this.messageDate, this.messageFrom, this.messageFlags, this.messageSize);
    }

    private void handleMessageHeaders() {
        ImapTokenizer imapTokenizer = new ImapTokenizer(this.lastReply);
        imapTokenizer.nextToken();
        imapTokenizer.nextToken();
        imapTokenizer.nextToken();
        ImapTokenizer imapTokenizer2 = new ImapTokenizer(imapTokenizer.nextToken(), true);
        imapTokenizer2.nextToken();
        this.messageHeaders = imapTokenizer2.nextToken();
    }

    private void handleMessageText() {
        ImapTokenizer imapTokenizer = new ImapTokenizer(this.lastReply);
        imapTokenizer.nextToken();
        imapTokenizer.nextToken();
        imapTokenizer.nextToken();
        ImapTokenizer imapTokenizer2 = new ImapTokenizer(imapTokenizer.nextToken(), true);
        imapTokenizer2.nextToken();
        String string = imapTokenizer2.nextToken();
        this.messageText = "";
        this.fireStartTransfer();
        try {
            this.openLocalFile();
            this.writeToLocalFile(string.getBytes());
            this.writeToLocalFile(imapEol.getBytes());
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        this.messageText = string + imapEol;
        this.fireTransfer(this.messageText.length(), this.messageText);
        this.fireEndTransfer();
        this.closeLocalFile();
    }

    private void sendIMAPCommand(String string, String string2, String string3, String string4) throws IPWorksException {
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = Integer.toHexString(this.refCount++);
        stringBuffer.append(string5).append(' ');
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(" ").append(string2.length() > 0 ? string2 : "\"\"");
        }
        if (string3 != null) {
            stringBuffer.append(" ").append(string3.length() > 0 ? string3 : "\"\"");
        }
        if (string4 != null) {
            stringBuffer.append(" {").append(string4.length()).append("}");
        }
        this.firePITrail(0, stringBuffer.toString());
        this.sendCommand(stringBuffer.toString(), imapEol);
        if (string4 != null) {
            this.firePITrail(1, this.lastReply);
            this.firePITrail(0, string4);
            this.blockSend(string4);
            this.sendMessage(imapEol.getBytes());
        }
        while (true) {
            this.firePITrail(1, this.lastReply);
            if (this.lastReply.startsWith("*")) {
                switch (this.action) {
                    case 4: 
                    case 5: {
                        this.handleSelectMailbox();
                        break;
                    }
                    case 9: {
                        if (this.subAction == 27) {
                            this.handleMessageInfo();
                            break;
                        }
                        this.searchResults = this.lastReply;
                        break;
                    }
                    case 15: 
                    case 16: {
                        this.handleMailboxList();
                        break;
                    }
                    case 19: {
                        this.handleMessageInfo();
                        break;
                    }
                    case 20: {
                        this.handleMessageHeaders();
                        break;
                    }
                    case 21: 
                    case 22: {
                        this.handleMessageText();
                    }
                }
            } else if (this.lastReply.startsWith(string5)) {
                if (this.lastReply.startsWith(string5 + " OK ")) {
                    return;
                }
                throw new IPWorksException(311, this.lastReply);
            }
            this.waitForReply();
        }
    }

    private void sendIMAPCommand(String string) throws IPWorksException {
        this.sendIMAPCommand(string, null, null, null);
    }

    private void sendIMAPCommand(String string, String string2) throws IPWorksException {
        this.sendIMAPCommand(string, string2, null, null);
    }

    private void sendIMAPCommand(String string, String string2, String string3) throws IPWorksException {
        this.sendIMAPCommand(string, string2, string3, null);
    }

    void checkMailboxSelected() throws IPWorksException {
        if (!this.didSelect) {
            throw new IPWorksException(314);
        }
    }

    private void checkMessageSetSelected() throws IPWorksException {
        if (this.messageSet.length() == 0) {
            throw new IPWorksException(316);
        }
    }

    private String normalizeFlags(String string) {
        if (string.startsWith(openParTag)) {
            return string;
        }
        return openParTag + string + closeParTag;
    }

    void setAction(int n) throws IPWorksException {
        this.setIMAPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setIMAPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(312);
            }
            this.restart();
            if (!this.getConnected() && n != 2 && n != 3) {
                this.setIMAPAction(2);
            }
            this.action = n;
            this.subAction = 0;
        }
        String string = null;
        try {
            switch (n) {
                case 1: {
                    this.sendIMAPCommand("NOOP");
                    break;
                }
                case 2: {
                    if (!this.getConnected()) {
                        this.firePITrail(2, "Connecting to IMAP server.");
                        this.blockConnect();
                        this.waitForReply();
                        this.firePITrail(1, this.lastReply);
                    }
                    this.sendIMAPCommand("LOGIN", this.user, this.password);
                    break;
                }
                case 3: {
                    if (this.getConnected()) {
                        this.sendIMAPCommand("LOGOUT");
                        this.firePITrail(2, "Forcing disconnection from IMAP server.");
                        this.setConnected(false);
                    }
                    break;
                }
                case 4: {
                    this.mailboxFlags = "";
                    this.recentMessageCount = 0;
                    this.messageCount = 0;
                    this.sendIMAPCommand("SELECT", this.mailbox);
                    this.didSelect = true;
                    break;
                }
                case 5: {
                    this.mailboxFlags = "";
                    this.recentMessageCount = 0;
                    this.messageCount = 0;
                    this.sendIMAPCommand("EXAMINE", this.mailbox);
                    this.didSelect = true;
                    break;
                }
                case 6: {
                    this.sendIMAPCommand("CREATE", this.mailbox);
                    break;
                }
                case 7: {
                    this.sendIMAPCommand("DELETE", this.mailbox);
                    break;
                }
                case 8: {
                    this.sendIMAPCommand("RENAME", this.mailbox, this.newMailbox);
                    break;
                }
                case 9: {
                    String string2;
                    this.checkMailboxSelected();
                    this.searchResults = "";
                    this.sendIMAPCommand(this.UIDMode ? "UID SEARCH" : "SEARCH", this.searchCriteria);
                    ImapTokenizer imapTokenizer = new ImapTokenizer(this.searchResults);
                    imapTokenizer.nextToken();
                    imapTokenizer.nextToken();
                    this.subAction = 27;
                    String string3 = this.UIDMode ? "UID FETCH" : "FETCH";
                    while ((string2 = imapTokenizer.nextToken()).length() > 0) {
                        this.sendIMAPCommand(string3, string2, "FULL");
                    }
                    break;
                }
                case 10: {
                    this.checkMailboxSelected();
                    if (this.messageFlags.length() > 0) {
                        string = this.normalizeFlags(this.messageFlags);
                    }
                    this.sendIMAPCommand("APPEND", this.mailbox, string, this.messageText);
                    break;
                }
                case 11: {
                    this.checkMailboxSelected();
                    this.checkMessageSetSelected();
                    this.sendIMAPCommand(this.UIDMode ? "UID COPY" : "COPY", this.messageSet, this.mailbox);
                    break;
                }
                case 12: {
                    this.checkMailboxSelected();
                    this.sendIMAPCommand("CHECK");
                    break;
                }
                case 13: {
                    this.checkMailboxSelected();
                    this.sendIMAPCommand("EXPUNGE");
                    break;
                }
                case 14: {
                    this.checkMailboxSelected();
                    this.sendIMAPCommand("CLOSE");
                    break;
                }
                case 15: {
                    this.sendIMAPCommand("LIST \"\"", this.mailbox);
                    break;
                }
                case 16: {
                    this.sendIMAPCommand("LSUB \"\"", this.mailbox);
                    break;
                }
                case 17: {
                    this.sendIMAPCommand("SUBSCRIBE", this.mailbox);
                    break;
                }
                case 18: {
                    this.sendIMAPCommand("UNSUBSCRIBE", this.mailbox);
                    break;
                }
                case 19: {
                    this.checkMailboxSelected();
                    this.checkMessageSetSelected();
                    String string4 = this.UIDMode ? "UID FETCH" : "FETCH";
                    this.sendIMAPCommand(string4, this.messageSet, "FULL");
                    break;
                }
                case 20: {
                    this.checkMailboxSelected();
                    this.checkMessageSetSelected();
                    String string5 = this.UIDMode ? "UID FETCH" : "FETCH";
                    this.sendIMAPCommand(string5, this.messageSet, this.peekMode ? "BODY.PEEK[HEADER]" : "RFC822.HEADER");
                    break;
                }
                case 21: {
                    this.checkMailboxSelected();
                    this.checkMessageSetSelected();
                    String string6 = this.UIDMode ? "UID FETCH" : "FETCH";
                    this.sendIMAPCommand(string6, this.messageSet, this.peekMode ? "BODY.PEEK[TEXT]" : "RFC822.TEXT");
                    break;
                }
                case 22: {
                    this.checkMailboxSelected();
                    if (this.partId.length() == 0 || this.endByte < this.startByte) {
                        throw new IPWorksException(315);
                    }
                    String string7 = this.UIDMode ? "UID FETCH" : "FETCH";
                    String string8 = "BODY" + (this.peekMode ? ".PEEK" : "") + "[" + this.partId + "]";
                    String string9 = "";
                    if (this.startByte > 0 || this.endByte > 0) {
                        string9 = "<" + (this.startByte == 0 ? 0 : this.startByte - 1) + "." + (this.endByte > 0 ? this.endByte - this.startByte + 1 : 0);
                    }
                    this.sendIMAPCommand(string7, this.messageSet, string8 + string9);
                    break;
                }
                case 23: {
                    this.checkMailboxSelected();
                    this.checkMessageSetSelected();
                    string = "FLAGS " + this.normalizeFlags(this.messageFlags);
                    this.sendIMAPCommand(this.UIDMode ? "UID STORE" : "STORE", this.messageSet, string);
                    break;
                }
                case 24: {
                    this.checkMailboxSelected();
                    this.checkMessageSetSelected();
                    string = "+FLAGS " + this.normalizeFlags(this.messageFlags);
                    this.sendIMAPCommand(this.UIDMode ? "UID STORE" : "STORE", this.messageSet, string);
                    break;
                }
                case 25: {
                    this.checkMailboxSelected();
                    this.checkMessageSetSelected();
                    string = "-FLAGS " + this.normalizeFlags(this.messageFlags);
                    this.sendIMAPCommand(this.UIDMode ? "UID STORE" : "STORE", this.messageSet, string);
                    break;
                }
                case 26: {
                    this.sendIMAPCommand(this.command);
                    break;
                }
                default: {
                    throw new IPWorksException(304);
                }
            }
            Object var11_15 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            Object object3 = this.syncObj;
            synchronized (object3) {
                this.action = 0;
                this.subAction = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            this.subAction = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var11_16 = null;
                Object object4 = this.syncObj;
                synchronized (object4) {
                    this.action = 0;
                    this.subAction = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
    }

    void firePITrail(int n, String string) {
        if (this.sink != null) {
            this.sink.firePITrail(n, string);
        }
    }

    void fireMailboxList(String string, String string2, String string3) {
        if (this.sink != null) {
            this.sink.fireMailboxList(string, string2, string3);
        }
    }

    void fireMessageInfo(String string, String string2, String string3, String string4, String string5, int n) {
        if (this.sink != null) {
            this.sink.fireMessageInfo(string, string2, string3, string4, string5, n);
        }
    }

    void fireMessagePart(String string, int n, String string2, String string3, String string4, String string5, String string6) {
        if (this.sink != null) {
            this.sink.fireMessagePart(string, n, string2, string3, string4, string5, string6);
        }
    }

    void fireStartTransfer() {
        if (this.sink != null) {
            this.sink.fireStartTransfer();
        }
    }

    void fireTransfer(int n, String string) {
        if (this.sink != null) {
            this.sink.fireTransfer(n, string);
        }
    }

    void fireEndTransfer() {
        if (this.sink != null) {
            this.sink.fireEndTransfer();
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }
}

