/*
 * Decompiled with CFR 0.152.
 */
package de.mbenning.weather.wunderground.impl;

import de.mbenning.weather.wunderground.api.domain.DataColumnDay;
import de.mbenning.weather.wunderground.api.domain.DataSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDataReader {
    private static final String SEPARATOR = ",";
    private static final String ENCODING = "UTF-8";
    private File file = null;
    private long currentLine = 1L;
    private String filePath = null;
    private Scanner fileScanner = null;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Scanner getFileScanner() {
        return this.fileScanner;
    }

    public void setFileScanner(Scanner fileScanner) {
        this.fileScanner = fileScanner;
    }

    public FileDataReader(String filePath) throws FileNotFoundException {
        this.file = new File(filePath);
        if (this.file != null) {
            this.init();
        }
    }

    public FileDataReader(File file) throws FileNotFoundException {
        this.file = file;
        if (this.file != null) {
            this.init();
        }
    }

    public void init() throws FileNotFoundException {
        if (this.fileScanner == null && this.file != null) {
            this.fileScanner = new Scanner(this.file);
            this.fileScanner.nextLine();
        }
    }

    public String getNextLine() throws FileNotFoundException {
        this.init();
        if (this.fileScanner.hasNext()) {
            ++this.currentLine;
            return this.fileScanner.nextLine();
        }
        return null;
    }

    public String[] nextDataColumns() throws FileNotFoundException {
        return this.getNextLine().split(SEPARATOR);
    }

    public DataSet nextDataSet() throws FileNotFoundException, ParseException, UnsupportedEncodingException {
        DataSet dataSet = new DataSet();
        String[] columns = this.nextDataColumns();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataSet.setDateTime(sdf.parse(columns[DataColumnDay.TIME.getIndex()]));
        dataSet.setTemperature(Double.valueOf(columns[DataColumnDay.TEMPERATURE.getIndex()]));
        dataSet.setDewPoint(Double.valueOf(columns[DataColumnDay.DEWPOINT.getIndex()]));
        dataSet.setPressurehPa(Double.valueOf(columns[DataColumnDay.PRESSURE.getIndex()]));
        dataSet.setWindDirection(new String(columns[DataColumnDay.WIND_DIRECTION.getIndex()].getBytes(), ENCODING));
        dataSet.setWindDirectionDegrees(Double.valueOf(columns[DataColumnDay.WIND_DIRECTION_DEGREES.getIndex()]));
        dataSet.setWindSpeedKmh(Double.valueOf(columns[DataColumnDay.WINDSPEED_KMH.getIndex()]));
        dataSet.setHumidity(DataColumnDay.HUMIDITY.getIndex());
        dataSet.setRainRateHourlyMm(Double.valueOf(columns[DataColumnDay.RAINRATE_HOURLY_MM.getIndex()]));
        return dataSet;
    }

    public List<DataSet> readDataSets() throws FileNotFoundException, ParseException, UnsupportedEncodingException {
        ArrayList<DataSet> datasets = new ArrayList<DataSet>();
        while (this.fileScanner.hasNext()) {
            datasets.add(this.nextDataSet());
        }
        return datasets;
    }
}

