/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice;

import com.sun.javafx.scene.control.GlobalMenuAdapter;
import com.sun.javafx.stage.StageHelper;
import de.codecentric.centerdevice.dialogs.about.AboutStageBuilder;
import de.codecentric.centerdevice.glass.AdapterContext;
import de.codecentric.centerdevice.glass.GlassAdaptionException;
import de.codecentric.centerdevice.glass.MacApplicationAdapter;
import de.codecentric.centerdevice.glass.TKSystemMenuAdapter;
import de.codecentric.centerdevice.icns.IcnsParser;
import de.codecentric.centerdevice.icns.IcnsType;
import de.codecentric.centerdevice.labels.LabelMaker;
import de.codecentric.centerdevice.labels.LabelName;
import de.codecentric.centerdevice.listener.MenuBarSyncListener;
import de.codecentric.centerdevice.listener.WindowMenuUpdateListener;
import de.codecentric.centerdevice.util.MenuBarUtils;
import de.codecentric.centerdevice.util.StageUtils;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import javafx.collections.ListChangeListener;
import javafx.scene.Parent;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class MenuToolkit {
    private static final String APP_NAME = "Apple";
    private final TKSystemMenuAdapter systemMenuAdapter;
    private final MacApplicationAdapter applicationAdapter;
    private final LabelMaker labelMaker;

    private MenuToolkit(AdapterContext adapterContext, LabelMaker labelMaker) {
        this.systemMenuAdapter = adapterContext.getSystemMenuAdapter();
        this.applicationAdapter = adapterContext.getApplicationAdapter();
        this.labelMaker = labelMaker;
    }

    public static MenuToolkit toolkit() {
        return MenuToolkit.toolkit(Locale.ENGLISH);
    }

    public static MenuToolkit toolkit(Locale locale) {
        return MenuToolkit.toolkit(new LabelMaker(locale));
    }

    public static MenuToolkit toolkit(LabelMaker labelMaker) {
        AdapterContext context = AdapterContext.getContext();
        if (context == null) {
            return null;
        }
        return new MenuToolkit(context, labelMaker);
    }

    public Menu createDefaultApplicationMenu(String appName) {
        return this.createDefaultApplicationMenu(appName, this.createDefaultAboutStage(appName));
    }

    public Menu createDefaultApplicationMenu(String appName, Stage aboutStage) {
        return new Menu(APP_NAME, null, new MenuItem[]{this.createAboutMenuItem(appName, aboutStage), new SeparatorMenuItem(), this.createHideMenuItem(appName), this.createHideOthersMenuItem(), this.createUnhideAllMenuItem(), new SeparatorMenuItem(), this.createQuitMenuItem(appName)});
    }

    public MenuItem createAboutMenuItem(String appName) {
        return this.createAboutMenuItem(appName, this.createDefaultAboutStage(appName));
    }

    private Stage createDefaultAboutStage(String appName) {
        AboutStageBuilder stageBuilder = AboutStageBuilder.start(this.labelMaker.getLabel(LabelName.ABOUT, appName)).withAppName(appName).withCloseOnFocusLoss().withCopyright("Copyright \u00a9 " + Calendar.getInstance().get(1));
        try {
            IcnsParser parser = IcnsParser.forFile("/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/GenericApplicationIcon.icns");
            stageBuilder = stageBuilder.withImage(new Image(parser.getIconStream(IcnsType.ic08)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stageBuilder.build();
    }

    public MenuItem createAboutMenuItem(String appName, Stage aboutStage) {
        MenuItem about = new MenuItem(this.labelMaker.getLabel(LabelName.ABOUT, appName));
        about.setOnAction(event -> aboutStage.show());
        return about;
    }

    public MenuItem createQuitMenuItem(String appName) {
        MenuItem quit = new MenuItem(this.labelMaker.getLabel(LabelName.QUIT, appName));
        quit.setOnAction(event -> this.applicationAdapter.quit());
        quit.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        return quit;
    }

    public MenuItem createUnhideAllMenuItem() {
        MenuItem unhideAll = new MenuItem(this.labelMaker.getLabel(LabelName.SHOW_ALL, new Object[0]));
        unhideAll.setOnAction(event -> this.applicationAdapter.unhideAllApplications());
        return unhideAll;
    }

    public MenuItem createHideOthersMenuItem() {
        MenuItem hideOthers = new MenuItem(this.labelMaker.getLabel(LabelName.HIDE_OTHERS, new Object[0]));
        hideOthers.setOnAction(event -> this.applicationAdapter.hideOtherApplications());
        hideOthers.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCombination.META_DOWN, KeyCombination.ALT_DOWN}));
        return hideOthers;
    }

    public MenuItem createHideMenuItem(String appName) {
        MenuItem hide = new MenuItem(this.labelMaker.getLabel(LabelName.HIDE, appName));
        hide.setOnAction(event -> this.applicationAdapter.hide());
        hide.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        return hide;
    }

    public MenuItem createMinimizeMenuItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.MINIMIZE, new Object[0]));
        menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        menuItem.setOnAction(event -> StageUtils.minimizeFocusedStage());
        return menuItem;
    }

    public MenuItem createZoomMenuItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.ZOOM, new Object[0]));
        menuItem.setOnAction(event -> StageUtils.zoomFocusedStage());
        return menuItem;
    }

    public MenuItem createCloseWindowMenuItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.CLOSE_WINDOW, new Object[0]));
        menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        menuItem.setOnAction(event -> StageUtils.closeCurrentStage());
        return menuItem;
    }

    public MenuItem createBringAllToFrontItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.BRING_ALL_TO_FRONT, new Object[0]));
        menuItem.setOnAction(event -> StageUtils.bringAllToFront());
        return menuItem;
    }

    public MenuItem createCycleWindowsItem() {
        MenuItem menuItem = new MenuItem(this.labelMaker.getLabel(LabelName.CYCLE_THROUGH_WINDOWS, new Object[0]));
        menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.BACK_QUOTE, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
        menuItem.setOnAction(event -> StageUtils.focusNextStage());
        return menuItem;
    }

    public void setApplicationMenu(Menu menu) {
        try {
            this.systemMenuAdapter.setAppleMenu(GlobalMenuAdapter.adapt((Menu)menu));
        }
        catch (Throwable e) {
            throw new GlassAdaptionException(e);
        }
    }

    public void setGlobalMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
        MenuBarSyncListener.register(menuBar);
    }

    public void unsetGlobalMenuBar() {
        MenuBarSyncListener.unregister();
    }

    public void setMenuBar(MenuBar menuBar) {
        StageHelper.getStages().forEach(stage -> this.setMenuBar((Stage)stage, menuBar));
    }

    public void setMenuBar(Stage stage, MenuBar menuBar) {
        Parent parent = stage.getScene().getRoot();
        if (parent instanceof Pane) {
            this.setMenuBar((Pane)parent, menuBar);
        }
    }

    public void setMenuBar(Pane pane, MenuBar menuBar) {
        this.setApplicationMenu(this.extractApplicationMenu(menuBar));
        MenuBarUtils.setMenuBar(pane, menuBar);
    }

    public void autoAddWindowMenuItems(Menu menu) {
        menu.getItems().add((Object)new SeparatorMenuItem());
        StageHelper.getStages().addListener((ListChangeListener)new WindowMenuUpdateListener(menu));
    }

    public void setForceQuitOnCmdQ(boolean forceQuit) {
        this.applicationAdapter.setForceQuitOnCmdQ(forceQuit);
    }

    protected Menu extractApplicationMenu(MenuBar menuBar) {
        return (Menu)menuBar.getMenus().get(0);
    }
}

