/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.graph.RubberBand;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.graphPainter.DependencyPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class ExtendsDependencyPainter
implements DependencyPainter {
    protected static final float strokeWidthDefault = 1.0f;
    protected static final float strokeWidthSelected = 2.0f;
    static final Color normalColour = Color.BLACK;
    private static final BasicStroke normalSelected = new BasicStroke(2.0f);
    private static final BasicStroke normalUnselected = new BasicStroke(1.0f);
    static final int ARROW_SIZE = 18;
    static final double ARROW_ANGLE = 0.5235987755982988;

    @Override
    public void paint(Graphics2D g, Dependency dependency, boolean hasFocus) {
        if (!(dependency instanceof ExtendsDependency)) {
            throw new IllegalArgumentException("Not a ExtendsDependency");
        }
        Stroke oldStroke = g.getStroke();
        ExtendsDependency d = (ExtendsDependency)dependency;
        boolean isSelected = d.isSelected() && hasFocus;
        g.setStroke(isSelected ? normalSelected : normalUnselected);
        Dependency.Line line = d.computeLine();
        this.paintArrow(g, line.from, line.to);
        g.setStroke(oldStroke);
    }

    public void paintIntermediateDependency(Graphics2D g, RubberBand rb) {
        g.setStroke(normalUnselected);
        this.paintArrow(g, rb.startPt, rb.endPt);
    }

    private void paintArrow(Graphics2D g, Point pFrom, Point pTo) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(normalColour);
        double angle = Math.atan2(-(pFrom.y - pTo.y), pFrom.x - pTo.x);
        Point pArrow = new Point(pTo.x + (int)(16.0 * Math.cos(angle)), pTo.y - (int)(16.0 * Math.sin(angle)));
        int[] xPoints = new int[]{pTo.x, pTo.x + (int)(18.0 * Math.cos(angle + 0.5235987755982988)), pTo.x + (int)(18.0 * Math.cos(angle - 0.5235987755982988))};
        int[] yPoints = new int[]{pTo.y, pTo.y - (int)(18.0 * Math.sin(angle + 0.5235987755982988)), pTo.y - (int)(18.0 * Math.sin(angle - 0.5235987755982988))};
        g.drawPolygon(xPoints, yPoints, 3);
        g.drawLine(pFrom.x, pFrom.y, pArrow.x, pArrow.y);
    }

    @Override
    public Point getPopupMenuPosition(Dependency dependency) {
        if (!(dependency instanceof ExtendsDependency)) {
            throw new IllegalArgumentException("Not a ExtendsDependency");
        }
        Point pFrom = new Point(dependency.getFrom().getX() + dependency.getFrom().getWidth() / 2, dependency.getFrom().getY() + dependency.getFrom().getHeight() / 2);
        Point pTo = new Point(dependency.getTo().getX() + dependency.getTo().getWidth() / 2, dependency.getTo().getY() + dependency.getTo().getHeight() / 2);
        double angle = Math.atan2(-(pFrom.y - pTo.y), pFrom.x - pTo.x);
        pTo = dependency.getTo().getAttachment(angle);
        int[] xPoints = new int[]{pTo.x, pTo.x + (int)(18.0 * Math.cos(angle + 0.5235987755982988)), pTo.x + (int)(18.0 * Math.cos(angle - 0.5235987755982988))};
        int[] yPoints = new int[]{pTo.y, pTo.y - (int)(18.0 * Math.sin(angle + 0.5235987755982988)), pTo.y - (int)(18.0 * Math.sin(angle - 0.5235987755982988))};
        return new Point((xPoints[0] + xPoints[1] + xPoints[2]) / 3, (yPoints[0] + yPoints[1] + yPoints[2]) / 3);
    }
}

