/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.MIDletDeployer;
import bluej.pkgmgr.MIDletDeploymentTableModel;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.FileUtility;
import bluej.utility.MiksGridLayout;
import bluej.utility.SortedProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class MIDletDeploymentDialog
extends EscapeDialog
implements ListSelectionListener {
    private static final String MIDLET_FILE = "midlet.defs";
    private static final String EXCLUDE_LABEL = Config.getString("midlet.deployment.midlets.exclude");
    private static final String INCLUDE_LABEL = Config.getString("midlet.deployment.midlets.include");
    private MIDletDeploymentTableModel tableModel;
    private JTable table;
    private JTextField suiteName;
    private JTextField suiteVendor;
    private JTextField suiteVersion;
    private JTextField suiteDescription;
    private JButton changeButton;
    private JButton inOutButton;
    private JButton upButton;
    private JButton downButton;
    private JRadioButton runToolkit;
    private JRadioButton createFiles;
    private File verified;
    private File projectDir;
    private File jadFile;
    private File jarFile;
    private File midletsFile;
    private List<String> midlets;
    private Manifest manifest;
    private PkgMgrFrame frame;
    private boolean ok;
    private SortedProperties props;
    private boolean[] exclude;

    public MIDletDeploymentDialog(PkgMgrFrame parent, File verified, List<String> midlets) {
        super(parent, Config.getString("midlet.deployment.title"), true);
        this.frame = parent;
        this.projectDir = parent.getProject().getProjectDir();
        this.verified = verified;
        this.midlets = midlets;
        this.manifest = new Manifest();
        this.midletsFile = new File(this.projectDir, MIDLET_FILE);
        this.loadMidletFile();
        this.makeDialog();
    }

    private void loadMidletFile() {
        FileInputStream fis = null;
        this.props = new SortedProperties();
        if (this.midletsFile.exists()) {
            try {
                fis = new FileInputStream(this.midletsFile);
                this.props.load(fis);
                fis.close();
            }
            catch (IOException e) {
                Debug.reportError("Problem reading midlets file in root package");
                e.printStackTrace();
            }
        }
    }

    private void makeDialog() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BlueJTheme.dialogBorder);
        panel.add((Component)this.makeMIDletSuitePanel(), "First");
        panel.add((Component)this.makeMIDletsBox(), "Center");
        panel.add((Component)this.makeOkCancelButtonPanel(), "Last");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.add((Component)this.makeRadioPanel(), "First");
        mainPanel.add((Component)panel, "Center");
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    private JPanel makeRadioPanel() {
        String toolkitText = Config.getString("midlet.deployment.runWTK");
        String genFilesText = Config.getString("midlet.deployment.generateFiles");
        this.runToolkit = new JRadioButton(toolkitText, true);
        this.createFiles = new JRadioButton(genFilesText, false);
        JPanel radioPanel = new JPanel(new GridLayout(2, 1));
        radioPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        radioPanel.add(this.runToolkit);
        radioPanel.add(this.createFiles);
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.runToolkit);
        bGroup.add(this.createFiles);
        return radioPanel;
    }

    private JPanel makeMIDletSuitePanel() {
        JPanel panel = new JPanel(new MiksGridLayout(4, 2, 10, 5));
        panel.setAlignmentX(0.0f);
        String title = Config.getString("midlet.deployment.suite.title");
        String name = Config.getString("midlet.deployment.suite.name");
        String vers = Config.getString("midlet.deployment.suite.version");
        String vend = Config.getString("midlet.deployment.suite.vendor");
        String desc = Config.getString("midlet.deployment.suite.description");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BlueJTheme.generalBorder));
        JLabel suiteNameLabel = new JLabel(name);
        JLabel suiteVersionLabel = new JLabel(vers);
        JLabel suiteVendorLabel = new JLabel(vend);
        JLabel suiteDescriptionLabel = new JLabel(desc);
        name = this.props.getProperty("midlet.suite.name", this.projectDir.getName());
        vers = this.props.getProperty("midlet.suite.version", "1.0");
        vend = this.props.getProperty("midlet.suite.vendor", "BlueJ ME");
        desc = this.props.getProperty("midlet.suite.description", "");
        panel.add(suiteNameLabel);
        this.suiteName = new JTextField(name);
        panel.add(this.suiteName);
        panel.add(suiteVersionLabel);
        this.suiteVersion = new JTextField(vers);
        panel.add(this.suiteVersion);
        panel.add(suiteVendorLabel);
        this.suiteVendor = new JTextField(vend);
        panel.add(this.suiteVendor);
        panel.add(suiteDescriptionLabel);
        this.suiteDescription = new JTextField(desc);
        panel.add(this.suiteDescription);
        return panel;
    }

    private Box makeMIDletsBox() {
        this.tableModel = new MIDletDeploymentTableModel(this.midlets, this.projectDir, this.props);
        this.exclude = this.tableModel.getExcluded();
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(25);
        this.table.setShowGrid(false);
        this.table.setOpaque(true);
        this.table.setDragEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setBackground(this.getBackground());
        this.table.setIntercellSpacing(new Dimension());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setAutoResizeMode(4);
        this.table.setSelectionMode(0);
        TableColumnModel colModel = this.table.getColumnModel();
        colModel.getColumn(2).setCellRenderer(new IconColumnRenderer());
        this.table.getTableHeader().setDefaultRenderer(new HeaderRenderer());
        this.table.setDefaultRenderer(String.class, new MidletTableRenderer());
        colModel.getColumn(0).setPreferredWidth(90);
        colModel.getColumn(1).setPreferredWidth(55);
        colModel.getColumn(2).setPreferredWidth(30);
        Dimension prefSize = this.table.getMaximumSize();
        Dimension scrollPrefSize = this.table.getPreferredScrollableViewportSize();
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.setPreferredSize(new Dimension(scrollPrefSize.width, prefSize.height + 50));
        scroller.setBorder(BlueJTheme.generalBorder);
        String title = Config.getString("midlet.deployment.midlets.title");
        Box box = new Box(3);
        box.setBorder(BorderFactory.createTitledBorder(title));
        box.add(scroller);
        box.add(this.makeButtonPanel());
        this.table.setRowSelectionInterval(0, 0);
        return box;
    }

    private JPanel makeButtonPanel() {
        this.changeButton = new JButton(Config.getString("midlet.deployment.midlets.changeicon"));
        this.upButton = new JButton(Config.getString("midlet.deployment.midlets.moveup"));
        this.downButton = new JButton(Config.getString("midlet.deployment.midlets.movedown"));
        this.inOutButton = new JButton();
        this.changeButton.addActionListener(new ChangeIconListener());
        this.inOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = MIDletDeploymentDialog.this.table.getSelectedRow();
                ((MIDletDeploymentDialog)MIDletDeploymentDialog.this).exclude[row] = !MIDletDeploymentDialog.this.exclude[row];
                MIDletDeploymentDialog.this.tableModel.fireTableRowsUpdated(row, row);
                if (MIDletDeploymentDialog.this.exclude[row]) {
                    MIDletDeploymentDialog.this.inOutButton.setText(INCLUDE_LABEL);
                } else {
                    MIDletDeploymentDialog.this.inOutButton.setText(EXCLUDE_LABEL);
                }
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = MIDletDeploymentDialog.this.table.getSelectedRow();
                if (row > 0) {
                    MIDletDeploymentDialog.this.tableModel.moveRowUp(row);
                    MIDletDeploymentDialog.this.swapExcluded(row, row - 1);
                    MIDletDeploymentDialog.this.table.setRowSelectionInterval(row - 1, row - 1);
                }
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = MIDletDeploymentDialog.this.table.getSelectedRow();
                if (row < MIDletDeploymentDialog.this.tableModel.getRowCount() - 1) {
                    MIDletDeploymentDialog.this.tableModel.moveRowDown(row);
                    MIDletDeploymentDialog.this.swapExcluded(row, row + 1);
                    MIDletDeploymentDialog.this.table.setRowSelectionInterval(row + 1, row + 1);
                }
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.changeButton);
        buttonPanel.add(this.inOutButton);
        buttonPanel.add(this.upButton);
        buttonPanel.add(this.downButton);
        return buttonPanel;
    }

    private void swapExcluded(int i, int j) {
        boolean temp = this.exclude[j];
        this.exclude[j] = this.exclude[i];
        this.exclude[i] = temp;
    }

    private JPanel makeOkCancelButtonPanel() {
        JButton okButton = BlueJTheme.getOkButton();
        JButton cancelButton = BlueJTheme.getCancelButton();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MIDletDeploymentDialog.this.doOk();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MIDletDeploymentDialog.this.doCancel();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.getRootPane().setDefaultButton(okButton);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    boolean runEmulator() {
        this.ok = false;
        this.setVisible(true);
        return this.ok;
    }

    private void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }

    private void doOk() {
        this.createJar();
        this.createJad();
        this.ok = false;
        if (this.saveMIDletSuite() && this.runToolkit.isSelected()) {
            this.ok = true;
        }
        this.setVisible(false);
        this.frame.setStatus(Config.getString("pkgmgr.midlet.deploying"));
    }

    private boolean saveMIDletSuite() {
        this.props = new SortedProperties();
        this.props.setProperty("midlet.suite.name", this.suiteName.getText().trim());
        this.props.setProperty("midlet.suite.version", this.suiteVersion.getText().trim());
        this.props.setProperty("midlet.suite.vendor", this.suiteVendor.getText().trim());
        this.props.setProperty("midlet.suite.description", this.suiteDescription.getText().trim());
        this.tableModel.saveTableToProps(this.props);
        this.midletsFile.delete();
        try {
            this.midletsFile.createNewFile();
            FileOutputStream output = new FileOutputStream(this.midletsFile);
            this.props.store(output, "MIDlet suite file");
            output.close();
        }
        catch (IOException e) {
            Debug.reportError("Error saving MIDlet suite file " + this.midletsFile + ": " + e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar() {
        FileOutputStream oStream = null;
        ZipOutputStream jStream = null;
        this.verifySuiteTextFields();
        this.jarFile = new File(this.projectDir, this.projectDir.getName() + ".jar");
        try {
            Attributes attr = this.manifest.getMainAttributes();
            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attr.putValue("MIDlet-Name", this.suiteName.getText());
            attr.putValue("MIDlet-Version", this.suiteVersion.getText());
            attr.putValue("MIDlet-Vendor", this.suiteVendor.getText());
            oStream = new FileOutputStream(this.jarFile);
            jStream = new JarOutputStream((OutputStream)oStream, this.manifest);
            this.writeDirToJar(this.verified, "", (JarOutputStream)jStream, this.jarFile.getCanonicalFile());
            File resources = new File(this.projectDir, "res");
            if (resources.exists()) {
                this.writeDirToJar(resources, "", (JarOutputStream)jStream, this.jarFile.getCanonicalFile());
            }
        }
        catch (IOException e) {
            DialogManager.showError(this.frame, "error-writing-jar");
            Debug.reportError("Problem writing jar file: " + e);
        }
        finally {
            try {
                if (jStream != null) {
                    jStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void writeDirToJar(File sourceDir, String pathPrefix, JarOutputStream jStream, File outputFile) throws IOException {
        File[] dir = sourceDir.listFiles();
        for (int i = 0; i < dir.length; ++i) {
            if (dir[i].isDirectory()) {
                this.writeDirToJar(dir[i], pathPrefix + dir[i].getName() + "/", jStream, outputFile);
                continue;
            }
            this.writeJarEntry(dir[i], jStream, pathPrefix + dir[i].getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJarEntry(File file, JarOutputStream jStream, String entryName) throws IOException {
        InputStream in = null;
        try {
            jStream.putNextEntry(new ZipEntry(entryName));
            in = new FileInputStream(file);
            FileUtility.copyStream(in, jStream);
        }
        catch (ZipException ze) {
            Debug.message("Problem writing zipentry to jarfile " + ze);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJad() {
        this.jadFile = new File(this.projectDir, this.projectDir.getName() + ".jad");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(this.jadFile));
            pw.println("MIDlet-Name: " + this.suiteName.getText());
            pw.println("MIDlet-Version: " + this.suiteVersion.getText());
            pw.println("MIDlet-Vendor: " + this.suiteVendor.getText());
            String description = this.suiteDescription.getText().trim();
            if (!description.equals("")) {
                pw.println("MIDlet-Description: " + description);
            }
            pw.println("MicroEdition-Profile: MIDP-2.0");
            pw.println("MicroEdition-Configuration: CLDC-1.1");
            pw.println("MIDlet-Jar-URL: " + this.jarFile.getName());
            pw.println("MIDlet-Jar-Size: " + this.jarFile.length());
            this.tableModel.writeTableToPrintWriter(pw);
        }
        catch (IOException ioe) {
            Debug.message("Problem writing jad file");
            ioe.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    File getJadFile() {
        return this.jadFile;
    }

    private void verifySuiteTextFields() {
        String vendor = this.suiteVendor.getText().trim();
        String version = this.suiteVersion.getText().trim();
        String name = this.suiteName.getText().trim();
        if (vendor.equals("")) {
            vendor = "BlueJ ME";
        }
        if (version.equals("")) {
            version = "1.0";
        }
        if (name.equals("")) {
            name = this.projectDir.getName();
        }
        this.suiteVendor.setText(vendor);
        this.suiteVersion.setText(version);
        this.suiteName.setText(name);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (lse.getValueIsAdjusting()) {
            return;
        }
        if (this.table.isRowSelected(0)) {
            this.upButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(true);
        }
        if (this.table.isRowSelected(this.tableModel.getRowCount() - 1)) {
            this.downButton.setEnabled(false);
        } else {
            this.downButton.setEnabled(true);
        }
        if (this.exclude[this.table.getSelectedRow()]) {
            this.inOutButton.setText(INCLUDE_LABEL);
        } else {
            this.inOutButton.setText(EXCLUDE_LABEL);
        }
    }

    private class IconFileFilter
    extends FileFilter {
        private IconFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".png") || f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg");
        }

        @Override
        public String getDescription() {
            return Config.getString("midlet.deployment.filechooser.description");
        }
    }

    private class ChangeIconListener
    implements ActionListener {
        private ChangeIconListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String iconsDir = MIDletDeploymentDialog.this.projectDir + File.separator + MIDletDeployer.ICONS_DIR;
            JFileChooser chooser = new JFileChooser(iconsDir);
            chooser.setFileFilter(new IconFileFilter());
            chooser.setFileSelectionMode(2);
            chooser.setDialogTitle(Config.getString("midlet.deployment.filechooser.title"));
            int returnVal = chooser.showOpenDialog(MIDletDeploymentDialog.this.getParent());
            if (returnVal == 0) {
                File chosenFile = chooser.getSelectedFile();
                File fileInProj = new File(iconsDir, chosenFile.getName());
                if (!chosenFile.getParent().equals(iconsDir)) {
                    if (fileInProj.exists() && DialogManager.askQuestion(MIDletDeploymentDialog.this.frame, "error-midleticon-exists") != 0) {
                        return;
                    }
                    try {
                        FileUtility.copyFile(chosenFile, fileInProj);
                    }
                    catch (IOException ioe) {
                        Debug.reportError("Could not copy chosen icon file into <project dir>/res/icons.");
                    }
                }
                try {
                    URL url = fileInProj.toURI().toURL();
                    String selectedFile = url.toString();
                    int row = MIDletDeploymentDialog.this.table.getSelectedRow();
                    MIDletDeploymentDialog.this.tableModel.setValueAt(selectedFile, row, 2);
                }
                catch (MalformedURLException mue) {
                    Debug.reportError("Could not create URL from file selected by chooser.");
                    mue.printStackTrace();
                }
            }
        }
    }

    private class IconColumnRenderer
    extends DefaultTableCellRenderer {
        private IconColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean f, int r, int c) {
            this.setIcon((ImageIcon)value);
            this.setText("");
            this.setHorizontalAlignment(0);
            if (isSelected) {
                this.setBackground(MIDletDeploymentDialog.this.table.getSelectionBackground());
            } else {
                this.setBackground(MIDletDeploymentDialog.this.table.getBackground());
            }
            if (MIDletDeploymentDialog.this.exclude[r]) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    private class MidletTableRenderer
    extends DefaultTableCellRenderer {
        private MidletTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            Border b = BorderFactory.createLineBorder(this.getBackground(), 3);
            this.setBorder(b);
            this.setText((String)value);
            this.setHorizontalAlignment(10);
            if (column == 1) {
                this.setBackground(Color.white);
                b = BorderFactory.createLineBorder(Color.gray);
                b = BorderFactory.createCompoundBorder(this.getBorder(), b);
                this.setBorder(b);
            }
            if (MIDletDeploymentDialog.this.exclude[row]) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    private class HeaderRenderer
    extends DefaultTableCellRenderer {
        private HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean f, int r, int c) {
            this.setText((String)value);
            this.setHorizontalAlignment(0);
            if (isSelected) {
                this.setBackground(MIDletDeploymentDialog.this.table.getBackground());
            }
            return this;
        }
    }
}

